/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.AbstractCommitLogService;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.utils.Clock;

class PeriodicCommitLogService
extends AbstractCommitLogService {
    private static final long blockWhenSyncLagsNanos = TimeUnit.MILLISECONDS.toNanos(DatabaseDescriptor.getPeriodicCommitLogSyncBlock());

    public PeriodicCommitLogService(CommitLog commitLog) {
        super(commitLog, "PERIODIC-COMMIT-LOG-SYNCER", DatabaseDescriptor.getCommitLogSyncPeriod(), !commitLog.configuration.useCompression() && !commitLog.configuration.useEncryption());
    }

    @Override
    protected void maybeWaitForSync(CommitLogSegment.Allocation alloc) {
        long expectedSyncTime = Clock.Global.nanoTime() - blockWhenSyncLagsNanos;
        if (this.lastSyncedAt < expectedSyncTime) {
            this.pending.incrementAndGet();
            this.awaitSyncAt(expectedSyncTime, this.commitLog.metrics.waitingOnCommit.time());
            this.pending.decrementAndGet();
        }
    }
}

