/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.protocol.proto.EditLogProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.StreamLimiter;
import org.apache.hadoop.hdfs.util.XMLUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.ipc.ClientId;
import org.apache.hadoop.ipc.RpcConstants;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class FSEditLogOp {
    public final FSEditLogOpCodes opCode;
    long txid;
    byte[] rpcClientId;
    int rpcCallId;
    private static final ImmutableMap<String, FsAction> FSACTION_SYMBOL_MAP = FSEditLogOp.fsActionMap();

    final void reset() {
        this.txid = -12345L;
        this.rpcClientId = RpcConstants.DUMMY_CLIENT_ID;
        this.rpcCallId = -2;
        this.resetSubFields();
    }

    abstract void resetSubFields();

    private static ImmutableMap<String, FsAction> fsActionMap() {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (FsAction v : FsAction.values()) {
            b.put((Object)v.SYMBOL, (Object)v);
        }
        return b.build();
    }

    @VisibleForTesting
    protected FSEditLogOp(FSEditLogOpCodes opCode) {
        this.opCode = opCode;
        this.reset();
    }

    public long getTransactionId() {
        Preconditions.checkState((this.txid != -12345L ? 1 : 0) != 0);
        return this.txid;
    }

    public String getTransactionIdStr() {
        return this.txid == -12345L ? "(none)" : "" + this.txid;
    }

    public boolean hasTransactionId() {
        return this.txid != -12345L;
    }

    public void setTransactionId(long txid) {
        this.txid = txid;
    }

    public boolean hasRpcIds() {
        return this.rpcClientId != RpcConstants.DUMMY_CLIENT_ID && this.rpcCallId != -2;
    }

    public byte[] getClientId() {
        Preconditions.checkState((this.rpcClientId != RpcConstants.DUMMY_CLIENT_ID ? 1 : 0) != 0);
        return this.rpcClientId;
    }

    public void setRpcClientId(byte[] clientId) {
        this.rpcClientId = clientId;
    }

    public int getCallId() {
        Preconditions.checkState((this.rpcCallId != -2 ? 1 : 0) != 0);
        return this.rpcCallId;
    }

    public void setRpcCallId(int callId) {
        this.rpcCallId = callId;
    }

    abstract void readFields(DataInputStream var1, int var2) throws IOException;

    public abstract void writeFields(DataOutputStream var1) throws IOException;

    private static void writeRpcIds(byte[] clientId, int callId, DataOutputStream out) throws IOException {
        FSImageSerialization.writeBytes(clientId, out);
        FSImageSerialization.writeInt(callId, out);
    }

    void readRpcIds(DataInputStream in, int logVersion) throws IOException {
        if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_SUPPORT_RETRYCACHE, logVersion)) {
            this.rpcClientId = FSImageSerialization.readBytes(in);
            this.rpcCallId = FSImageSerialization.readInt(in);
        }
    }

    void readRpcIdsFromXml(XMLUtils.Stanza st) {
        this.rpcClientId = st.hasChildren("RPC_CLIENTID") ? ClientId.toBytes((String)st.getValue("RPC_CLIENTID")) : RpcConstants.DUMMY_CLIENT_ID;
        this.rpcCallId = st.hasChildren("RPC_CALLID") ? Integer.parseInt(st.getValue("RPC_CALLID")) : -2;
    }

    private static void appendRpcIdsToString(StringBuilder builder, byte[] clientId, int callId) {
        builder.append(", RpcClientId=");
        builder.append(ClientId.toString((byte[])clientId));
        builder.append(", RpcCallId=");
        builder.append(callId);
    }

    private static void appendRpcIdsToXml(ContentHandler contentHandler, byte[] clientId, int callId) throws SAXException {
        XMLUtils.addSaxString(contentHandler, "RPC_CLIENTID", ClientId.toString((byte[])clientId));
        XMLUtils.addSaxString(contentHandler, "RPC_CALLID", Integer.toString(callId));
    }

    private static List<XAttr> readXAttrsFromEditLog(DataInputStream in, int logVersion) throws IOException {
        if (!NameNodeLayoutVersion.supports(NameNodeLayoutVersion.Feature.XATTRS, logVersion)) {
            return null;
        }
        EditLogProtos.XAttrEditLogProto proto = EditLogProtos.XAttrEditLogProto.parseDelimitedFrom(in);
        return PBHelperClient.convertXAttrs(proto.getXAttrsList());
    }

    private static short readShort(DataInputStream in) throws IOException {
        return Short.parseShort(FSImageSerialization.readString(in));
    }

    private static long readLong(DataInputStream in) throws IOException {
        return Long.parseLong(FSImageSerialization.readString(in));
    }

    public void outputToXml(ContentHandler contentHandler) throws SAXException {
        contentHandler.startElement("", "", "RECORD", new AttributesImpl());
        XMLUtils.addSaxString(contentHandler, "OPCODE", this.opCode.toString());
        contentHandler.startElement("", "", "DATA", new AttributesImpl());
        XMLUtils.addSaxString(contentHandler, "TXID", "" + this.txid);
        this.toXml(contentHandler);
        contentHandler.endElement("", "", "DATA");
        contentHandler.endElement("", "", "RECORD");
    }

    protected abstract void toXml(ContentHandler var1) throws SAXException;

    abstract void fromXml(XMLUtils.Stanza var1) throws XMLUtils.InvalidXmlException;

    public void decodeXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        this.txid = Long.parseLong(st.getValue("TXID"));
        this.fromXml(st);
    }

    public static void blockToXml(ContentHandler contentHandler, Block block) throws SAXException {
        contentHandler.startElement("", "", "BLOCK", new AttributesImpl());
        XMLUtils.addSaxString(contentHandler, "BLOCK_ID", Long.toString(block.getBlockId()));
        XMLUtils.addSaxString(contentHandler, "NUM_BYTES", Long.toString(block.getNumBytes()));
        XMLUtils.addSaxString(contentHandler, "GENSTAMP", Long.toString(block.getGenerationStamp()));
        contentHandler.endElement("", "", "BLOCK");
    }

    public static Block blockFromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        long blockId = Long.parseLong(st.getValue("BLOCK_ID"));
        long numBytes = Long.parseLong(st.getValue("NUM_BYTES"));
        long generationStamp = Long.parseLong(st.getValue("GENSTAMP"));
        return new Block(blockId, numBytes, generationStamp);
    }

    public static void delegationTokenToXml(ContentHandler contentHandler, DelegationTokenIdentifier token) throws SAXException {
        contentHandler.startElement("", "", "DELEGATION_TOKEN_IDENTIFIER", new AttributesImpl());
        XMLUtils.addSaxString(contentHandler, "KIND", token.getKind().toString());
        XMLUtils.addSaxString(contentHandler, "SEQUENCE_NUMBER", Integer.toString(token.getSequenceNumber()));
        XMLUtils.addSaxString(contentHandler, "OWNER", token.getOwner().toString());
        XMLUtils.addSaxString(contentHandler, "RENEWER", token.getRenewer().toString());
        XMLUtils.addSaxString(contentHandler, "REALUSER", token.getRealUser().toString());
        XMLUtils.addSaxString(contentHandler, "ISSUE_DATE", Long.toString(token.getIssueDate()));
        XMLUtils.addSaxString(contentHandler, "MAX_DATE", Long.toString(token.getMaxDate()));
        XMLUtils.addSaxString(contentHandler, "MASTER_KEY_ID", Integer.toString(token.getMasterKeyId()));
        contentHandler.endElement("", "", "DELEGATION_TOKEN_IDENTIFIER");
    }

    public static DelegationTokenIdentifier delegationTokenFromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        String kind = st.getValue("KIND");
        if (!kind.equals(DelegationTokenIdentifier.HDFS_DELEGATION_KIND.toString())) {
            throw new XMLUtils.InvalidXmlException("can't understand DelegationTokenIdentifier KIND " + kind);
        }
        int seqNum = Integer.parseInt(st.getValue("SEQUENCE_NUMBER"));
        String owner = st.getValue("OWNER");
        String renewer = st.getValue("RENEWER");
        String realuser = st.getValue("REALUSER");
        long issueDate = Long.parseLong(st.getValue("ISSUE_DATE"));
        long maxDate = Long.parseLong(st.getValue("MAX_DATE"));
        int masterKeyId = Integer.parseInt(st.getValue("MASTER_KEY_ID"));
        DelegationTokenIdentifier token = new DelegationTokenIdentifier(new Text(owner), new Text(renewer), new Text(realuser));
        token.setSequenceNumber(seqNum);
        token.setIssueDate(issueDate);
        token.setMaxDate(maxDate);
        token.setMasterKeyId(masterKeyId);
        return token;
    }

    public static void delegationKeyToXml(ContentHandler contentHandler, DelegationKey key) throws SAXException {
        contentHandler.startElement("", "", "DELEGATION_KEY", new AttributesImpl());
        XMLUtils.addSaxString(contentHandler, "KEY_ID", Integer.toString(key.getKeyId()));
        XMLUtils.addSaxString(contentHandler, "EXPIRY_DATE", Long.toString(key.getExpiryDate()));
        if (key.getEncodedKey() != null) {
            XMLUtils.addSaxString(contentHandler, "KEY", Hex.encodeHexString((byte[])key.getEncodedKey()));
        }
        contentHandler.endElement("", "", "DELEGATION_KEY");
    }

    public static DelegationKey delegationKeyFromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        int keyId = Integer.parseInt(st.getValue("KEY_ID"));
        long expiryDate = Long.parseLong(st.getValue("EXPIRY_DATE"));
        byte[] key = null;
        try {
            key = Hex.decodeHex((char[])st.getValue("KEY").toCharArray());
        }
        catch (DecoderException e) {
            throw new XMLUtils.InvalidXmlException(e.toString());
        }
        catch (XMLUtils.InvalidXmlException invalidXmlException) {
            // empty catch block
        }
        return new DelegationKey(keyId, expiryDate, key);
    }

    public static void permissionStatusToXml(ContentHandler contentHandler, PermissionStatus perm) throws SAXException {
        contentHandler.startElement("", "", "PERMISSION_STATUS", new AttributesImpl());
        XMLUtils.addSaxString(contentHandler, "USERNAME", perm.getUserName());
        XMLUtils.addSaxString(contentHandler, "GROUPNAME", perm.getGroupName());
        FSEditLogOp.fsPermissionToXml(contentHandler, perm.getPermission());
        contentHandler.endElement("", "", "PERMISSION_STATUS");
    }

    public static PermissionStatus permissionStatusFromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        XMLUtils.Stanza status = st.getChildren("PERMISSION_STATUS").get(0);
        String username = status.getValue("USERNAME");
        String groupname = status.getValue("GROUPNAME");
        FsPermission mode = FSEditLogOp.fsPermissionFromXml(status);
        return new PermissionStatus(username, groupname, mode);
    }

    public static void fsPermissionToXml(ContentHandler contentHandler, FsPermission mode) throws SAXException {
        XMLUtils.addSaxString(contentHandler, "MODE", Short.toString(mode.toShort()));
    }

    public static FsPermission fsPermissionFromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        short mode = Short.parseShort(st.getValue("MODE"));
        return new FsPermission(mode);
    }

    private static void fsActionToXml(ContentHandler contentHandler, FsAction v) throws SAXException {
        XMLUtils.addSaxString(contentHandler, "PERM", v.SYMBOL);
    }

    private static FsAction fsActionFromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        FsAction v = (FsAction)FSACTION_SYMBOL_MAP.get((Object)st.getValue("PERM"));
        if (v == null) {
            throw new XMLUtils.InvalidXmlException("Invalid value for FsAction");
        }
        return v;
    }

    private static void appendAclEntriesToXml(ContentHandler contentHandler, List<AclEntry> aclEntries) throws SAXException {
        for (AclEntry e : aclEntries) {
            contentHandler.startElement("", "", "ENTRY", new AttributesImpl());
            XMLUtils.addSaxString(contentHandler, "SCOPE", e.getScope().name());
            XMLUtils.addSaxString(contentHandler, "TYPE", e.getType().name());
            if (e.getName() != null) {
                XMLUtils.addSaxString(contentHandler, "NAME", e.getName());
            }
            FSEditLogOp.fsActionToXml(contentHandler, e.getPermission());
            contentHandler.endElement("", "", "ENTRY");
        }
    }

    private static List<AclEntry> readAclEntriesFromXml(XMLUtils.Stanza st) {
        ArrayList aclEntries = Lists.newArrayList();
        if (!st.hasChildren("ENTRY")) {
            return null;
        }
        List<XMLUtils.Stanza> stanzas = st.getChildren("ENTRY");
        for (XMLUtils.Stanza s : stanzas) {
            AclEntry e = new AclEntry.Builder().setScope(AclEntryScope.valueOf((String)s.getValue("SCOPE"))).setType(AclEntryType.valueOf((String)s.getValue("TYPE"))).setName(s.getValueOrNull("NAME")).setPermission(FSEditLogOp.fsActionFromXml(s)).build();
            aclEntries.add(e);
        }
        return aclEntries;
    }

    private static void appendXAttrsToXml(ContentHandler contentHandler, List<XAttr> xAttrs) throws SAXException {
        for (XAttr xAttr : xAttrs) {
            contentHandler.startElement("", "", "XATTR", new AttributesImpl());
            XMLUtils.addSaxString(contentHandler, "NAMESPACE", xAttr.getNameSpace().toString());
            XMLUtils.addSaxString(contentHandler, "NAME", xAttr.getName());
            if (xAttr.getValue() != null) {
                try {
                    XMLUtils.addSaxString(contentHandler, "VALUE", XAttrCodec.encodeValue((byte[])xAttr.getValue(), (XAttrCodec)XAttrCodec.HEX));
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
            contentHandler.endElement("", "", "XATTR");
        }
    }

    private static List<XAttr> readXAttrsFromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        if (!st.hasChildren("XATTR")) {
            return null;
        }
        List<XMLUtils.Stanza> stanzas = st.getChildren("XATTR");
        ArrayList xattrs = Lists.newArrayListWithCapacity((int)stanzas.size());
        for (XMLUtils.Stanza a : stanzas) {
            XAttr.Builder builder = new XAttr.Builder();
            builder.setNameSpace(XAttr.NameSpace.valueOf((String)a.getValue("NAMESPACE"))).setName(a.getValue("NAME"));
            String v = a.getValueOrNull("VALUE");
            if (v != null) {
                try {
                    builder.setValue(XAttrCodec.decodeValue((String)v));
                }
                catch (IOException e) {
                    throw new XMLUtils.InvalidXmlException(e.toString());
                }
            }
            xattrs.add(builder.build());
        }
        return xattrs;
    }

    private static class LegacyReader
    extends Reader {
        LegacyReader(DataInputStream in, StreamLimiter limiter, int logVersion) {
            super(in, limiter, logVersion);
        }

        @Override
        public FSEditLogOp decodeOp() throws IOException {
            byte opCodeByte;
            this.limiter.setLimit(this.maxOpSize);
            this.in.mark(this.maxOpSize);
            try {
                opCodeByte = this.in.readByte();
            }
            catch (EOFException eof) {
                return null;
            }
            FSEditLogOpCodes opCode = FSEditLogOpCodes.fromByte(opCodeByte);
            if (opCode == FSEditLogOpCodes.OP_INVALID) {
                this.verifyTerminator();
                return null;
            }
            Object op = this.cache.get(opCode);
            if (op == null) {
                throw new IOException("Read invalid opcode " + (Object)((Object)opCode));
            }
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.STORED_TXIDS, this.logVersion)) {
                ((FSEditLogOp)op).setTransactionId(this.in.readLong());
            } else {
                ((FSEditLogOp)op).setTransactionId(-12345L);
            }
            ((FSEditLogOp)op).readFields(this.in, this.logVersion);
            return op;
        }

        @Override
        public long scanOp() throws IOException {
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.STORED_TXIDS, this.logVersion)) {
                throw new IOException("Can't scan a pre-transactional edit log.");
            }
            FSEditLogOp op = this.decodeOp();
            return op == null ? -12345L : op.getTransactionId();
        }
    }

    private static class ChecksummedReader
    extends Reader {
        private final Checksum checksum;

        ChecksummedReader(Checksum checksum, DataInputStream in, StreamLimiter limiter, int logVersion) {
            super(new DataInputStream(new CheckedInputStream(in, checksum)), limiter, logVersion);
            this.checksum = checksum;
        }

        @Override
        public FSEditLogOp decodeOp() throws IOException {
            byte opCodeByte;
            this.limiter.setLimit(this.maxOpSize);
            this.in.mark(this.maxOpSize);
            this.checksum.reset();
            try {
                opCodeByte = this.in.readByte();
            }
            catch (EOFException eof) {
                return null;
            }
            FSEditLogOpCodes opCode = FSEditLogOpCodes.fromByte(opCodeByte);
            if (opCode == FSEditLogOpCodes.OP_INVALID) {
                this.verifyTerminator();
                return null;
            }
            Object op = this.cache.get(opCode);
            if (op == null) {
                throw new IOException("Read invalid opcode " + (Object)((Object)opCode));
            }
            ((FSEditLogOp)op).setTransactionId(this.in.readLong());
            ((FSEditLogOp)op).readFields(this.in, this.logVersion);
            int calculatedChecksum = (int)this.checksum.getValue();
            int expectedChecksum = this.in.readInt();
            if (expectedChecksum != calculatedChecksum) {
                throw new ChecksumException("Transaction is corrupt. Calculated checksum is " + calculatedChecksum + " but read checksum " + expectedChecksum, ((FSEditLogOp)op).txid);
            }
            return op;
        }

        @Override
        public long scanOp() throws IOException {
            FSEditLogOp op = this.decodeOp();
            return op == null ? -12345L : op.getTransactionId();
        }
    }

    private static class LengthPrefixedReader
    extends Reader {
        private static final int MIN_OP_LENGTH = 17;
        private static final int OP_ID_LENGTH = 1;
        private static final int CHECKSUM_LENGTH = 4;
        private final Checksum checksum = DataChecksum.newCrc32();

        LengthPrefixedReader(DataInputStream in, StreamLimiter limiter, int logVersion) {
            super(in, limiter, logVersion);
        }

        @Override
        public FSEditLogOp decodeOp() throws IOException {
            long txid = this.decodeOpFrame();
            if (txid == -12345L) {
                return null;
            }
            this.in.reset();
            this.in.mark(this.maxOpSize);
            FSEditLogOpCodes opCode = FSEditLogOpCodes.fromByte(this.in.readByte());
            Object op = this.cache.get(opCode);
            if (op == null) {
                throw new IOException("Read invalid opcode " + (Object)((Object)opCode));
            }
            ((FSEditLogOp)op).setTransactionId(txid);
            IOUtils.skipFully((InputStream)this.in, (long)12L);
            ((FSEditLogOp)op).readFields(this.in, this.logVersion);
            IOUtils.skipFully((InputStream)this.in, (long)4L);
            return op;
        }

        @Override
        public long scanOp() throws IOException {
            return this.decodeOpFrame();
        }

        private long decodeOpFrame() throws IOException {
            int calculatedChecksum;
            int toRead;
            byte opCodeByte;
            this.limiter.setLimit(this.maxOpSize);
            this.in.mark(this.maxOpSize);
            try {
                opCodeByte = this.in.readByte();
            }
            catch (EOFException eof) {
                return -12345L;
            }
            if (opCodeByte == FSEditLogOpCodes.OP_INVALID.getOpCode()) {
                this.verifyTerminator();
                return -12345L;
            }
            int opLength = this.in.readInt() + 1 + 4;
            if (opLength > this.maxOpSize) {
                throw new IOException("Op " + opCodeByte + " has size " + opLength + ", but maxOpSize = " + this.maxOpSize);
            }
            if (opLength < 17) {
                throw new IOException("Op " + opCodeByte + " has size " + opLength + ", but the minimum op size is " + 17);
            }
            long txid = this.in.readLong();
            this.in.reset();
            this.in.mark(this.maxOpSize);
            this.checksum.reset();
            for (int rem = opLength - 4; rem > 0; rem -= toRead) {
                toRead = Math.min(this.temp.length, rem);
                IOUtils.readFully((InputStream)this.in, (byte[])this.temp, (int)0, (int)toRead);
                this.checksum.update(this.temp, 0, toRead);
            }
            int expectedChecksum = this.in.readInt();
            if (expectedChecksum != (calculatedChecksum = (int)this.checksum.getValue())) {
                throw new ChecksumException("Transaction is corrupt. Calculated checksum is " + calculatedChecksum + " but read checksum " + expectedChecksum, txid);
            }
            return txid;
        }
    }

    public static abstract class Reader {
        final DataInputStream in;
        final StreamLimiter limiter;
        final OpInstanceCache cache;
        final byte[] temp = new byte[4096];
        final int logVersion;
        int maxOpSize;

        public static Reader create(DataInputStream in, StreamLimiter limiter, int logVersion) {
            if (logVersion < NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION) {
                return new LengthPrefixedReader(in, limiter, logVersion);
            }
            if (NameNodeLayoutVersion.supports(NameNodeLayoutVersion.Feature.EDITLOG_LENGTH, logVersion)) {
                return new LengthPrefixedReader(in, limiter, logVersion);
            }
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITS_CHECKSUM, logVersion)) {
                Checksum checksum = DataChecksum.newCrc32();
                return new ChecksummedReader(checksum, in, limiter, logVersion);
            }
            return new LegacyReader(in, limiter, logVersion);
        }

        Reader(DataInputStream in, StreamLimiter limiter, int logVersion) {
            this.in = in;
            this.limiter = limiter;
            this.logVersion = logVersion;
            this.cache = new OpInstanceCache();
            this.maxOpSize = 0x3200000;
        }

        public void setMaxOpSize(int maxOpSize) {
            this.maxOpSize = maxOpSize;
        }

        public FSEditLogOp readOp(boolean skipBrokenEdits) throws IOException {
            do {
                try {
                    return this.decodeOp();
                }
                catch (IOException e) {
                    this.in.reset();
                    if (skipBrokenEdits) continue;
                    throw e;
                }
                catch (RuntimeException e) {
                    this.in.reset();
                    if (skipBrokenEdits) continue;
                    throw e;
                }
                catch (Throwable e) {
                    this.in.reset();
                    if (skipBrokenEdits) continue;
                    throw new IOException("got unexpected exception " + e.getMessage(), e);
                }
            } while (this.in.skip(1L) >= 1L);
            return null;
        }

        void verifyTerminator() throws IOException {
            this.limiter.clearLimit();
            int numRead = -1;
            int idx = 0;
            block4: while (true) {
                try {
                    numRead = -1;
                    idx = 0;
                    numRead = this.in.read(this.temp);
                    if (numRead == -1) {
                        return;
                    }
                    while (true) {
                        if (idx >= numRead) continue block4;
                        if (this.temp[idx] != 0 && this.temp[idx] != -1) {
                            throw new IOException("Read extra bytes after the terminator!");
                        }
                        ++idx;
                    }
                }
                finally {
                    if (numRead == -1) continue;
                    this.in.reset();
                    IOUtils.skipFully((InputStream)this.in, (long)idx);
                    this.in.mark(this.temp.length + 1);
                    IOUtils.skipFully((InputStream)this.in, (long)1L);
                    continue;
                }
                break;
            }
        }

        public abstract FSEditLogOp decodeOp() throws IOException;

        public abstract long scanOp() throws IOException;
    }

    public static class Writer {
        private final DataOutputBuffer buf;
        private final Checksum checksum;

        public Writer(DataOutputBuffer out) {
            this.buf = out;
            this.checksum = DataChecksum.newCrc32();
        }

        public void writeOp(FSEditLogOp op) throws IOException {
            int start = this.buf.getLength();
            this.buf.writeByte((int)op.opCode.getOpCode());
            this.buf.writeInt(0);
            this.buf.writeLong(op.txid);
            op.writeFields((DataOutputStream)this.buf);
            int end = this.buf.getLength();
            int length = end - start - 1;
            this.buf.writeInt(length, start + 1);
            this.checksum.reset();
            this.checksum.update(this.buf.getData(), start, end - start);
            int sum = (int)this.checksum.getValue();
            this.buf.writeInt(sum);
        }
    }

    static class RollingUpgradeFinalizeOp
    extends RollingUpgradeOp {
        RollingUpgradeFinalizeOp() {
            super(FSEditLogOpCodes.OP_ROLLING_UPGRADE_FINALIZE, "finalize");
        }

        static RollingUpgradeFinalizeOp getInstance(OpInstanceCache cache) {
            return (RollingUpgradeFinalizeOp)cache.get(FSEditLogOpCodes.OP_ROLLING_UPGRADE_FINALIZE);
        }
    }

    static class RollingUpgradeStartOp
    extends RollingUpgradeOp {
        RollingUpgradeStartOp() {
            super(FSEditLogOpCodes.OP_ROLLING_UPGRADE_START, "start");
        }

        static RollingUpgradeStartOp getInstance(OpInstanceCache cache) {
            return (RollingUpgradeStartOp)cache.get(FSEditLogOpCodes.OP_ROLLING_UPGRADE_START);
        }
    }

    static class SetStoragePolicyOp
    extends FSEditLogOp {
        String path;
        byte policyId;

        SetStoragePolicyOp() {
            super(FSEditLogOpCodes.OP_SET_STORAGE_POLICY);
        }

        static SetStoragePolicyOp getInstance(OpInstanceCache cache) {
            return (SetStoragePolicyOp)cache.get(FSEditLogOpCodes.OP_SET_STORAGE_POLICY);
        }

        @Override
        void resetSubFields() {
            this.path = null;
            this.policyId = 0;
        }

        SetStoragePolicyOp setPath(String path) {
            this.path = path;
            return this;
        }

        SetStoragePolicyOp setPolicyId(byte policyId) {
            this.policyId = policyId;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            out.writeByte(this.policyId);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.path = FSImageSerialization.readString(in);
            this.policyId = in.readByte();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetStoragePolicyOp [path=");
            builder.append(this.path);
            builder.append(", policyId=");
            builder.append(this.policyId);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "POLICYID", Byte.toString(this.policyId));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.path = st.getValue("PATH");
            this.policyId = Byte.parseByte(st.getValue("POLICYID"));
        }
    }

    static abstract class RollingUpgradeOp
    extends FSEditLogOp {
        private final String name;
        private long time;

        public RollingUpgradeOp(FSEditLogOpCodes code, String name) {
            super(code);
            this.name = StringUtils.toUpperCase((String)name);
        }

        @Override
        void resetSubFields() {
            this.time = 0L;
        }

        long getTime() {
            return this.time;
        }

        void setTime(long time) {
            this.time = time;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.time = in.readLong();
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeLong(this.time, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, this.name + "TIME", Long.toString(this.time));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.time = Long.parseLong(st.getValue(this.name + "TIME"));
        }

        public String toString() {
            return "RollingUpgradeOp [" + this.name + ", time=" + this.time + "]";
        }

        static class RollbackException
        extends IOException {
            private static final long serialVersionUID = 1L;

            RollbackException() {
            }
        }
    }

    static class RemoveErasureCodingPolicyOp
    extends FSEditLogOp {
        private String ecPolicyName;

        RemoveErasureCodingPolicyOp() {
            super(FSEditLogOpCodes.OP_REMOVE_ERASURE_CODING_POLICY);
        }

        static RemoveErasureCodingPolicyOp getInstance(OpInstanceCache cache) {
            return (RemoveErasureCodingPolicyOp)cache.get(FSEditLogOpCodes.OP_REMOVE_ERASURE_CODING_POLICY);
        }

        @Override
        void resetSubFields() {
            this.ecPolicyName = null;
        }

        public String getEcPolicy() {
            return this.ecPolicyName;
        }

        public RemoveErasureCodingPolicyOp setErasureCodingPolicy(String policyName) {
            Preconditions.checkNotNull((Object)policyName);
            this.ecPolicyName = policyName;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.ecPolicyName = FSImageSerialization.readString(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.ecPolicyName, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "POLICYNAME", this.ecPolicyName);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.ecPolicyName = st.getValue("POLICYNAME");
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RemoveErasureCodingPolicy [");
            builder.append(this.ecPolicyName);
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class DisableErasureCodingPolicyOp
    extends FSEditLogOp {
        private String ecPolicyName;

        DisableErasureCodingPolicyOp() {
            super(FSEditLogOpCodes.OP_DISABLE_ERASURE_CODING_POLICY);
        }

        static DisableErasureCodingPolicyOp getInstance(OpInstanceCache cache) {
            return (DisableErasureCodingPolicyOp)cache.get(FSEditLogOpCodes.OP_DISABLE_ERASURE_CODING_POLICY);
        }

        @Override
        void resetSubFields() {
            this.ecPolicyName = null;
        }

        public String getEcPolicy() {
            return this.ecPolicyName;
        }

        public DisableErasureCodingPolicyOp setErasureCodingPolicy(String policyName) {
            Preconditions.checkNotNull((Object)policyName);
            this.ecPolicyName = policyName;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.ecPolicyName = FSImageSerialization.readString(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.ecPolicyName, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "POLICYNAME", this.ecPolicyName);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.ecPolicyName = st.getValue("POLICYNAME");
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DisableErasureCodingPolicy [");
            builder.append(this.ecPolicyName);
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class EnableErasureCodingPolicyOp
    extends FSEditLogOp {
        private String ecPolicyName;

        EnableErasureCodingPolicyOp() {
            super(FSEditLogOpCodes.OP_ENABLE_ERASURE_CODING_POLICY);
        }

        static EnableErasureCodingPolicyOp getInstance(OpInstanceCache cache) {
            return (EnableErasureCodingPolicyOp)cache.get(FSEditLogOpCodes.OP_ENABLE_ERASURE_CODING_POLICY);
        }

        @Override
        void resetSubFields() {
            this.ecPolicyName = null;
        }

        public String getEcPolicy() {
            return this.ecPolicyName;
        }

        public EnableErasureCodingPolicyOp setErasureCodingPolicy(String policyName) {
            Preconditions.checkNotNull((Object)policyName);
            this.ecPolicyName = policyName;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.ecPolicyName = FSImageSerialization.readString(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            Preconditions.checkNotNull((Object)this.ecPolicyName);
            FSImageSerialization.writeString(this.ecPolicyName, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            Preconditions.checkNotNull((Object)this.ecPolicyName);
            XMLUtils.addSaxString(contentHandler, "POLICYNAME", this.ecPolicyName);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.ecPolicyName = st.getValue("POLICYNAME");
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EnableErasureCodingPolicy [");
            builder.append(this.ecPolicyName);
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class AddErasureCodingPolicyOp
    extends FSEditLogOp {
        private ErasureCodingPolicy ecPolicy;

        AddErasureCodingPolicyOp() {
            super(FSEditLogOpCodes.OP_ADD_ERASURE_CODING_POLICY);
        }

        static AddErasureCodingPolicyOp getInstance(OpInstanceCache cache) {
            return (AddErasureCodingPolicyOp)cache.get(FSEditLogOpCodes.OP_ADD_ERASURE_CODING_POLICY);
        }

        @Override
        void resetSubFields() {
            this.ecPolicy = null;
        }

        public ErasureCodingPolicy getEcPolicy() {
            return this.ecPolicy;
        }

        public AddErasureCodingPolicyOp setErasureCodingPolicy(ErasureCodingPolicy policy) {
            Preconditions.checkNotNull((Object)policy.getName());
            Preconditions.checkNotNull((Object)policy.getSchema());
            Preconditions.checkArgument((policy.getCellSize() > 0 ? 1 : 0) != 0);
            this.ecPolicy = policy;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.ecPolicy = FSImageSerialization.readErasureCodingPolicy(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            Preconditions.checkNotNull((Object)this.ecPolicy);
            FSImageSerialization.writeErasureCodingPolicy(out, this.ecPolicy);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            Preconditions.checkNotNull((Object)this.ecPolicy);
            XMLUtils.addSaxString(contentHandler, "CODEC", this.ecPolicy.getCodecName());
            XMLUtils.addSaxString(contentHandler, "DATAUNITS", Integer.toString(this.ecPolicy.getNumDataUnits()));
            XMLUtils.addSaxString(contentHandler, "PARITYUNITS", Integer.toString(this.ecPolicy.getNumParityUnits()));
            XMLUtils.addSaxString(contentHandler, "CELLSIZE", Integer.toString(this.ecPolicy.getCellSize()));
            Map extraOptions = this.ecPolicy.getSchema().getExtraOptions();
            if (extraOptions == null || extraOptions.isEmpty()) {
                XMLUtils.addSaxString(contentHandler, "EXTRAOPTIONS", Integer.toString(0));
                FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
                return;
            }
            XMLUtils.addSaxString(contentHandler, "EXTRAOPTIONS", Integer.toString(extraOptions.size()));
            for (Map.Entry entry : extraOptions.entrySet()) {
                contentHandler.startElement("", "", "EXTRAOPTION", new AttributesImpl());
                XMLUtils.addSaxString(contentHandler, "KEY", (String)entry.getKey());
                XMLUtils.addSaxString(contentHandler, "VALUE", (String)entry.getValue());
                contentHandler.endElement("", "", "EXTRAOPTION");
            }
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            ECSchema schema;
            String codecName = st.getValue("CODEC");
            int dataUnits = Integer.parseInt(st.getValue("DATAUNITS"));
            int parityUnits = Integer.parseInt(st.getValue("PARITYUNITS"));
            int cellSize = Integer.parseInt(st.getValue("CELLSIZE"));
            int extraOptionNum = Integer.parseInt(st.getValue("EXTRAOPTIONS"));
            if (extraOptionNum == 0) {
                schema = new ECSchema(codecName, dataUnits, parityUnits, null);
            } else {
                HashMap<String, String> extraOptions = new HashMap<String, String>();
                List<XMLUtils.Stanza> stanzas = st.getChildren("EXTRAOPTION");
                for (XMLUtils.Stanza a : stanzas) {
                    extraOptions.put(a.getValue("KEY"), a.getValue("VALUE"));
                }
                schema = new ECSchema(codecName, dataUnits, parityUnits, extraOptions);
            }
            this.ecPolicy = new ErasureCodingPolicy(schema, cellSize);
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AddErasureCodingPolicy [");
            builder.append(this.ecPolicy.toString());
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class BlockTwo
    implements Writable {
        long blkid = 0L;
        long len = 0L;

        BlockTwo() {
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.blkid);
            out.writeLong(this.len);
        }

        public void readFields(DataInput in) throws IOException {
            this.blkid = in.readLong();
            this.len = in.readLong();
        }

        static {
            WritableFactories.setFactory(BlockTwo.class, (WritableFactory)new WritableFactory(){

                public Writable newInstance() {
                    return new BlockTwo();
                }
            });
        }
    }

    static class SetAclOp
    extends FSEditLogOp {
        List<AclEntry> aclEntries = Lists.newArrayList();
        String src;

        SetAclOp() {
            super(FSEditLogOpCodes.OP_SET_ACL);
        }

        static SetAclOp getInstance(OpInstanceCache cache) {
            return (SetAclOp)cache.get(FSEditLogOpCodes.OP_SET_ACL);
        }

        @Override
        void resetSubFields() {
            this.aclEntries = null;
            this.src = null;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            EditLogProtos.AclEditLogProto p = EditLogProtos.AclEditLogProto.parseDelimitedFrom(in);
            if (p == null) {
                throw new IOException("Failed to read fields from SetAclOp");
            }
            this.src = p.getSrc();
            this.aclEntries = PBHelperClient.convertAclEntry(p.getEntriesList());
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            EditLogProtos.AclEditLogProto.Builder b = EditLogProtos.AclEditLogProto.newBuilder();
            if (this.src != null) {
                b.setSrc(this.src);
            }
            b.addAllEntries(PBHelperClient.convertAclEntryProto(this.aclEntries));
            b.build().writeDelimitedTo(out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            FSEditLogOp.appendAclEntriesToXml(contentHandler, this.aclEntries);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.aclEntries = FSEditLogOp.readAclEntriesFromXml(st);
            if (this.aclEntries == null) {
                this.aclEntries = Lists.newArrayList();
            }
        }
    }

    static class SetXAttrOp
    extends FSEditLogOp {
        List<XAttr> xAttrs;
        String src;

        SetXAttrOp() {
            super(FSEditLogOpCodes.OP_SET_XATTR);
        }

        static SetXAttrOp getInstance(OpInstanceCache cache) {
            return (SetXAttrOp)cache.get(FSEditLogOpCodes.OP_SET_XATTR);
        }

        @Override
        void resetSubFields() {
            this.xAttrs = null;
            this.src = null;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            EditLogProtos.XAttrEditLogProto p = EditLogProtos.XAttrEditLogProto.parseDelimitedFrom(in);
            this.src = p.getSrc();
            this.xAttrs = PBHelperClient.convertXAttrs(p.getXAttrsList());
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            EditLogProtos.XAttrEditLogProto.Builder b = EditLogProtos.XAttrEditLogProto.newBuilder();
            if (this.src != null) {
                b.setSrc(this.src);
            }
            b.addAllXAttrs(PBHelperClient.convertXAttrProto(this.xAttrs));
            b.build().writeDelimitedTo(out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            FSEditLogOp.appendXAttrsToXml(contentHandler, this.xAttrs);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.xAttrs = FSEditLogOp.readXAttrsFromXml(st);
            this.readRpcIdsFromXml(st);
        }
    }

    static class RemoveXAttrOp
    extends FSEditLogOp {
        List<XAttr> xAttrs;
        String src;

        RemoveXAttrOp() {
            super(FSEditLogOpCodes.OP_REMOVE_XATTR);
        }

        static RemoveXAttrOp getInstance(OpInstanceCache cache) {
            return (RemoveXAttrOp)cache.get(FSEditLogOpCodes.OP_REMOVE_XATTR);
        }

        @Override
        void resetSubFields() {
            this.xAttrs = null;
            this.src = null;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            EditLogProtos.XAttrEditLogProto p = EditLogProtos.XAttrEditLogProto.parseDelimitedFrom(in);
            this.src = p.getSrc();
            this.xAttrs = PBHelperClient.convertXAttrs(p.getXAttrsList());
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            EditLogProtos.XAttrEditLogProto.Builder b = EditLogProtos.XAttrEditLogProto.newBuilder();
            if (this.src != null) {
                b.setSrc(this.src);
            }
            b.addAllXAttrs(PBHelperClient.convertXAttrProto(this.xAttrs));
            b.build().writeDelimitedTo(out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            FSEditLogOp.appendXAttrsToXml(contentHandler, this.xAttrs);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.xAttrs = FSEditLogOp.readXAttrsFromXml(st);
            this.readRpcIdsFromXml(st);
        }
    }

    static class RemoveCachePoolOp
    extends FSEditLogOp {
        String poolName;

        public RemoveCachePoolOp() {
            super(FSEditLogOpCodes.OP_REMOVE_CACHE_POOL);
        }

        static RemoveCachePoolOp getInstance(OpInstanceCache cache) {
            return (RemoveCachePoolOp)cache.get(FSEditLogOpCodes.OP_REMOVE_CACHE_POOL);
        }

        @Override
        void resetSubFields() {
            this.poolName = null;
        }

        public RemoveCachePoolOp setPoolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.poolName = FSImageSerialization.readString(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.poolName, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "POOLNAME", this.poolName);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.poolName = st.getValue("POOLNAME");
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RemoveCachePoolOp [");
            builder.append("poolName=" + this.poolName);
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class ModifyCachePoolOp
    extends FSEditLogOp {
        CachePoolInfo info;

        public ModifyCachePoolOp() {
            super(FSEditLogOpCodes.OP_MODIFY_CACHE_POOL);
        }

        static ModifyCachePoolOp getInstance(OpInstanceCache cache) {
            return (ModifyCachePoolOp)cache.get(FSEditLogOpCodes.OP_MODIFY_CACHE_POOL);
        }

        @Override
        void resetSubFields() {
            this.info = null;
        }

        public ModifyCachePoolOp setInfo(CachePoolInfo info) {
            this.info = info;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.info = FSImageSerialization.readCachePoolInfo(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeCachePoolInfo(out, this.info);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            FSImageSerialization.writeCachePoolInfo(contentHandler, this.info);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.info = FSImageSerialization.readCachePoolInfo(st);
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ModifyCachePoolOp [");
            ArrayList<String> fields = new ArrayList<String>(5);
            if (this.info.getPoolName() != null) {
                fields.add("poolName=" + this.info.getPoolName());
            }
            if (this.info.getOwnerName() != null) {
                fields.add("ownerName=" + this.info.getOwnerName());
            }
            if (this.info.getGroupName() != null) {
                fields.add("groupName=" + this.info.getGroupName());
            }
            if (this.info.getMode() != null) {
                fields.add("mode=" + this.info.getMode().toString());
            }
            if (this.info.getLimit() != null) {
                fields.add("limit=" + this.info.getLimit());
            }
            builder.append(Joiner.on((String)",").join(fields));
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class AddCachePoolOp
    extends FSEditLogOp {
        CachePoolInfo info;

        public AddCachePoolOp() {
            super(FSEditLogOpCodes.OP_ADD_CACHE_POOL);
        }

        static AddCachePoolOp getInstance(OpInstanceCache cache) {
            return (AddCachePoolOp)cache.get(FSEditLogOpCodes.OP_ADD_CACHE_POOL);
        }

        @Override
        void resetSubFields() {
            this.info = null;
        }

        public AddCachePoolOp setPool(CachePoolInfo info) {
            this.info = info;
            assert (info.getPoolName() != null);
            assert (info.getOwnerName() != null);
            assert (info.getGroupName() != null);
            assert (info.getMode() != null);
            assert (info.getLimit() != null);
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.info = FSImageSerialization.readCachePoolInfo(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeCachePoolInfo(out, this.info);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            FSImageSerialization.writeCachePoolInfo(contentHandler, this.info);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.info = FSImageSerialization.readCachePoolInfo(st);
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AddCachePoolOp [");
            builder.append("poolName=" + this.info.getPoolName() + ",");
            builder.append("ownerName=" + this.info.getOwnerName() + ",");
            builder.append("groupName=" + this.info.getGroupName() + ",");
            builder.append("mode=" + Short.toString(this.info.getMode().toShort()) + ",");
            builder.append("limit=" + Long.toString(this.info.getLimit()));
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class RemoveCacheDirectiveInfoOp
    extends FSEditLogOp {
        long id;

        public RemoveCacheDirectiveInfoOp() {
            super(FSEditLogOpCodes.OP_REMOVE_CACHE_DIRECTIVE);
        }

        static RemoveCacheDirectiveInfoOp getInstance(OpInstanceCache cache) {
            return (RemoveCacheDirectiveInfoOp)cache.get(FSEditLogOpCodes.OP_REMOVE_CACHE_DIRECTIVE);
        }

        @Override
        void resetSubFields() {
            this.id = 0L;
        }

        public RemoveCacheDirectiveInfoOp setId(long id) {
            this.id = id;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.id = FSImageSerialization.readLong(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeLong(this.id, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "ID", Long.toString(this.id));
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.id = Long.parseLong(st.getValue("ID"));
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RemoveCacheDirectiveInfo [");
            builder.append("id=" + Long.toString(this.id));
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class ModifyCacheDirectiveInfoOp
    extends FSEditLogOp {
        CacheDirectiveInfo directive;

        public ModifyCacheDirectiveInfoOp() {
            super(FSEditLogOpCodes.OP_MODIFY_CACHE_DIRECTIVE);
        }

        static ModifyCacheDirectiveInfoOp getInstance(OpInstanceCache cache) {
            return (ModifyCacheDirectiveInfoOp)cache.get(FSEditLogOpCodes.OP_MODIFY_CACHE_DIRECTIVE);
        }

        @Override
        void resetSubFields() {
            this.directive = null;
        }

        public ModifyCacheDirectiveInfoOp setDirective(CacheDirectiveInfo directive) {
            this.directive = directive;
            assert (directive.getId() != null);
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.directive = FSImageSerialization.readCacheDirectiveInfo(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeCacheDirectiveInfo(out, this.directive);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            FSImageSerialization.writeCacheDirectiveInfo(contentHandler, this.directive);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.directive = FSImageSerialization.readCacheDirectiveInfo(st);
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ModifyCacheDirectiveInfoOp[");
            builder.append("id=").append(this.directive.getId());
            if (this.directive.getPath() != null) {
                builder.append(",").append("path=").append(this.directive.getPath());
            }
            if (this.directive.getReplication() != null) {
                builder.append(",").append("replication=").append(this.directive.getReplication());
            }
            if (this.directive.getPool() != null) {
                builder.append(",").append("pool=").append(this.directive.getPool());
            }
            if (this.directive.getExpiration() != null) {
                builder.append(",").append("expiration=").append(this.directive.getExpiration().getMillis());
            }
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class AddCacheDirectiveInfoOp
    extends FSEditLogOp {
        CacheDirectiveInfo directive;

        public AddCacheDirectiveInfoOp() {
            super(FSEditLogOpCodes.OP_ADD_CACHE_DIRECTIVE);
        }

        static AddCacheDirectiveInfoOp getInstance(OpInstanceCache cache) {
            return (AddCacheDirectiveInfoOp)cache.get(FSEditLogOpCodes.OP_ADD_CACHE_DIRECTIVE);
        }

        @Override
        void resetSubFields() {
            this.directive = null;
        }

        public AddCacheDirectiveInfoOp setDirective(CacheDirectiveInfo directive) {
            this.directive = directive;
            assert (directive.getId() != null);
            assert (directive.getPath() != null);
            assert (directive.getReplication() != null);
            assert (directive.getPool() != null);
            assert (directive.getExpiration() != null);
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.directive = FSImageSerialization.readCacheDirectiveInfo(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeCacheDirectiveInfo(out, this.directive);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            FSImageSerialization.writeCacheDirectiveInfo(contentHandler, this.directive);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.directive = FSImageSerialization.readCacheDirectiveInfo(st);
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AddCacheDirectiveInfo [");
            builder.append("id=" + this.directive.getId() + ",");
            builder.append("path=" + this.directive.getPath().toUri().getPath() + ",");
            builder.append("replication=" + this.directive.getReplication() + ",");
            builder.append("pool=" + this.directive.getPool() + ",");
            builder.append("expiration=" + this.directive.getExpiration().getMillis());
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class DisallowSnapshotOp
    extends FSEditLogOp {
        String snapshotRoot;

        public DisallowSnapshotOp() {
            super(FSEditLogOpCodes.OP_DISALLOW_SNAPSHOT);
        }

        public DisallowSnapshotOp(String snapRoot) {
            super(FSEditLogOpCodes.OP_DISALLOW_SNAPSHOT);
            this.snapshotRoot = snapRoot;
        }

        static DisallowSnapshotOp getInstance(OpInstanceCache cache) {
            return (DisallowSnapshotOp)cache.get(FSEditLogOpCodes.OP_DISALLOW_SNAPSHOT);
        }

        @Override
        void resetSubFields() {
            this.snapshotRoot = null;
        }

        public DisallowSnapshotOp setSnapshotRoot(String snapRoot) {
            this.snapshotRoot = snapRoot;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.snapshotRoot = FSImageSerialization.readString(in);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.snapshotRoot, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SNAPSHOTROOT", this.snapshotRoot);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.snapshotRoot = st.getValue("SNAPSHOTROOT");
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DisallowSnapshotOp [snapshotRoot=");
            builder.append(this.snapshotRoot);
            builder.append("]");
            return builder.toString();
        }
    }

    static class AllowSnapshotOp
    extends FSEditLogOp {
        String snapshotRoot;

        public AllowSnapshotOp() {
            super(FSEditLogOpCodes.OP_ALLOW_SNAPSHOT);
        }

        public AllowSnapshotOp(String snapRoot) {
            super(FSEditLogOpCodes.OP_ALLOW_SNAPSHOT);
            this.snapshotRoot = snapRoot;
        }

        static AllowSnapshotOp getInstance(OpInstanceCache cache) {
            return (AllowSnapshotOp)cache.get(FSEditLogOpCodes.OP_ALLOW_SNAPSHOT);
        }

        @Override
        void resetSubFields() {
            this.snapshotRoot = null;
        }

        public AllowSnapshotOp setSnapshotRoot(String snapRoot) {
            this.snapshotRoot = snapRoot;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.snapshotRoot = FSImageSerialization.readString(in);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.snapshotRoot, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SNAPSHOTROOT", this.snapshotRoot);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.snapshotRoot = st.getValue("SNAPSHOTROOT");
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AllowSnapshotOp [snapshotRoot=");
            builder.append(this.snapshotRoot);
            builder.append("]");
            return builder.toString();
        }
    }

    static class RenameSnapshotOp
    extends FSEditLogOp {
        String snapshotRoot;
        String snapshotOldName;
        String snapshotNewName;

        RenameSnapshotOp() {
            super(FSEditLogOpCodes.OP_RENAME_SNAPSHOT);
        }

        static RenameSnapshotOp getInstance(OpInstanceCache cache) {
            return (RenameSnapshotOp)cache.get(FSEditLogOpCodes.OP_RENAME_SNAPSHOT);
        }

        @Override
        void resetSubFields() {
            this.snapshotRoot = null;
            this.snapshotOldName = null;
            this.snapshotNewName = null;
        }

        RenameSnapshotOp setSnapshotOldName(String snapshotOldName) {
            this.snapshotOldName = snapshotOldName;
            return this;
        }

        RenameSnapshotOp setSnapshotNewName(String snapshotNewName) {
            this.snapshotNewName = snapshotNewName;
            return this;
        }

        RenameSnapshotOp setSnapshotRoot(String snapshotRoot) {
            this.snapshotRoot = snapshotRoot;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.snapshotRoot = FSImageSerialization.readString(in);
            this.snapshotOldName = FSImageSerialization.readString(in);
            this.snapshotNewName = FSImageSerialization.readString(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.snapshotRoot, out);
            FSImageSerialization.writeString(this.snapshotOldName, out);
            FSImageSerialization.writeString(this.snapshotNewName, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SNAPSHOTROOT", this.snapshotRoot);
            XMLUtils.addSaxString(contentHandler, "SNAPSHOTOLDNAME", this.snapshotOldName);
            XMLUtils.addSaxString(contentHandler, "SNAPSHOTNEWNAME", this.snapshotNewName);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.snapshotRoot = st.getValue("SNAPSHOTROOT");
            this.snapshotOldName = st.getValue("SNAPSHOTOLDNAME");
            this.snapshotNewName = st.getValue("SNAPSHOTNEWNAME");
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RenameSnapshotOp [snapshotRoot=");
            builder.append(this.snapshotRoot);
            builder.append(", snapshotOldName=");
            builder.append(this.snapshotOldName);
            builder.append(", snapshotNewName=");
            builder.append(this.snapshotNewName);
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class DeleteSnapshotOp
    extends FSEditLogOp {
        String snapshotRoot;
        String snapshotName;

        DeleteSnapshotOp() {
            super(FSEditLogOpCodes.OP_DELETE_SNAPSHOT);
        }

        static DeleteSnapshotOp getInstance(OpInstanceCache cache) {
            return (DeleteSnapshotOp)cache.get(FSEditLogOpCodes.OP_DELETE_SNAPSHOT);
        }

        @Override
        void resetSubFields() {
            this.snapshotRoot = null;
            this.snapshotName = null;
        }

        DeleteSnapshotOp setSnapshotName(String snapName) {
            this.snapshotName = snapName;
            return this;
        }

        DeleteSnapshotOp setSnapshotRoot(String snapRoot) {
            this.snapshotRoot = snapRoot;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.snapshotRoot = FSImageSerialization.readString(in);
            this.snapshotName = FSImageSerialization.readString(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.snapshotRoot, out);
            FSImageSerialization.writeString(this.snapshotName, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SNAPSHOTROOT", this.snapshotRoot);
            XMLUtils.addSaxString(contentHandler, "SNAPSHOTNAME", this.snapshotName);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.snapshotRoot = st.getValue("SNAPSHOTROOT");
            this.snapshotName = st.getValue("SNAPSHOTNAME");
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DeleteSnapshotOp [snapshotRoot=");
            builder.append(this.snapshotRoot);
            builder.append(", snapshotName=");
            builder.append(this.snapshotName);
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class CreateSnapshotOp
    extends FSEditLogOp {
        String snapshotRoot;
        String snapshotName;

        public CreateSnapshotOp() {
            super(FSEditLogOpCodes.OP_CREATE_SNAPSHOT);
        }

        static CreateSnapshotOp getInstance(OpInstanceCache cache) {
            return (CreateSnapshotOp)cache.get(FSEditLogOpCodes.OP_CREATE_SNAPSHOT);
        }

        @Override
        void resetSubFields() {
            this.snapshotRoot = null;
            this.snapshotName = null;
        }

        CreateSnapshotOp setSnapshotName(String snapName) {
            this.snapshotName = snapName;
            return this;
        }

        public CreateSnapshotOp setSnapshotRoot(String snapRoot) {
            this.snapshotRoot = snapRoot;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.snapshotRoot = FSImageSerialization.readString(in);
            this.snapshotName = FSImageSerialization.readString(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.snapshotRoot, out);
            FSImageSerialization.writeString(this.snapshotName, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SNAPSHOTROOT", this.snapshotRoot);
            XMLUtils.addSaxString(contentHandler, "SNAPSHOTNAME", this.snapshotName);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.snapshotRoot = st.getValue("SNAPSHOTROOT");
            this.snapshotName = st.getValue("SNAPSHOTNAME");
            this.readRpcIdsFromXml(st);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CreateSnapshotOp [snapshotRoot=");
            builder.append(this.snapshotRoot);
            builder.append(", snapshotName=");
            builder.append(this.snapshotName);
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append("]");
            return builder.toString();
        }
    }

    static class InvalidOp
    extends FSEditLogOp {
        InvalidOp() {
            super(FSEditLogOpCodes.OP_INVALID);
        }

        static InvalidOp getInstance(OpInstanceCache cache) {
            return (InvalidOp)cache.get(FSEditLogOpCodes.OP_INVALID);
        }

        @Override
        void resetSubFields() {
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("InvalidOp [opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        }
    }

    static class EndLogSegmentOp
    extends LogSegmentOp {
        EndLogSegmentOp() {
            super(FSEditLogOpCodes.OP_END_LOG_SEGMENT);
        }
    }

    static class StartLogSegmentOp
    extends LogSegmentOp {
        StartLogSegmentOp() {
            super(FSEditLogOpCodes.OP_START_LOG_SEGMENT);
        }
    }

    static class LogSegmentOp
    extends FSEditLogOp {
        private LogSegmentOp(FSEditLogOpCodes code) {
            super(code);
            assert (code == FSEditLogOpCodes.OP_START_LOG_SEGMENT || code == FSEditLogOpCodes.OP_END_LOG_SEGMENT) : "Bad op: " + (Object)((Object)code);
        }

        static LogSegmentOp getInstance(OpInstanceCache cache, FSEditLogOpCodes code) {
            return (LogSegmentOp)cache.get(code);
        }

        @Override
        void resetSubFields() {
        }

        @Override
        public void readFields(DataInputStream in, int logVersion) throws IOException {
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LogSegmentOp [opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        }
    }

    static class UpdateMasterKeyOp
    extends FSEditLogOp {
        DelegationKey key;

        UpdateMasterKeyOp() {
            super(FSEditLogOpCodes.OP_UPDATE_MASTER_KEY);
        }

        static UpdateMasterKeyOp getInstance(OpInstanceCache cache) {
            return (UpdateMasterKeyOp)cache.get(FSEditLogOpCodes.OP_UPDATE_MASTER_KEY);
        }

        @Override
        void resetSubFields() {
            this.key = null;
        }

        UpdateMasterKeyOp setDelegationKey(DelegationKey key) {
            this.key = key;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            this.key.write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.key = new DelegationKey();
            this.key.readFields((DataInput)in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("UpdateMasterKeyOp [key=");
            builder.append(this.key);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            FSEditLogOp.delegationKeyToXml(contentHandler, this.key);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.key = UpdateMasterKeyOp.delegationKeyFromXml(st.getChildren("DELEGATION_KEY").get(0));
        }
    }

    static class CancelDelegationTokenOp
    extends FSEditLogOp {
        DelegationTokenIdentifier token;

        CancelDelegationTokenOp() {
            super(FSEditLogOpCodes.OP_CANCEL_DELEGATION_TOKEN);
        }

        static CancelDelegationTokenOp getInstance(OpInstanceCache cache) {
            return (CancelDelegationTokenOp)cache.get(FSEditLogOpCodes.OP_CANCEL_DELEGATION_TOKEN);
        }

        @Override
        void resetSubFields() {
            this.token = null;
        }

        CancelDelegationTokenOp setDelegationTokenIdentifier(DelegationTokenIdentifier token) {
            this.token = token;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            this.token.write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.token = new DelegationTokenIdentifier();
            this.token.readFields((DataInput)in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CancelDelegationTokenOp [token=");
            builder.append(this.token);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            FSEditLogOp.delegationTokenToXml(contentHandler, this.token);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.token = CancelDelegationTokenOp.delegationTokenFromXml(st.getChildren("DELEGATION_TOKEN_IDENTIFIER").get(0));
        }
    }

    static class RenewDelegationTokenOp
    extends FSEditLogOp {
        DelegationTokenIdentifier token;
        long expiryTime;

        RenewDelegationTokenOp() {
            super(FSEditLogOpCodes.OP_RENEW_DELEGATION_TOKEN);
        }

        static RenewDelegationTokenOp getInstance(OpInstanceCache cache) {
            return (RenewDelegationTokenOp)cache.get(FSEditLogOpCodes.OP_RENEW_DELEGATION_TOKEN);
        }

        @Override
        void resetSubFields() {
            this.token = null;
            this.expiryTime = 0L;
        }

        RenewDelegationTokenOp setDelegationTokenIdentifier(DelegationTokenIdentifier token) {
            this.token = token;
            return this;
        }

        RenewDelegationTokenOp setExpiryTime(long expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            this.token.write((DataOutput)out);
            FSImageSerialization.writeLong(this.expiryTime, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.token = new DelegationTokenIdentifier();
            this.token.readFields((DataInput)in);
            this.expiryTime = NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RenewDelegationTokenOp [token=");
            builder.append(this.token);
            builder.append(", expiryTime=");
            builder.append(this.expiryTime);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            FSEditLogOp.delegationTokenToXml(contentHandler, this.token);
            XMLUtils.addSaxString(contentHandler, "EXPIRY_TIME", Long.toString(this.expiryTime));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.token = RenewDelegationTokenOp.delegationTokenFromXml(st.getChildren("DELEGATION_TOKEN_IDENTIFIER").get(0));
            this.expiryTime = Long.parseLong(st.getValue("EXPIRY_TIME"));
        }
    }

    static class GetDelegationTokenOp
    extends FSEditLogOp {
        DelegationTokenIdentifier token;
        long expiryTime;

        GetDelegationTokenOp() {
            super(FSEditLogOpCodes.OP_GET_DELEGATION_TOKEN);
        }

        static GetDelegationTokenOp getInstance(OpInstanceCache cache) {
            return (GetDelegationTokenOp)cache.get(FSEditLogOpCodes.OP_GET_DELEGATION_TOKEN);
        }

        @Override
        void resetSubFields() {
            this.token = null;
            this.expiryTime = 0L;
        }

        GetDelegationTokenOp setDelegationTokenIdentifier(DelegationTokenIdentifier token) {
            this.token = token;
            return this;
        }

        GetDelegationTokenOp setExpiryTime(long expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            this.token.write((DataOutput)out);
            FSImageSerialization.writeLong(this.expiryTime, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.token = new DelegationTokenIdentifier();
            this.token.readFields((DataInput)in);
            this.expiryTime = NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GetDelegationTokenOp [token=");
            builder.append(this.token);
            builder.append(", expiryTime=");
            builder.append(this.expiryTime);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            FSEditLogOp.delegationTokenToXml(contentHandler, this.token);
            XMLUtils.addSaxString(contentHandler, "EXPIRY_TIME", Long.toString(this.expiryTime));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.token = GetDelegationTokenOp.delegationTokenFromXml(st.getChildren("DELEGATION_TOKEN_IDENTIFIER").get(0));
            this.expiryTime = Long.parseLong(st.getValue("EXPIRY_TIME"));
        }
    }

    static class ReassignLeaseOp
    extends FSEditLogOp {
        String leaseHolder;
        String path;
        String newHolder;

        ReassignLeaseOp() {
            super(FSEditLogOpCodes.OP_REASSIGN_LEASE);
        }

        static ReassignLeaseOp getInstance(OpInstanceCache cache) {
            return (ReassignLeaseOp)cache.get(FSEditLogOpCodes.OP_REASSIGN_LEASE);
        }

        @Override
        void resetSubFields() {
            this.leaseHolder = null;
            this.path = null;
            this.newHolder = null;
        }

        ReassignLeaseOp setLeaseHolder(String leaseHolder) {
            this.leaseHolder = leaseHolder;
            return this;
        }

        ReassignLeaseOp setPath(String path) {
            this.path = path;
            return this;
        }

        ReassignLeaseOp setNewHolder(String newHolder) {
            this.newHolder = newHolder;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.leaseHolder, out);
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeString(this.newHolder, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.leaseHolder = FSImageSerialization.readString(in);
            this.path = FSImageSerialization.readString(in);
            this.newHolder = FSImageSerialization.readString(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ReassignLeaseOp [leaseHolder=");
            builder.append(this.leaseHolder);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", newHolder=");
            builder.append(this.newHolder);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LEASEHOLDER", this.leaseHolder);
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "NEWHOLDER", this.newHolder);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.leaseHolder = st.getValue("LEASEHOLDER");
            this.path = st.getValue("PATH");
            this.newHolder = st.getValue("NEWHOLDER");
        }
    }

    static class TruncateOp
    extends FSEditLogOp {
        String src;
        String clientName;
        String clientMachine;
        long newLength;
        long timestamp;
        Block truncateBlock;

        TruncateOp() {
            super(FSEditLogOpCodes.OP_TRUNCATE);
        }

        static TruncateOp getInstance(OpInstanceCache cache) {
            return (TruncateOp)cache.get(FSEditLogOpCodes.OP_TRUNCATE);
        }

        @Override
        void resetSubFields() {
            this.src = null;
            this.clientName = null;
            this.clientMachine = null;
            this.newLength = 0L;
            this.timestamp = 0L;
        }

        TruncateOp setPath(String src) {
            this.src = src;
            return this;
        }

        TruncateOp setClientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        TruncateOp setClientMachine(String clientMachine) {
            this.clientMachine = clientMachine;
            return this;
        }

        TruncateOp setNewLength(long newLength) {
            this.newLength = newLength;
            return this;
        }

        TruncateOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        TruncateOp setTruncateBlock(Block truncateBlock) {
            this.truncateBlock = truncateBlock;
            return this;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.clientName = FSImageSerialization.readString(in);
            this.clientMachine = FSImageSerialization.readString(in);
            this.newLength = FSImageSerialization.readLong(in);
            this.timestamp = FSImageSerialization.readLong(in);
            Block[] blocks = FSImageSerialization.readCompactBlockArray(in, logVersion);
            assert (blocks.length <= 1) : "Truncate op should have 1 or 0 blocks";
            this.truncateBlock = blocks.length == 0 ? null : blocks[0];
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeString(this.clientName, out);
            FSImageSerialization.writeString(this.clientMachine, out);
            FSImageSerialization.writeLong(this.newLength, out);
            FSImageSerialization.writeLong(this.timestamp, out);
            int size = this.truncateBlock != null ? 1 : 0;
            Block[] blocks = new Block[size];
            if (this.truncateBlock != null) {
                blocks[0] = this.truncateBlock;
            }
            FSImageSerialization.writeCompactBlockArray(blocks, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            XMLUtils.addSaxString(contentHandler, "CLIENTNAME", this.clientName);
            XMLUtils.addSaxString(contentHandler, "CLIENTMACHINE", this.clientMachine);
            XMLUtils.addSaxString(contentHandler, "NEWLENGTH", Long.toString(this.newLength));
            XMLUtils.addSaxString(contentHandler, "TIMESTAMP", Long.toString(this.timestamp));
            if (this.truncateBlock != null) {
                FSEditLogOp.blockToXml(contentHandler, this.truncateBlock);
            }
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.clientName = st.getValue("CLIENTNAME");
            this.clientMachine = st.getValue("CLIENTMACHINE");
            this.newLength = Long.parseLong(st.getValue("NEWLENGTH"));
            this.timestamp = Long.parseLong(st.getValue("TIMESTAMP"));
            if (st.hasChildren("BLOCK")) {
                this.truncateBlock = FSEditLogOp.blockFromXml(st);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TruncateOp [src=");
            builder.append(this.src);
            builder.append(", clientName=");
            builder.append(this.clientName);
            builder.append(", clientMachine=");
            builder.append(this.clientMachine);
            builder.append(", newLength=");
            builder.append(this.newLength);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", truncateBlock=");
            builder.append(this.truncateBlock);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class RenameOp
    extends FSEditLogOp {
        int length;
        String src;
        String dst;
        long timestamp;
        Options.Rename[] options;

        RenameOp() {
            super(FSEditLogOpCodes.OP_RENAME);
        }

        static RenameOp getInstance(OpInstanceCache cache) {
            return (RenameOp)cache.get(FSEditLogOpCodes.OP_RENAME);
        }

        @Override
        void resetSubFields() {
            this.length = 0;
            this.src = null;
            this.dst = null;
            this.timestamp = 0L;
            this.options = null;
        }

        RenameOp setSource(String src) {
            this.src = src;
            return this;
        }

        RenameOp setDestination(String dst) {
            this.dst = dst;
            return this;
        }

        RenameOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        RenameOp setOptions(Options.Rename[] options) {
            this.options = options;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeString(this.dst, out);
            FSImageSerialization.writeLong(this.timestamp, out);
            RenameOp.toBytesWritable(this.options).write((DataOutput)out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 3) {
                    throw new IOException("Incorrect data format. Rename operation.");
                }
            }
            this.src = FSImageSerialization.readString(in);
            this.dst = FSImageSerialization.readString(in);
            this.timestamp = NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
            this.options = RenameOp.readRenameOptions(in);
            this.readRpcIds(in, logVersion);
        }

        private static Options.Rename[] readRenameOptions(DataInputStream in) throws IOException {
            BytesWritable writable = new BytesWritable();
            writable.readFields((DataInput)in);
            byte[] bytes = writable.getBytes();
            int len = writable.getLength();
            Options.Rename[] options = new Options.Rename[len];
            for (int i = 0; i < len; ++i) {
                options[i] = Options.Rename.valueOf((byte)bytes[i]);
            }
            return options;
        }

        static BytesWritable toBytesWritable(Options.Rename ... options) {
            byte[] bytes = new byte[options.length];
            for (int i = 0; i < options.length; ++i) {
                bytes[i] = options[i].value();
            }
            return new BytesWritable(bytes);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RenameOp [length=");
            builder.append(this.length);
            builder.append(", src=");
            builder.append(this.src);
            builder.append(", dst=");
            builder.append(this.dst);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", options=");
            builder.append(Arrays.toString(this.options));
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.toString(this.length));
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            XMLUtils.addSaxString(contentHandler, "DST", this.dst);
            XMLUtils.addSaxString(contentHandler, "TIMESTAMP", Long.toString(this.timestamp));
            StringBuilder bld = new StringBuilder();
            String prefix = "";
            for (Options.Rename r : this.options) {
                bld.append(prefix).append(r.toString());
                prefix = "|";
            }
            XMLUtils.addSaxString(contentHandler, "OPTIONS", bld.toString());
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.parseInt(st.getValue("LENGTH"));
            this.src = st.getValue("SRC");
            this.dst = st.getValue("DST");
            this.timestamp = Long.parseLong(st.getValue("TIMESTAMP"));
            String opts = st.getValue("OPTIONS");
            String[] o = opts.split("\\|");
            this.options = new Options.Rename[o.length];
            for (int i = 0; i < o.length; ++i) {
                if (o[i].equals("")) continue;
                try {
                    this.options[i] = Options.Rename.valueOf((String)o[i]);
                    continue;
                }
                finally {
                    if (this.options[i] == null) {
                        System.err.println("error parsing Rename value: \"" + o[i] + "\"");
                    }
                }
            }
            this.readRpcIdsFromXml(st);
        }
    }

    static class SymlinkOp
    extends FSEditLogOp {
        int length;
        long inodeId;
        String path;
        String value;
        long mtime;
        long atime;
        PermissionStatus permissionStatus;

        SymlinkOp() {
            super(FSEditLogOpCodes.OP_SYMLINK);
        }

        static SymlinkOp getInstance(OpInstanceCache cache) {
            return (SymlinkOp)cache.get(FSEditLogOpCodes.OP_SYMLINK);
        }

        @Override
        void resetSubFields() {
            this.length = 0;
            this.inodeId = 0L;
            this.path = null;
            this.value = null;
            this.mtime = 0L;
            this.atime = 0L;
            this.permissionStatus = null;
        }

        SymlinkOp setId(long inodeId) {
            this.inodeId = inodeId;
            return this;
        }

        SymlinkOp setPath(String path) {
            this.path = path;
            return this;
        }

        SymlinkOp setValue(String value) {
            this.value = value;
            return this;
        }

        SymlinkOp setModificationTime(long mtime) {
            this.mtime = mtime;
            return this;
        }

        SymlinkOp setAccessTime(long atime) {
            this.atime = atime;
            return this;
        }

        SymlinkOp setPermissionStatus(PermissionStatus permissionStatus) {
            this.permissionStatus = permissionStatus;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeLong(this.inodeId, out);
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeString(this.value, out);
            FSImageSerialization.writeLong(this.mtime, out);
            FSImageSerialization.writeLong(this.atime, out);
            this.permissionStatus.write((DataOutput)out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 4) {
                    throw new IOException("Incorrect data format. symlink operation.");
                }
            }
            this.inodeId = NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, logVersion) ? FSImageSerialization.readLong(in) : 0L;
            this.path = FSImageSerialization.readString(in);
            this.value = FSImageSerialization.readString(in);
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.mtime = FSImageSerialization.readLong(in);
                this.atime = FSImageSerialization.readLong(in);
            } else {
                this.mtime = FSEditLogOp.readLong(in);
                this.atime = FSEditLogOp.readLong(in);
            }
            this.permissionStatus = PermissionStatus.read((DataInput)in);
            this.readRpcIds(in, logVersion);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SymlinkOp [length=");
            builder.append(this.length);
            builder.append(", inodeId=");
            builder.append(this.inodeId);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", value=");
            builder.append(this.value);
            builder.append(", mtime=");
            builder.append(this.mtime);
            builder.append(", atime=");
            builder.append(this.atime);
            builder.append(", permissionStatus=");
            builder.append(this.permissionStatus);
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.toString(this.length));
            XMLUtils.addSaxString(contentHandler, "INODEID", Long.toString(this.inodeId));
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "VALUE", this.value);
            XMLUtils.addSaxString(contentHandler, "MTIME", Long.toString(this.mtime));
            XMLUtils.addSaxString(contentHandler, "ATIME", Long.toString(this.atime));
            FSEditLogOp.permissionStatusToXml(contentHandler, this.permissionStatus);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.parseInt(st.getValue("LENGTH"));
            this.inodeId = Long.parseLong(st.getValue("INODEID"));
            this.path = st.getValue("PATH");
            this.value = st.getValue("VALUE");
            this.mtime = Long.parseLong(st.getValue("MTIME"));
            this.atime = Long.parseLong(st.getValue("ATIME"));
            this.permissionStatus = SymlinkOp.permissionStatusFromXml(st);
            this.readRpcIdsFromXml(st);
        }
    }

    static class TimesOp
    extends FSEditLogOp {
        int length;
        String path;
        long mtime;
        long atime;

        TimesOp() {
            super(FSEditLogOpCodes.OP_TIMES);
        }

        static TimesOp getInstance(OpInstanceCache cache) {
            return (TimesOp)cache.get(FSEditLogOpCodes.OP_TIMES);
        }

        @Override
        void resetSubFields() {
            this.length = 0;
            this.path = null;
            this.mtime = 0L;
            this.atime = 0L;
        }

        TimesOp setPath(String path) {
            this.path = path;
            return this;
        }

        TimesOp setModificationTime(long mtime) {
            this.mtime = mtime;
            return this;
        }

        TimesOp setAccessTime(long atime) {
            this.atime = atime;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeLong(this.mtime, out);
            FSImageSerialization.writeLong(this.atime, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 3) {
                    throw new IOException("Incorrect data format. times operation.");
                }
            }
            this.path = FSImageSerialization.readString(in);
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.mtime = FSImageSerialization.readLong(in);
                this.atime = FSImageSerialization.readLong(in);
            } else {
                this.mtime = FSEditLogOp.readLong(in);
                this.atime = FSEditLogOp.readLong(in);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TimesOp [length=");
            builder.append(this.length);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", mtime=");
            builder.append(this.mtime);
            builder.append(", atime=");
            builder.append(this.atime);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.toString(this.length));
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "MTIME", Long.toString(this.mtime));
            XMLUtils.addSaxString(contentHandler, "ATIME", Long.toString(this.atime));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.parseInt(st.getValue("LENGTH"));
            this.path = st.getValue("PATH");
            this.mtime = Long.parseLong(st.getValue("MTIME"));
            this.atime = Long.parseLong(st.getValue("ATIME"));
        }
    }

    static class SetQuotaByStorageTypeOp
    extends FSEditLogOp {
        String src;
        long dsQuota;
        StorageType type;

        SetQuotaByStorageTypeOp() {
            super(FSEditLogOpCodes.OP_SET_QUOTA_BY_STORAGETYPE);
        }

        static SetQuotaByStorageTypeOp getInstance(OpInstanceCache cache) {
            return (SetQuotaByStorageTypeOp)cache.get(FSEditLogOpCodes.OP_SET_QUOTA_BY_STORAGETYPE);
        }

        @Override
        void resetSubFields() {
            this.src = null;
            this.dsQuota = -1L;
            this.type = StorageType.DEFAULT;
        }

        SetQuotaByStorageTypeOp setSource(String src) {
            this.src = src;
            return this;
        }

        SetQuotaByStorageTypeOp setQuotaByStorageType(long dsQuota, StorageType type) {
            this.type = type;
            this.dsQuota = dsQuota;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeInt(this.type.ordinal(), out);
            FSImageSerialization.writeLong(this.dsQuota, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.type = StorageType.parseStorageType((int)FSImageSerialization.readInt(in));
            this.dsQuota = FSImageSerialization.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetTypeQuotaOp [src=");
            builder.append(this.src);
            builder.append(", storageType=");
            builder.append(this.type);
            builder.append(", dsQuota=");
            builder.append(this.dsQuota);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            XMLUtils.addSaxString(contentHandler, "STORAGETYPE", Integer.toString(this.type.ordinal()));
            XMLUtils.addSaxString(contentHandler, "DSQUOTA", Long.toString(this.dsQuota));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.type = StorageType.parseStorageType((int)Integer.parseInt(st.getValue("STORAGETYPE")));
            this.dsQuota = Long.parseLong(st.getValue("DSQUOTA"));
        }
    }

    static class SetQuotaOp
    extends FSEditLogOp {
        String src;
        long nsQuota;
        long dsQuota;

        SetQuotaOp() {
            super(FSEditLogOpCodes.OP_SET_QUOTA);
        }

        static SetQuotaOp getInstance(OpInstanceCache cache) {
            return (SetQuotaOp)cache.get(FSEditLogOpCodes.OP_SET_QUOTA);
        }

        @Override
        void resetSubFields() {
            this.src = null;
            this.nsQuota = 0L;
            this.dsQuota = 0L;
        }

        SetQuotaOp setSource(String src) {
            this.src = src;
            return this;
        }

        SetQuotaOp setNSQuota(long nsQuota) {
            this.nsQuota = nsQuota;
            return this;
        }

        SetQuotaOp setDSQuota(long dsQuota) {
            this.dsQuota = dsQuota;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeLong(this.nsQuota, out);
            FSImageSerialization.writeLong(this.dsQuota, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.nsQuota = FSImageSerialization.readLong(in);
            this.dsQuota = FSImageSerialization.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetQuotaOp [src=");
            builder.append(this.src);
            builder.append(", nsQuota=");
            builder.append(this.nsQuota);
            builder.append(", dsQuota=");
            builder.append(this.dsQuota);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            XMLUtils.addSaxString(contentHandler, "NSQUOTA", Long.toString(this.nsQuota));
            XMLUtils.addSaxString(contentHandler, "DSQUOTA", Long.toString(this.dsQuota));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.nsQuota = Long.parseLong(st.getValue("NSQUOTA"));
            this.dsQuota = Long.parseLong(st.getValue("DSQUOTA"));
        }
    }

    static class ClearNSQuotaOp
    extends FSEditLogOp {
        String src;

        ClearNSQuotaOp() {
            super(FSEditLogOpCodes.OP_CLEAR_NS_QUOTA);
        }

        static ClearNSQuotaOp getInstance(OpInstanceCache cache) {
            return (ClearNSQuotaOp)cache.get(FSEditLogOpCodes.OP_CLEAR_NS_QUOTA);
        }

        @Override
        void resetSubFields() {
            this.src = null;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            throw new IOException("Deprecated");
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ClearNSQuotaOp [src=");
            builder.append(this.src);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
        }
    }

    static class SetNSQuotaOp
    extends FSEditLogOp {
        String src;
        long nsQuota;

        SetNSQuotaOp() {
            super(FSEditLogOpCodes.OP_SET_NS_QUOTA);
        }

        static SetNSQuotaOp getInstance(OpInstanceCache cache) {
            return (SetNSQuotaOp)cache.get(FSEditLogOpCodes.OP_SET_NS_QUOTA);
        }

        @Override
        void resetSubFields() {
            this.src = null;
            this.nsQuota = 0L;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            throw new IOException("Deprecated");
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.nsQuota = FSImageSerialization.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetNSQuotaOp [src=");
            builder.append(this.src);
            builder.append(", nsQuota=");
            builder.append(this.nsQuota);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            XMLUtils.addSaxString(contentHandler, "NSQUOTA", Long.toString(this.nsQuota));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.nsQuota = Long.parseLong(st.getValue("NSQUOTA"));
        }
    }

    static class SetOwnerOp
    extends FSEditLogOp {
        String src;
        String username;
        String groupname;

        SetOwnerOp() {
            super(FSEditLogOpCodes.OP_SET_OWNER);
        }

        static SetOwnerOp getInstance(OpInstanceCache cache) {
            return (SetOwnerOp)cache.get(FSEditLogOpCodes.OP_SET_OWNER);
        }

        @Override
        void resetSubFields() {
            this.src = null;
            this.username = null;
            this.groupname = null;
        }

        SetOwnerOp setSource(String src) {
            this.src = src;
            return this;
        }

        SetOwnerOp setUser(String username) {
            this.username = username;
            return this;
        }

        SetOwnerOp setGroup(String groupname) {
            this.groupname = groupname;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeString(this.username == null ? "" : this.username, out);
            FSImageSerialization.writeString(this.groupname == null ? "" : this.groupname, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.username = FSImageSerialization.readString_EmptyAsNull(in);
            this.groupname = FSImageSerialization.readString_EmptyAsNull(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetOwnerOp [src=");
            builder.append(this.src);
            builder.append(", username=");
            builder.append(this.username);
            builder.append(", groupname=");
            builder.append(this.groupname);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            if (this.username != null) {
                XMLUtils.addSaxString(contentHandler, "USERNAME", this.username);
            }
            if (this.groupname != null) {
                XMLUtils.addSaxString(contentHandler, "GROUPNAME", this.groupname);
            }
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.username = st.hasChildren("USERNAME") ? st.getValue("USERNAME") : null;
            this.groupname = st.hasChildren("GROUPNAME") ? st.getValue("GROUPNAME") : null;
        }
    }

    static class SetPermissionsOp
    extends FSEditLogOp {
        String src;
        FsPermission permissions;

        SetPermissionsOp() {
            super(FSEditLogOpCodes.OP_SET_PERMISSIONS);
        }

        static SetPermissionsOp getInstance(OpInstanceCache cache) {
            return (SetPermissionsOp)cache.get(FSEditLogOpCodes.OP_SET_PERMISSIONS);
        }

        @Override
        void resetSubFields() {
            this.src = null;
            this.permissions = null;
        }

        SetPermissionsOp setSource(String src) {
            this.src = src;
            return this;
        }

        SetPermissionsOp setPermissions(FsPermission permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            this.permissions.write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.permissions = FsPermission.read((DataInput)in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetPermissionsOp [src=");
            builder.append(this.src);
            builder.append(", permissions=");
            builder.append(this.permissions);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            XMLUtils.addSaxString(contentHandler, "MODE", Short.toString(this.permissions.toShort()));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.permissions = new FsPermission(Short.parseShort(st.getValue("MODE")));
        }
    }

    static class AllocateBlockIdOp
    extends FSEditLogOp {
        long blockId;

        AllocateBlockIdOp() {
            super(FSEditLogOpCodes.OP_ALLOCATE_BLOCK_ID);
        }

        static AllocateBlockIdOp getInstance(OpInstanceCache cache) {
            return (AllocateBlockIdOp)cache.get(FSEditLogOpCodes.OP_ALLOCATE_BLOCK_ID);
        }

        @Override
        void resetSubFields() {
            this.blockId = 0L;
        }

        AllocateBlockIdOp setBlockId(long blockId) {
            this.blockId = blockId;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeLong(this.blockId, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.blockId = FSImageSerialization.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AllocateBlockIdOp [blockId=");
            builder.append(this.blockId);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "BLOCK_ID", Long.toString(this.blockId));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.blockId = Long.parseLong(st.getValue("BLOCK_ID"));
        }
    }

    static class SetGenstampV2Op
    extends FSEditLogOp {
        long genStampV2;

        SetGenstampV2Op() {
            super(FSEditLogOpCodes.OP_SET_GENSTAMP_V2);
        }

        static SetGenstampV2Op getInstance(OpInstanceCache cache) {
            return (SetGenstampV2Op)cache.get(FSEditLogOpCodes.OP_SET_GENSTAMP_V2);
        }

        @Override
        void resetSubFields() {
            this.genStampV2 = 0L;
        }

        SetGenstampV2Op setGenerationStamp(long genStamp) {
            this.genStampV2 = genStamp;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeLong(this.genStampV2, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.genStampV2 = FSImageSerialization.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetGenstampV2Op [GenStampV2=");
            builder.append(this.genStampV2);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "GENSTAMPV2", Long.toString(this.genStampV2));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.genStampV2 = Long.parseLong(st.getValue("GENSTAMPV2"));
        }
    }

    static class SetGenstampV1Op
    extends FSEditLogOp {
        long genStampV1;

        SetGenstampV1Op() {
            super(FSEditLogOpCodes.OP_SET_GENSTAMP_V1);
        }

        static SetGenstampV1Op getInstance(OpInstanceCache cache) {
            return (SetGenstampV1Op)cache.get(FSEditLogOpCodes.OP_SET_GENSTAMP_V1);
        }

        @Override
        void resetSubFields() {
            this.genStampV1 = 0L;
        }

        SetGenstampV1Op setGenerationStamp(long genStamp) {
            this.genStampV1 = genStamp;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeLong(this.genStampV1, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.genStampV1 = FSImageSerialization.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetGenstampOp [GenStamp=");
            builder.append(this.genStampV1);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "GENSTAMP", Long.toString(this.genStampV1));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.genStampV1 = Long.parseLong(st.getValue("GENSTAMP"));
        }
    }

    static class MkdirOp
    extends FSEditLogOp {
        int length;
        long inodeId;
        String path;
        long timestamp;
        PermissionStatus permissions;
        List<AclEntry> aclEntries;
        List<XAttr> xAttrs;

        MkdirOp() {
            super(FSEditLogOpCodes.OP_MKDIR);
        }

        static MkdirOp getInstance(OpInstanceCache cache) {
            return (MkdirOp)cache.get(FSEditLogOpCodes.OP_MKDIR);
        }

        @Override
        void resetSubFields() {
            this.length = 0;
            this.inodeId = 0L;
            this.path = null;
            this.timestamp = 0L;
            this.permissions = null;
            this.aclEntries = null;
            this.xAttrs = null;
        }

        MkdirOp setInodeId(long inodeId) {
            this.inodeId = inodeId;
            return this;
        }

        MkdirOp setPath(String path) {
            this.path = path;
            return this;
        }

        MkdirOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        MkdirOp setPermissionStatus(PermissionStatus permissions) {
            this.permissions = permissions;
            return this;
        }

        MkdirOp setAclEntries(List<AclEntry> aclEntries) {
            this.aclEntries = aclEntries;
            return this;
        }

        MkdirOp setXAttrs(List<XAttr> xAttrs) {
            this.xAttrs = xAttrs;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeLong(this.inodeId, out);
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeLong(this.timestamp, out);
            FSImageSerialization.writeLong(this.timestamp, out);
            this.permissions.write((DataOutput)out);
            AclEditLogUtil.write(this.aclEntries, out);
            EditLogProtos.XAttrEditLogProto.Builder b = EditLogProtos.XAttrEditLogProto.newBuilder();
            b.addAllXAttrs(PBHelperClient.convertXAttrProto(this.xAttrs));
            b.build().writeDelimitedTo(out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
            }
            if (-17 < logVersion && this.length != 2 || logVersion <= -17 && this.length != 3 && !NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                throw new IOException("Incorrect data format. Mkdir operation.");
            }
            this.inodeId = NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, logVersion) ? FSImageSerialization.readLong(in) : 0L;
            this.path = FSImageSerialization.readString(in);
            this.timestamp = NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, logVersion)) {
                if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                    FSImageSerialization.readLong(in);
                } else {
                    FSEditLogOp.readLong(in);
                }
            }
            this.permissions = PermissionStatus.read((DataInput)in);
            this.aclEntries = AclEditLogUtil.read(in, logVersion);
            this.xAttrs = FSEditLogOp.readXAttrsFromEditLog(in, logVersion);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MkdirOp [length=");
            builder.append(this.length);
            builder.append(", inodeId=");
            builder.append(this.inodeId);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", permissions=");
            builder.append(this.permissions);
            builder.append(", aclEntries=");
            builder.append(this.aclEntries);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append(", xAttrs=");
            builder.append(this.xAttrs);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.toString(this.length));
            XMLUtils.addSaxString(contentHandler, "INODEID", Long.toString(this.inodeId));
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "TIMESTAMP", Long.toString(this.timestamp));
            FSEditLogOp.permissionStatusToXml(contentHandler, this.permissions);
            if (this.aclEntries != null) {
                FSEditLogOp.appendAclEntriesToXml(contentHandler, this.aclEntries);
            }
            if (this.xAttrs != null) {
                FSEditLogOp.appendXAttrsToXml(contentHandler, this.xAttrs);
            }
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.parseInt(st.getValue("LENGTH"));
            this.inodeId = Long.parseLong(st.getValue("INODEID"));
            this.path = st.getValue("PATH");
            this.timestamp = Long.parseLong(st.getValue("TIMESTAMP"));
            this.permissions = MkdirOp.permissionStatusFromXml(st);
            this.aclEntries = FSEditLogOp.readAclEntriesFromXml(st);
            this.xAttrs = FSEditLogOp.readXAttrsFromXml(st);
        }
    }

    static class DeleteOp
    extends FSEditLogOp {
        int length;
        String path;
        long timestamp;

        DeleteOp() {
            super(FSEditLogOpCodes.OP_DELETE);
        }

        static DeleteOp getInstance(OpInstanceCache cache) {
            return (DeleteOp)cache.get(FSEditLogOpCodes.OP_DELETE);
        }

        @Override
        void resetSubFields() {
            this.length = 0;
            this.path = null;
            this.timestamp = 0L;
        }

        DeleteOp setPath(String path) {
            this.path = path;
            return this;
        }

        DeleteOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeLong(this.timestamp, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 2) {
                    throw new IOException("Incorrect data format. delete operation.");
                }
            }
            this.path = FSImageSerialization.readString(in);
            this.timestamp = NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
            this.readRpcIds(in, logVersion);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DeleteOp [length=");
            builder.append(this.length);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.toString(this.length));
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "TIMESTAMP", Long.toString(this.timestamp));
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.parseInt(st.getValue("LENGTH"));
            this.path = st.getValue("PATH");
            this.timestamp = Long.parseLong(st.getValue("TIMESTAMP"));
            this.readRpcIdsFromXml(st);
        }
    }

    static class RenameOldOp
    extends FSEditLogOp {
        int length;
        String src;
        String dst;
        long timestamp;

        RenameOldOp() {
            super(FSEditLogOpCodes.OP_RENAME_OLD);
        }

        static RenameOldOp getInstance(OpInstanceCache cache) {
            return (RenameOldOp)cache.get(FSEditLogOpCodes.OP_RENAME_OLD);
        }

        @Override
        void resetSubFields() {
            this.length = 0;
            this.src = null;
            this.dst = null;
            this.timestamp = 0L;
        }

        RenameOldOp setSource(String src) {
            this.src = src;
            return this;
        }

        RenameOldOp setDestination(String dst) {
            this.dst = dst;
            return this;
        }

        RenameOldOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeString(this.dst, out);
            FSImageSerialization.writeLong(this.timestamp, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 3) {
                    throw new IOException("Incorrect data format. Old rename operation.");
                }
            }
            this.src = FSImageSerialization.readString(in);
            this.dst = FSImageSerialization.readString(in);
            this.timestamp = NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
            this.readRpcIds(in, logVersion);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RenameOldOp [length=");
            builder.append(this.length);
            builder.append(", src=");
            builder.append(this.src);
            builder.append(", dst=");
            builder.append(this.dst);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.toString(this.length));
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            XMLUtils.addSaxString(contentHandler, "DST", this.dst);
            XMLUtils.addSaxString(contentHandler, "TIMESTAMP", Long.toString(this.timestamp));
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.parseInt(st.getValue("LENGTH"));
            this.src = st.getValue("SRC");
            this.dst = st.getValue("DST");
            this.timestamp = Long.parseLong(st.getValue("TIMESTAMP"));
            this.readRpcIdsFromXml(st);
        }
    }

    static class ConcatDeleteOp
    extends FSEditLogOp {
        int length;
        String trg;
        String[] srcs;
        long timestamp;
        public static final int MAX_CONCAT_SRC = 0x100000;

        ConcatDeleteOp() {
            super(FSEditLogOpCodes.OP_CONCAT_DELETE);
        }

        static ConcatDeleteOp getInstance(OpInstanceCache cache) {
            return (ConcatDeleteOp)cache.get(FSEditLogOpCodes.OP_CONCAT_DELETE);
        }

        @Override
        void resetSubFields() {
            this.length = 0;
            this.trg = null;
            this.srcs = null;
            this.timestamp = 0L;
        }

        ConcatDeleteOp setTarget(String trg) {
            this.trg = trg;
            return this;
        }

        ConcatDeleteOp setSources(String[] srcs) {
            if (srcs.length > 0x100000) {
                throw new RuntimeException("ConcatDeleteOp can only have 1048576 sources at most.");
            }
            this.srcs = srcs;
            return this;
        }

        ConcatDeleteOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.trg, out);
            DeprecatedUTF8[] info = new DeprecatedUTF8[this.srcs.length];
            int idx = 0;
            for (int i = 0; i < this.srcs.length; ++i) {
                info[idx++] = new DeprecatedUTF8(this.srcs[i]);
            }
            new ArrayWritable(DeprecatedUTF8.class, (Writable[])info).write((DataOutput)out);
            FSImageSerialization.writeLong(this.timestamp, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length < 3) {
                    throw new IOException("Incorrect data format for ConcatDeleteOp.");
                }
            }
            this.trg = FSImageSerialization.readString(in);
            int srcSize = 0;
            srcSize = NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? in.readInt() : this.length - 1 - 1;
            if (srcSize < 0) {
                throw new IOException("Incorrect data format. ConcatDeleteOp cannot have a negative number of data  sources.");
            }
            if (srcSize > 0x100000) {
                throw new IOException("Incorrect data format. ConcatDeleteOp can have at most 1048576 sources, but we tried to have " + (this.length - 3) + " sources.");
            }
            this.srcs = new String[srcSize];
            for (int i = 0; i < srcSize; ++i) {
                this.srcs[i] = FSImageSerialization.readString(in);
            }
            this.timestamp = NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
            this.readRpcIds(in, logVersion);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ConcatDeleteOp [length=");
            builder.append(this.length);
            builder.append(", trg=");
            builder.append(this.trg);
            builder.append(", srcs=");
            builder.append(Arrays.toString(this.srcs));
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.toString(this.length));
            XMLUtils.addSaxString(contentHandler, "TRG", this.trg);
            XMLUtils.addSaxString(contentHandler, "TIMESTAMP", Long.toString(this.timestamp));
            contentHandler.startElement("", "", "SOURCES", new AttributesImpl());
            for (int i = 0; i < this.srcs.length; ++i) {
                XMLUtils.addSaxString(contentHandler, "SOURCE" + (i + 1), this.srcs[i]);
            }
            contentHandler.endElement("", "", "SOURCES");
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.parseInt(st.getValue("LENGTH"));
            this.trg = st.getValue("TRG");
            this.timestamp = Long.parseLong(st.getValue("TIMESTAMP"));
            List<XMLUtils.Stanza> sources = st.getChildren("SOURCES");
            int i = 0;
            while (sources.get(0).hasChildren("SOURCE" + (i + 1))) {
                ++i;
            }
            this.srcs = new String[i];
            for (i = 0; i < this.srcs.length; ++i) {
                this.srcs[i] = sources.get(0).getValue("SOURCE" + (i + 1));
            }
            this.readRpcIdsFromXml(st);
        }
    }

    static class SetReplicationOp
    extends FSEditLogOp {
        String path;
        short replication;

        SetReplicationOp() {
            super(FSEditLogOpCodes.OP_SET_REPLICATION);
        }

        static SetReplicationOp getInstance(OpInstanceCache cache) {
            return (SetReplicationOp)cache.get(FSEditLogOpCodes.OP_SET_REPLICATION);
        }

        @Override
        void resetSubFields() {
            this.path = null;
            this.replication = 0;
        }

        SetReplicationOp setPath(String path) {
            this.path = path;
            return this;
        }

        SetReplicationOp setReplication(short replication) {
            this.replication = replication;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeShort(this.replication, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.path = FSImageSerialization.readString(in);
            this.replication = NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readShort(in) : FSEditLogOp.readShort(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetReplicationOp [path=");
            builder.append(this.path);
            builder.append(", replication=");
            builder.append(this.replication);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "REPLICATION", Short.toString(this.replication));
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.path = st.getValue("PATH");
            this.replication = Short.parseShort(st.getValue("REPLICATION"));
        }
    }

    static class UpdateBlocksOp
    extends FSEditLogOp
    implements BlockListUpdatingOp {
        String path;
        Block[] blocks;

        UpdateBlocksOp() {
            super(FSEditLogOpCodes.OP_UPDATE_BLOCKS);
        }

        static UpdateBlocksOp getInstance(OpInstanceCache cache) {
            return (UpdateBlocksOp)cache.get(FSEditLogOpCodes.OP_UPDATE_BLOCKS);
        }

        @Override
        void resetSubFields() {
            this.path = null;
            this.blocks = null;
        }

        UpdateBlocksOp setPath(String path) {
            this.path = path;
            return this;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        UpdateBlocksOp setBlocks(Block[] blocks) {
            this.blocks = blocks;
            return this;
        }

        @Override
        public Block[] getBlocks() {
            return this.blocks;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeCompactBlockArray(this.blocks, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.path = FSImageSerialization.readString(in);
            this.blocks = FSImageSerialization.readCompactBlockArray(in, logVersion);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public boolean shouldCompleteLastBlock() {
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("UpdateBlocksOp [path=").append(this.path).append(", blocks=").append(Arrays.toString(this.blocks));
            FSEditLogOp.appendRpcIdsToString(sb, this.rpcClientId, this.rpcCallId);
            sb.append("]");
            return sb.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            for (Block b : this.blocks) {
                FSEditLogOp.blockToXml(contentHandler, b);
            }
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.path = st.getValue("PATH");
            List<Object> blocks = st.hasChildren("BLOCK") ? st.getChildren("BLOCK") : new ArrayList();
            this.blocks = new Block[blocks.size()];
            for (int i = 0; i < blocks.size(); ++i) {
                this.blocks[i] = FSEditLogOp.blockFromXml((XMLUtils.Stanza)blocks.get(i));
            }
            this.readRpcIdsFromXml(st);
        }
    }

    static class AddBlockOp
    extends FSEditLogOp {
        private String path;
        private Block penultimateBlock;
        private Block lastBlock;

        AddBlockOp() {
            super(FSEditLogOpCodes.OP_ADD_BLOCK);
        }

        static AddBlockOp getInstance(OpInstanceCache cache) {
            return (AddBlockOp)cache.get(FSEditLogOpCodes.OP_ADD_BLOCK);
        }

        @Override
        void resetSubFields() {
            this.path = null;
            this.penultimateBlock = null;
            this.lastBlock = null;
        }

        AddBlockOp setPath(String path) {
            this.path = path;
            return this;
        }

        public String getPath() {
            return this.path;
        }

        AddBlockOp setPenultimateBlock(Block pBlock) {
            this.penultimateBlock = pBlock;
            return this;
        }

        Block getPenultimateBlock() {
            return this.penultimateBlock;
        }

        AddBlockOp setLastBlock(Block lastBlock) {
            this.lastBlock = lastBlock;
            return this;
        }

        Block getLastBlock() {
            return this.lastBlock;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            int size = this.penultimateBlock != null ? 2 : 1;
            Block[] blocks = new Block[size];
            if (this.penultimateBlock != null) {
                blocks[0] = this.penultimateBlock;
            }
            blocks[size - 1] = this.lastBlock;
            FSImageSerialization.writeCompactBlockArray(blocks, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.path = FSImageSerialization.readString(in);
            Block[] blocks = FSImageSerialization.readCompactBlockArray(in, logVersion);
            Preconditions.checkState((blocks.length == 2 || blocks.length == 1 ? 1 : 0) != 0);
            this.penultimateBlock = blocks.length == 1 ? null : blocks[0];
            this.lastBlock = blocks[blocks.length - 1];
            this.readRpcIds(in, logVersion);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("AddBlockOp [path=").append(this.path).append(", penultimateBlock=").append((Object)(this.penultimateBlock == null ? "NULL" : this.penultimateBlock)).append(", lastBlock=").append(this.lastBlock);
            FSEditLogOp.appendRpcIdsToString(sb, this.rpcClientId, this.rpcCallId);
            sb.append("]");
            return sb.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            if (this.penultimateBlock != null) {
                FSEditLogOp.blockToXml(contentHandler, this.penultimateBlock);
            }
            FSEditLogOp.blockToXml(contentHandler, this.lastBlock);
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.path = st.getValue("PATH");
            List<XMLUtils.Stanza> blocks = st.getChildren("BLOCK");
            int size = blocks.size();
            Preconditions.checkState((size == 1 || size == 2 ? 1 : 0) != 0);
            this.penultimateBlock = size == 2 ? FSEditLogOp.blockFromXml(blocks.get(0)) : null;
            this.lastBlock = FSEditLogOp.blockFromXml(blocks.get(size - 1));
            this.readRpcIdsFromXml(st);
        }
    }

    static class AppendOp
    extends FSEditLogOp {
        String path;
        String clientName;
        String clientMachine;
        boolean newBlock;

        AppendOp() {
            super(FSEditLogOpCodes.OP_APPEND);
        }

        static AppendOp getInstance(OpInstanceCache cache) {
            return (AppendOp)cache.get(FSEditLogOpCodes.OP_APPEND);
        }

        AppendOp setPath(String path) {
            this.path = path;
            return this;
        }

        AppendOp setClientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        AppendOp setClientMachine(String clientMachine) {
            this.clientMachine = clientMachine;
            return this;
        }

        AppendOp setNewBlock(boolean newBlock) {
            this.newBlock = newBlock;
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AppendOp ");
            builder.append("[path=").append(this.path);
            builder.append(", clientName=").append(this.clientName);
            builder.append(", clientMachine=").append(this.clientMachine);
            builder.append(", newBlock=").append(this.newBlock).append("]");
            return builder.toString();
        }

        @Override
        void resetSubFields() {
            this.path = null;
            this.clientName = null;
            this.clientMachine = null;
            this.newBlock = false;
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.path = FSImageSerialization.readString(in);
            this.clientName = FSImageSerialization.readString(in);
            this.clientMachine = FSImageSerialization.readString(in);
            this.newBlock = FSImageSerialization.readBoolean(in);
            this.readRpcIds(in, logVersion);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeString(this.clientName, out);
            FSImageSerialization.writeString(this.clientMachine, out);
            FSImageSerialization.writeBoolean(this.newBlock, out);
            FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "CLIENT_NAME", this.clientName);
            XMLUtils.addSaxString(contentHandler, "CLIENT_MACHINE", this.clientMachine);
            XMLUtils.addSaxString(contentHandler, "NEWBLOCK", Boolean.toString(this.newBlock));
            FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.path = st.getValue("PATH");
            this.clientName = st.getValue("CLIENT_NAME");
            this.clientMachine = st.getValue("CLIENT_MACHINE");
            this.newBlock = Boolean.parseBoolean(st.getValue("NEWBLOCK"));
            this.readRpcIdsFromXml(st);
        }
    }

    static class CloseOp
    extends AddCloseOp {
        CloseOp() {
            super(FSEditLogOpCodes.OP_CLOSE);
        }

        static CloseOp getInstance(OpInstanceCache cache) {
            return (CloseOp)cache.get(FSEditLogOpCodes.OP_CLOSE);
        }

        @Override
        public boolean shouldCompleteLastBlock() {
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CloseOp ");
            builder.append(this.stringifyMembers());
            return builder.toString();
        }
    }

    static class AddOp
    extends AddCloseOp {
        AddOp() {
            super(FSEditLogOpCodes.OP_ADD);
        }

        static AddOp getInstance(OpInstanceCache cache) {
            return (AddOp)cache.get(FSEditLogOpCodes.OP_ADD);
        }

        @Override
        public boolean shouldCompleteLastBlock() {
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AddOp ");
            builder.append(this.stringifyMembers());
            return builder.toString();
        }
    }

    static abstract class AddCloseOp
    extends FSEditLogOp
    implements BlockListUpdatingOp {
        int length;
        long inodeId;
        String path;
        short replication;
        long mtime;
        long atime;
        long blockSize;
        Block[] blocks;
        PermissionStatus permissions;
        List<AclEntry> aclEntries;
        List<XAttr> xAttrs;
        String clientName;
        String clientMachine;
        boolean overwrite;
        byte storagePolicyId = 0;
        byte erasureCodingPolicyId = 0;
        public static final int MAX_BLOCKS = 0x4000000;

        private AddCloseOp(FSEditLogOpCodes opCode) {
            super(opCode);
            assert (opCode == FSEditLogOpCodes.OP_ADD || opCode == FSEditLogOpCodes.OP_CLOSE || opCode == FSEditLogOpCodes.OP_APPEND);
        }

        @Override
        void resetSubFields() {
            this.length = 0;
            this.inodeId = 0L;
            this.path = null;
            this.replication = 0;
            this.mtime = 0L;
            this.atime = 0L;
            this.blockSize = 0L;
            this.blocks = null;
            this.permissions = null;
            this.aclEntries = null;
            this.xAttrs = null;
            this.clientName = null;
            this.clientMachine = null;
            this.overwrite = false;
            this.storagePolicyId = 0;
            this.erasureCodingPolicyId = 0;
        }

        <T extends AddCloseOp> T setInodeId(long inodeId) {
            this.inodeId = inodeId;
            return (T)this;
        }

        <T extends AddCloseOp> T setPath(String path) {
            this.path = path;
            return (T)this;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        <T extends AddCloseOp> T setReplication(short replication) {
            this.replication = replication;
            return (T)this;
        }

        <T extends AddCloseOp> T setModificationTime(long mtime) {
            this.mtime = mtime;
            return (T)this;
        }

        <T extends AddCloseOp> T setAccessTime(long atime) {
            this.atime = atime;
            return (T)this;
        }

        <T extends AddCloseOp> T setBlockSize(long blockSize) {
            this.blockSize = blockSize;
            return (T)this;
        }

        <T extends AddCloseOp> T setBlocks(Block[] blocks) {
            if (blocks.length > 0x4000000) {
                throw new RuntimeException("Can't have more than 67108864 in an AddCloseOp.");
            }
            this.blocks = blocks;
            return (T)this;
        }

        @Override
        public Block[] getBlocks() {
            return this.blocks;
        }

        <T extends AddCloseOp> T setPermissionStatus(PermissionStatus permissions) {
            this.permissions = permissions;
            return (T)this;
        }

        <T extends AddCloseOp> T setAclEntries(List<AclEntry> aclEntries) {
            this.aclEntries = aclEntries;
            return (T)this;
        }

        <T extends AddCloseOp> T setXAttrs(List<XAttr> xAttrs) {
            this.xAttrs = xAttrs;
            return (T)this;
        }

        <T extends AddCloseOp> T setClientName(String clientName) {
            this.clientName = clientName;
            return (T)this;
        }

        <T extends AddCloseOp> T setClientMachine(String clientMachine) {
            this.clientMachine = clientMachine;
            return (T)this;
        }

        <T extends AddCloseOp> T setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return (T)this;
        }

        <T extends AddCloseOp> T setStoragePolicyId(byte storagePolicyId) {
            this.storagePolicyId = storagePolicyId;
            return (T)this;
        }

        <T extends AddCloseOp> T setErasureCodingPolicyId(byte ecPolicyId) {
            this.erasureCodingPolicyId = ecPolicyId;
            return (T)this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeLong(this.inodeId, out);
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeShort(this.replication, out);
            FSImageSerialization.writeLong(this.mtime, out);
            FSImageSerialization.writeLong(this.atime, out);
            FSImageSerialization.writeLong(this.blockSize, out);
            new ArrayWritable(Block.class, (Writable[])this.blocks).write((DataOutput)out);
            this.permissions.write((DataOutput)out);
            if (this.opCode == FSEditLogOpCodes.OP_ADD) {
                AclEditLogUtil.write(this.aclEntries, out);
                EditLogProtos.XAttrEditLogProto.Builder b = EditLogProtos.XAttrEditLogProto.newBuilder();
                b.addAllXAttrs(PBHelperClient.convertXAttrProto(this.xAttrs));
                b.build().writeDelimitedTo(out);
                FSImageSerialization.writeString(this.clientName, out);
                FSImageSerialization.writeString(this.clientMachine, out);
                FSImageSerialization.writeBoolean(this.overwrite, out);
                FSImageSerialization.writeByte(this.storagePolicyId, out);
                FSImageSerialization.writeByte(this.erasureCodingPolicyId, out);
                FSEditLogOp.writeRpcIds(this.rpcClientId, this.rpcCallId, out);
            }
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
            }
            this.inodeId = NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, logVersion) ? in.readLong() : 0L;
            if (-17 < logVersion && this.length != 4 || logVersion <= -17 && this.length != 5 && !NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                throw new IOException("Incorrect data format. logVersion is " + logVersion + " but writables.length is " + this.length + ". ");
            }
            this.path = FSImageSerialization.readString(in);
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.replication = FSImageSerialization.readShort(in);
                this.mtime = FSImageSerialization.readLong(in);
            } else {
                this.replication = FSEditLogOp.readShort(in);
                this.mtime = FSEditLogOp.readLong(in);
            }
            this.atime = NameNodeLayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, logVersion) ? (NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in)) : 0L;
            this.blockSize = NameNodeLayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
            this.blocks = AddCloseOp.readBlocks(in, logVersion);
            this.permissions = PermissionStatus.read((DataInput)in);
            if (this.opCode == FSEditLogOpCodes.OP_ADD) {
                this.aclEntries = AclEditLogUtil.read(in, logVersion);
                this.xAttrs = FSEditLogOp.readXAttrsFromEditLog(in, logVersion);
                this.clientName = FSImageSerialization.readString(in);
                this.clientMachine = FSImageSerialization.readString(in);
                this.overwrite = NameNodeLayoutVersion.supports(NameNodeLayoutVersion.Feature.CREATE_OVERWRITE, logVersion) ? FSImageSerialization.readBoolean(in) : false;
                this.storagePolicyId = NameNodeLayoutVersion.supports(NameNodeLayoutVersion.Feature.BLOCK_STORAGE_POLICY, logVersion) ? FSImageSerialization.readByte(in) : (byte)0;
                this.erasureCodingPolicyId = NameNodeLayoutVersion.supports(NameNodeLayoutVersion.Feature.ERASURE_CODING, logVersion) ? FSImageSerialization.readByte(in) : (byte)0;
                this.readRpcIds(in, logVersion);
            } else {
                this.clientName = "";
                this.clientMachine = "";
            }
        }

        private static Block[] readBlocks(DataInputStream in, int logVersion) throws IOException {
            int numBlocks = in.readInt();
            if (numBlocks < 0) {
                throw new IOException("invalid negative number of blocks");
            }
            if (numBlocks > 0x4000000) {
                throw new IOException("invalid number of blocks: " + numBlocks + ".  The maximum number of blocks per file is " + 0x4000000);
            }
            Block[] blocks = new Block[numBlocks];
            for (int i = 0; i < numBlocks; ++i) {
                Block blk = new Block();
                blk.readFields((DataInput)in);
                blocks[i] = blk;
            }
            return blocks;
        }

        public String stringifyMembers() {
            StringBuilder builder = new StringBuilder();
            builder.append("[length=");
            builder.append(this.length);
            builder.append(", inodeId=");
            builder.append(this.inodeId);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", replication=");
            builder.append(this.replication);
            builder.append(", mtime=");
            builder.append(this.mtime);
            builder.append(", atime=");
            builder.append(this.atime);
            builder.append(", blockSize=");
            builder.append(this.blockSize);
            builder.append(", blocks=");
            builder.append(Arrays.toString(this.blocks));
            builder.append(", permissions=");
            builder.append(this.permissions);
            builder.append(", aclEntries=");
            builder.append(this.aclEntries);
            builder.append(", clientName=");
            builder.append(this.clientName);
            builder.append(", clientMachine=");
            builder.append(this.clientMachine);
            builder.append(", overwrite=");
            builder.append(this.overwrite);
            if (this.opCode == FSEditLogOpCodes.OP_ADD) {
                FSEditLogOp.appendRpcIdsToString(builder, this.rpcClientId, this.rpcCallId);
            }
            builder.append(", storagePolicyId=");
            builder.append(this.storagePolicyId);
            builder.append(", erasureCodingPolicyId=");
            builder.append(this.erasureCodingPolicyId);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.toString(this.length));
            XMLUtils.addSaxString(contentHandler, "INODEID", Long.toString(this.inodeId));
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "REPLICATION", Short.toString(this.replication));
            XMLUtils.addSaxString(contentHandler, "MTIME", Long.toString(this.mtime));
            XMLUtils.addSaxString(contentHandler, "ATIME", Long.toString(this.atime));
            XMLUtils.addSaxString(contentHandler, "BLOCKSIZE", Long.toString(this.blockSize));
            XMLUtils.addSaxString(contentHandler, "CLIENT_NAME", this.clientName);
            XMLUtils.addSaxString(contentHandler, "CLIENT_MACHINE", this.clientMachine);
            XMLUtils.addSaxString(contentHandler, "OVERWRITE", Boolean.toString(this.overwrite));
            for (Block b : this.blocks) {
                FSEditLogOp.blockToXml(contentHandler, b);
            }
            FSEditLogOp.permissionStatusToXml(contentHandler, this.permissions);
            if (this.opCode == FSEditLogOpCodes.OP_ADD) {
                if (this.aclEntries != null) {
                    FSEditLogOp.appendAclEntriesToXml(contentHandler, this.aclEntries);
                }
                XMLUtils.addSaxString(contentHandler, "ERASURE_CODING_POLICY_ID", Byte.toString(this.erasureCodingPolicyId));
                FSEditLogOp.appendRpcIdsToXml(contentHandler, this.rpcClientId, this.rpcCallId);
            }
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.parseInt(st.getValue("LENGTH"));
            this.inodeId = Long.parseLong(st.getValue("INODEID"));
            this.path = st.getValue("PATH");
            this.replication = Short.parseShort(st.getValue("REPLICATION"));
            this.mtime = Long.parseLong(st.getValue("MTIME"));
            this.atime = Long.parseLong(st.getValue("ATIME"));
            this.blockSize = Long.parseLong(st.getValue("BLOCKSIZE"));
            this.clientName = st.getValue("CLIENT_NAME");
            this.clientMachine = st.getValue("CLIENT_MACHINE");
            this.overwrite = Boolean.parseBoolean(st.getValueOrNull("OVERWRITE"));
            if (st.hasChildren("BLOCK")) {
                List<XMLUtils.Stanza> blocks = st.getChildren("BLOCK");
                this.blocks = new Block[blocks.size()];
                for (int i = 0; i < blocks.size(); ++i) {
                    this.blocks[i] = FSEditLogOp.blockFromXml(blocks.get(i));
                }
            } else {
                this.blocks = new Block[0];
            }
            this.permissions = AddCloseOp.permissionStatusFromXml(st);
            this.aclEntries = FSEditLogOp.readAclEntriesFromXml(st);
            if (st.hasChildren("ERASURE_CODING_POLICY_ID")) {
                this.erasureCodingPolicyId = Byte.parseByte(st.getValue("ERASURE_CODING_POLICY_ID"));
            }
            this.readRpcIdsFromXml(st);
        }
    }

    private static final class AclEditLogUtil {
        private static final int ACL_EDITLOG_ENTRY_HAS_NAME_OFFSET = 6;
        private static final int ACL_EDITLOG_ENTRY_TYPE_OFFSET = 3;
        private static final int ACL_EDITLOG_ENTRY_SCOPE_OFFSET = 5;
        private static final int ACL_EDITLOG_PERM_MASK = 7;
        private static final int ACL_EDITLOG_ENTRY_TYPE_MASK = 3;
        private static final int ACL_EDITLOG_ENTRY_SCOPE_MASK = 1;
        private static final FsAction[] FSACTION_VALUES = FsAction.values();
        private static final AclEntryScope[] ACL_ENTRY_SCOPE_VALUES = AclEntryScope.values();
        private static final AclEntryType[] ACL_ENTRY_TYPE_VALUES = AclEntryType.values();

        private AclEditLogUtil() {
        }

        private static List<AclEntry> read(DataInputStream in, int logVersion) throws IOException {
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.EXTENDED_ACL, logVersion)) {
                return null;
            }
            int size = in.readInt();
            if (size == 0) {
                return null;
            }
            ArrayList aclEntries = Lists.newArrayListWithCapacity((int)size);
            for (int i = 0; i < size; ++i) {
                int v = in.read();
                int p = v & 7;
                int t = v >> 3 & 3;
                int s = v >> 5 & 1;
                boolean hasName = (v >> 6 & 1) == 1;
                String name = hasName ? FSImageSerialization.readString(in) : null;
                aclEntries.add(new AclEntry.Builder().setName(name).setPermission(FSACTION_VALUES[p]).setScope(ACL_ENTRY_SCOPE_VALUES[s]).setType(ACL_ENTRY_TYPE_VALUES[t]).build());
            }
            return aclEntries;
        }

        private static void write(List<AclEntry> aclEntries, DataOutputStream out) throws IOException {
            if (aclEntries == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(aclEntries.size());
            for (AclEntry e : aclEntries) {
                boolean hasName = e.getName() != null;
                int v = e.getScope().ordinal() << 5 | e.getType().ordinal() << 3 | e.getPermission().ordinal();
                if (hasName) {
                    v |= 0x40;
                }
                out.write(v);
                if (!hasName) continue;
                FSImageSerialization.writeString(e.getName(), out);
            }
        }
    }

    static interface BlockListUpdatingOp {
        public Block[] getBlocks();

        public String getPath();

        public boolean shouldCompleteLastBlock();
    }

    public static class OpInstanceCache {
        private static ThreadLocal<OpInstanceCacheMap> cache = new ThreadLocal<OpInstanceCacheMap>(){

            @Override
            protected OpInstanceCacheMap initialValue() {
                return new OpInstanceCacheMap();
            }
        };
        private boolean useCache = true;

        void disableCache() {
            this.useCache = false;
        }

        public OpInstanceCache get() {
            return this;
        }

        public <T extends FSEditLogOp> T get(FSEditLogOpCodes opCode) {
            return (T)(this.useCache ? (FSEditLogOp)cache.get().get((Object)opCode) : OpInstanceCache.newInstance(opCode));
        }

        private static FSEditLogOp newInstance(FSEditLogOpCodes opCode) {
            FSEditLogOp instance = null;
            Class<? extends FSEditLogOp> clazz = opCode.getOpClass();
            if (clazz != null) {
                try {
                    instance = clazz.newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException("Failed to instantiate " + (Object)((Object)opCode), ex);
                }
            }
            return instance;
        }

        static final class OpInstanceCacheMap
        extends EnumMap<FSEditLogOpCodes, FSEditLogOp> {
            OpInstanceCacheMap() {
                super(FSEditLogOpCodes.class);
                for (FSEditLogOpCodes opCode : FSEditLogOpCodes.values()) {
                    this.put(opCode, OpInstanceCache.newInstance(opCode));
                }
            }
        }
    }
}

