/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.wsdl.ComplexType;
import com.sforce.ws.wsdl.Constants;
import com.sforce.ws.wsdl.ParserUtil;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.SimpleType;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import javax.xml.namespace.QName;

public class Element
implements Constants {
    public static final int UNBOUNDED = -1;
    private String name;
    private QName type;
    private QName ref;
    private String nillable;
    private String minOccurs;
    private String maxOccurs;
    private Schema schema;
    private boolean isComplexType = true;

    public Element(Schema schema) {
        this.schema = schema;
    }

    public boolean isComplexType() {
        return this.isComplexType;
    }

    public QName getType() {
        return this.type;
    }

    public QName getRef() {
        return this.ref;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public int getMinOccurs() {
        return this.toRange(this.minOccurs);
    }

    public int getMaxOccurs() {
        return this.toRange(this.maxOccurs);
    }

    public boolean isNillable() {
        return "true".equals(this.nillable);
    }

    private int toRange(String occurs) {
        if (occurs == null || "".equals(occurs)) {
            return 1;
        }
        if ("unbounded".equals(occurs)) {
            return -1;
        }
        return Integer.parseInt(occurs);
    }

    public String toString() {
        return "Element{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", ref='" + this.ref + '\'' + ", nillable='" + this.nillable + '\'' + ", minOccurs='" + this.minOccurs + '\'' + ", maxOccurs='" + this.maxOccurs + '\'' + '}';
    }

    public void read(WsdlParser parser) throws WsdlParseException {
        this.name = parser.getAttributeValue(null, "name");
        this.nillable = parser.getAttributeValue(null, "nillable");
        this.minOccurs = parser.getAttributeValue(null, "minOccurs");
        this.maxOccurs = parser.getAttributeValue(null, "maxOccurs");
        this.parseType(parser);
        this.parseRef(parser);
        if (this.ref != null) {
            if (this.name != null) {
                throw new WsdlParseException("Both name and ref can not be specified for element: " + this.name);
            }
            if (this.type != null) {
                throw new WsdlParseException("Both type and ref can not be specified for element with ref: " + this.ref);
            }
        }
        int eventType = parser.getEventType();
        while (true) {
            if (eventType == 2) {
                String n = parser.getName();
                String ns = parser.getNamespace();
                if ("complexType".equals(n) && "http://www.w3.org/2001/XMLSchema".equals(ns)) {
                    ComplexType complexType = new ComplexType(this.schema);
                    String ctn = String.valueOf(this.name) + "_element";
                    this.type = new QName(this.schema.getTargetNamespace(), ctn);
                    complexType.read(parser, ctn);
                    this.schema.addComplexType(complexType);
                    this.isComplexType = true;
                } else if ("simpleType".equals(n) && "http://www.w3.org/2001/XMLSchema".equals(ns)) {
                    SimpleType simpleType = new SimpleType(this.schema);
                    String stn = String.valueOf(this.name) + "_element";
                    this.type = new QName(this.schema.getTargetNamespace(), stn);
                    simpleType.read(parser, stn);
                    this.schema.addSimpleType(simpleType);
                    this.isComplexType = false;
                }
            } else if (eventType == 3) {
                String name = parser.getName();
                String namespace = parser.getNamespace();
                if ("element".equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    return;
                }
            } else if (eventType == 1) {
                throw new WsdlParseException("Failed to find end tag for 'complexType'");
            }
            eventType = parser.next();
        }
    }

    private void parseType(WsdlParser parser) {
        String t = parser.getAttributeValue(null, "type");
        if (t != null) {
            this.type = ParserUtil.toQName(t, parser);
            this.isComplexType = !"http://www.w3.org/2001/XMLSchema".equals(this.type.getNamespaceURI());
        }
    }

    private void parseRef(WsdlParser parser) throws WsdlParseException {
        String r = parser.getAttributeValue(null, "ref");
        if (r != null) {
            if ("".equals(r)) {
                throw new WsdlParseException("Element ref can not be empty, at: " + parser.getPositionDescription());
            }
            this.ref = ParserUtil.toQName(r, parser);
            if (this.ref.getNamespaceURI() == null || "".equals(this.ref.getNamespaceURI())) {
                this.ref = new QName(this.schema.getTargetNamespace(), this.ref.getLocalPart());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    void setType(QName type) {
        this.type = type;
    }
}

