/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandrasstableoutput.writer;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Map;
import org.apache.cassandra.io.sstable.CQLSSTableWriter;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.databases.cassandra.util.CassandraUtils;
import org.apache.hop.pipeline.transforms.cassandrasstableoutput.writer.AbstractSSTableWriter;

class Cql3SSTableWriter
extends AbstractSSTableWriter {
    private CQLSSTableWriter writer;
    private IRowMeta rowMeta;

    Cql3SSTableWriter() {
    }

    @Override
    public void init() throws Exception {
        this.writer = this.getCQLSSTableWriter();
    }

    CQLSSTableWriter getCQLSSTableWriter() {
        return CQLSSTableWriter.builder().inDirectory(this.getDirectory()).forTable(this.buildCreateTableCQLStatement()).using(this.buildInsertCQLStatement()).withBufferSizeInMB(this.getBufferSize()).build();
    }

    @Override
    public void processRow(Map<String, Object> record) throws Exception {
        this.writer.addRow(record);
    }

    @Override
    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void setRowMeta(IRowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    String buildCreateTableCQLStatement() {
        StringBuilder tableColumnsSpecification = new StringBuilder();
        for (IValueMeta valueMeta : this.rowMeta.getValueMetaList()) {
            tableColumnsSpecification.append(CassandraUtils.cql3MixedCaseQuote(valueMeta.getName())).append(" ").append(CassandraUtils.getCQLTypeForValueMeta(valueMeta)).append(",");
        }
        tableColumnsSpecification.append("PRIMARY KEY (\"").append(this.getPrimaryKey().replaceAll(",", "\",\"")).append("\" )");
        return String.format("CREATE TABLE %s.%s (%s);", this.getKeyspace(), this.getTable(), tableColumnsSpecification);
    }

    String buildInsertCQLStatement() {
        Joiner columnsJoiner = Joiner.on((String)"\",\"").skipNulls();
        Joiner valuesJoiner = Joiner.on((String)",").skipNulls();
        Object[] columnNames = this.rowMeta.getFieldNames();
        Object[] valuePlaceholders = new String[columnNames.length];
        Arrays.fill(valuePlaceholders, "?");
        return String.format("INSERT INTO %s.%s (\"%s\") VALUES (%s);", this.getKeyspace(), this.getTable(), columnsJoiner.join(columnNames), valuesJoiner.join(valuePlaceholders));
    }
}

