/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Description(value="Options that are used to configure Google Cloud Pub/Sub. See https://cloud.google.com/pubsub/docs/overview for details on Cloud Pub/Sub.")
public interface PubsubOptions
extends ApplicationNameOptions,
GcpOptions,
PipelineOptions,
StreamingOptions {
    @Internal
    public static @UnknownKeyFor @NonNull @Initialized String targetForRootUrl(@UnknownKeyFor @NonNull @Initialized String urlString) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Could not parse pubsub root url \"%s\"", urlString), e);
        }
        int port = url.getPort();
        if (port < 0) {
            switch (url.getProtocol()) {
                case "https": {
                    port = 443;
                    break;
                }
                case "http": {
                    port = 80;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Could not determine port for pubsub root url \"%s\". You must either specify the port or use the protocol \"https\" or \"http\"", urlString));
                }
            }
        }
        return String.format("%s:%d", url.getHost(), port);
    }

    @Description(value="Root URL for use with the Google Cloud Pub/Sub API")
    @Default.String(value="https://pubsub.googleapis.com")
    @Hidden
    public @UnknownKeyFor @NonNull @Initialized String getPubsubRootUrl();

    public void setPubsubRootUrl(@UnknownKeyFor @NonNull @Initialized String var1);
}

