/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import io.github.spannm.jackcess.Cursor;
import io.github.spannm.jackcess.CursorBuilder;
import io.github.spannm.jackcess.Index;
import io.github.spannm.jackcess.Table;
import io.github.spannm.jackcess.complex.ComplexValueForeignKey;
import io.github.spannm.jackcess.util.SimpleColumnMatcher;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.exception.UcanaccessRuntimeException;
import net.ucanaccess.util.Try;

public final class IndexSelector {
    private final Table table;
    private Index bestIndex;
    private boolean primaryCursor;

    public IndexSelector(Table _table) {
        this.table = _table;
    }

    public Index getBestIndex() {
        if (this.bestIndex == null) {
            List li = this.table.getIndexes();
            for (Index idx : li) {
                if (!idx.isPrimaryKey()) continue;
                this.bestIndex = idx;
                this.primaryCursor = true;
                break;
            }
            if (this.bestIndex == null) {
                for (Index idx : li) {
                    if (!idx.isUnique()) continue;
                    this.bestIndex = idx;
                    break;
                }
            }
            if (this.bestIndex == null && li.size() == 1) {
                this.bestIndex = (Index)li.get(0);
            }
        }
        return this.bestIndex;
    }

    public Cursor getCursor() throws IOException {
        Index idx = this.getBestIndex();
        CursorBuilder cb = this.table.newCursor();
        Cursor cursor = idx == null ? cb.toCursor() : cb.withIndex(idx).toCursor();
        cursor.setColumnMatcher((io.github.spannm.jackcess.util.ColumnMatcher)new ColumnMatcher());
        return cursor;
    }

    public boolean isPrimaryCursor() {
        return this.primaryCursor;
    }

    private static final class ColumnMatcher
    extends SimpleColumnMatcher {
        private ColumnMatcher() {
        }

        public boolean matches(Table _table, String _columnName, Object _currVal, Object _dbVal) {
            if (_currVal == null && _dbVal == null) {
                return true;
            }
            if (_currVal == null || _dbVal == null) {
                return false;
            }
            if (_currVal instanceof Date && _dbVal instanceof Date) {
                return ((Date)_currVal).compareTo((Date)_dbVal) == 0;
            }
            if (_currVal instanceof BigDecimal && _dbVal instanceof BigDecimal) {
                return ((BigDecimal)_currVal).compareTo((BigDecimal)_dbVal) == 0;
            }
            if (_dbVal instanceof BigDecimal && _currVal instanceof Number) {
                return ((BigDecimal)_dbVal).compareTo(new BigDecimal(_currVal.toString())) == 0;
            }
            if (_currVal instanceof BigDecimal && _dbVal instanceof Number) {
                return ((BigDecimal)_currVal).compareTo(new BigDecimal(_dbVal.toString())) == 0;
            }
            if (_currVal instanceof Integer && _dbVal instanceof Short) {
                return ((Integer)_currVal).intValue() == ((Short)_dbVal).intValue();
            }
            if (_dbVal instanceof Integer && _currVal instanceof Short) {
                return ((Integer)_dbVal).intValue() == ((Short)_currVal).intValue();
            }
            if (_currVal instanceof Integer && _dbVal instanceof Byte) {
                return (Integer)_currVal == SQLConverter.asUnsigned((Byte)_dbVal);
            }
            if (_dbVal instanceof Integer && _currVal instanceof Byte) {
                return (Integer)_dbVal == SQLConverter.asUnsigned((Byte)_currVal);
            }
            if (_dbVal instanceof Float && _currVal instanceof Double || _dbVal instanceof Double && _currVal instanceof Float) {
                if (new BigDecimal(_dbVal.toString()).compareTo(new BigDecimal(_currVal.toString())) == 0) {
                    return true;
                }
                if (_dbVal instanceof Float && _currVal instanceof Double) {
                    return ((Float)_dbVal).doubleValue() == ((Double)_currVal).doubleValue();
                }
            }
            if (_currVal instanceof byte[] && _dbVal instanceof byte[]) {
                return true;
            }
            if (_currVal instanceof ComplexBase[] && _dbVal instanceof ComplexValueForeignKey) {
                return Try.catching(() -> Arrays.equals((ComplexBase[])_currVal, ComplexBase.convert((ComplexValueForeignKey)_dbVal))).orThrow(UcanaccessRuntimeException::new);
            }
            return super.matches(_table, _columnName, _currVal, _dbVal);
        }
    }
}

