/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400AuthenticationException;
import com.ibm.as400.security.auth.AS400CredentialEvent;
import com.ibm.as400.security.auth.AS400CredentialImpl;
import com.ibm.as400.security.auth.AS400CredentialListener;
import com.ibm.as400.security.auth.AS400Principal;
import com.ibm.as400.security.auth.AS400SwappableCredential;
import com.ibm.as400.security.auth.AuthenticationSystem;
import com.ibm.as400.security.auth.RefreshAgent;
import com.ibm.as400.security.auth.ResourceBundleLoader_a;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Vector;

public abstract class AS400Credential
implements Serializable,
AS400SwappableCredential {
    static final long serialVersionUID = 4L;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private transient Vector listeners_;
    transient AS400CredentialImpl impl_;
    private transient RefreshAgent rAgent_;
    protected AS400 system_ = null;
    protected AS400Principal principal_ = null;
    private Boolean renewable_ = null;
    private Boolean standalone_ = null;
    private Boolean timed_ = null;
    boolean private_ = true;
    private static int minVRM_ = 0;
    private static ResourceBundleLoader_a loader_;
    public static final int CR_AUTO_REFRESH_FAILED = 0;
    public static final int CR_AUTO_REFRESH_NOT_VALID = 1;
    public static final int CR_AUTO_REFRESH_STARTED = 2;
    public static final int CR_AUTO_REFRESH_STOPPED = 3;
    private static String permissionClassName_;
    private static Constructor permissionClassConstructor_;
    private static String permissionCheckMethodName_;
    private static Method permissionCheckMethod_;

    public AS400Credential() {
        this.initTransient();
    }

    public void addCredentialListener(AS400CredentialListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.listeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public String[] basicAuthenticationPrompt() {
        String[] stringArray = new String[2];
        stringArray[0] = ResourceBundleLoader_a.getCoreText("DLG_USER_ID_LABEL");
        stringArray[1] = ResourceBundleLoader_a.getCoreText("DLG_PASSWORD_LABEL");
        return stringArray;
    }

    void checkAuthenticationPermission(String p) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && permissionCheckMethod_ != null && permissionClassConstructor_ != null) {
            try {
                permissionCheckMethod_.invoke((Object)sm, permissionClassConstructor_.newInstance(p));
            }
            catch (InvocationTargetException ite) {
                Trace.log(1, "Authentication permission check failed: " + p);
                Throwable t = ite.getTargetException();
                if (t instanceof SecurityException) {
                    throw (SecurityException)t;
                }
                AuthenticationSystem.handleUnexpectedException(t);
            }
            catch (Exception e) {
                AuthenticationSystem.handleUnexpectedException(e);
            }
        }
    }

    public void destroy() throws AS400SecurityException {
        this.checkAuthenticationPermission("destroyCredential");
        this.stopAutomaticRefresh();
        if (this.impl_ != null) {
            this.impl_.destroy();
            this.setImpl(null);
        }
        this.invalidateProperties();
        this.fireDestroyed();
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("Credential destroyed >> ").append(this.toString()).toString());
        }
    }

    protected void finalize() throws Throwable {
        this.stopAutomaticRefresh();
        super.finalize();
    }

    void fireCreated() {
        Vector targets = (Vector)this.listeners_.clone();
        AS400CredentialEvent event = new AS400CredentialEvent(this, 0);
        for (int i = 0; i < targets.size(); ++i) {
            AS400CredentialListener target = (AS400CredentialListener)targets.elementAt(i);
            target.created(event);
        }
    }

    void fireDestroyed() {
        Vector targets = (Vector)this.listeners_.clone();
        AS400CredentialEvent event = new AS400CredentialEvent(this, 1);
        for (int i = 0; i < targets.size(); ++i) {
            AS400CredentialListener target = (AS400CredentialListener)targets.elementAt(i);
            target.destroyed(event);
        }
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changes_.firePropertyChange(propertyName, oldValue, newValue);
    }

    void fireRefreshed() {
        Vector targets = (Vector)this.listeners_.clone();
        AS400CredentialEvent event = new AS400CredentialEvent(this, 2);
        for (int i = 0; i < targets.size(); ++i) {
            AS400CredentialListener target = (AS400CredentialListener)targets.elementAt(i);
            target.refreshed(event);
        }
    }

    void fireSwapped() {
        Vector targets = (Vector)this.listeners_.clone();
        AS400CredentialEvent event = new AS400CredentialEvent(this, 3);
        for (int i = 0; i < targets.size(); ++i) {
            AS400CredentialListener target = (AS400CredentialListener)targets.elementAt(i);
            target.swapped(event);
        }
    }

    void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.vetos_.fireVetoableChange(propertyName, oldValue, newValue);
    }

    public Throwable getAutomaticRefreshFailure() {
        if (this.rAgent_ != null) {
            return this.rAgent_.getFailure();
        }
        return null;
    }

    public int getAutomaticRefreshStatus() {
        if (!this.isRenewable() || this.getSystem() == null || !this.getSystem().isThreadUsed()) {
            return 1;
        }
        if (this.rAgent_ != null) {
            if (this.rAgent_.getFailure() != null) {
                return 0;
            }
            if (this.rAgent_.isAlive()) {
                return 2;
            }
        }
        return 3;
    }

    AS400CredentialImpl getImpl() throws AS400SecurityException {
        if (this.impl_ == null) {
            this.validateProperties();
            this.setImpl(this.getImplPrimitive());
        }
        return this.impl_;
    }

    AS400CredentialImpl getImplPrimitive() throws AS400SecurityException {
        AS400CredentialImpl impl = null;
        try {
            try {
                impl = (AS400CredentialImpl)Class.forName(this.implClassName()).newInstance();
            }
            catch (Exception e) {
                if (this.implClassNameNative() != null && this.implClassName().equals(this.implClassNameNative())) {
                    Trace.log(1, "Load of native implementation '" + this.implClassNameNative() + "' failed, attempting to load remote implementation.");
                    impl = (AS400CredentialImpl)Class.forName(this.implClassNameRemote()).newInstance();
                }
                throw e;
            }
            if (impl.getVersion() < this.typeMinImplVersion()) {
                if (this.implClassNameNative() != null && impl.getClass().getName().equals(this.implClassNameNative())) {
                    Trace.log(1, new StringBuffer("Native impl '").append(impl.getClass().getName()).append("' found at version ").append(impl.getVersion()).append(" not sufficient to meet required level ").append(this.typeMinImplVersion()).append(". Attempting to load remote impl instead.").toString());
                    impl = (AS400CredentialImpl)Class.forName(this.implClassNameRemote()).newInstance();
                    if (impl.getVersion() < this.typeMinImplVersion()) {
                        Trace.log(1, new StringBuffer("Remote impl '").append(impl.getClass().getName()).append("' found at version ").append(impl.getVersion()).append(" not sufficient to meet required level ").append(this.typeMinImplVersion()).toString());
                        impl = null;
                    }
                } else {
                    impl = null;
                }
                if (impl == null) {
                    Trace.log(1, "Load of implementation for " + this.getClass().getName() + " failed.");
                    throw new ExtendedIllegalStateException(11);
                }
            }
            impl.setCredential(this);
        }
        catch (Exception e) {
            Trace.log(1, "Load of implementation " + this.implClassName() + " failed.");
            AuthenticationSystem.handleUnexpectedException(e);
        }
        return impl;
    }

    public AS400Principal getPrincipal() {
        return this.principal_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public int getTimeToExpiration() throws AS400SecurityException {
        if (this.isTimed()) {
            return this.getImpl().getTimeToExpiration();
        }
        return 0;
    }

    String implClassName() {
        if (this.implClassNameNative() != null && AuthenticationSystem.isLocal(this.getSystem())) {
            return this.implClassNameNative();
        }
        return this.implClassNameRemote();
    }

    String implClassNameNative() {
        return null;
    }

    String implClassNameRemote() {
        return "com.ibm.as400.security.auth.AS400CredentialImplRemote";
    }

    void initTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.listeners_ = new Vector();
        this.rAgent_ = null;
        this.setImpl(null);
    }

    void invalidateProperties() {
        this.system_ = null;
        this.principal_ = null;
        this.renewable_ = null;
        this.standalone_ = null;
        this.timed_ = null;
    }

    boolean isConnected() {
        return this.impl_ != null;
    }

    public boolean isCurrent() {
        try {
            if (!this.isDestroyed()) {
                return this.getImpl().isCurrent();
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            // empty catch block
        }
        return false;
    }

    public boolean isDestroyed() {
        if (this.impl_ == null) {
            try {
                this.validateProperties();
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    public boolean isPrivate() {
        return this.private_;
    }

    public boolean isRenewable() {
        if (this.renewable_ != null) {
            return this.renewable_;
        }
        return this.typeIsRenewable();
    }

    boolean isStandalone() {
        if (this.standalone_ != null) {
            return this.standalone_;
        }
        return this.typeIsStandalone();
    }

    public boolean isTimed() {
        if (this.timed_ != null) {
            return this.timed_;
        }
        return this.typeIsTimed();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initTransient();
    }

    public void refresh() throws AS400SecurityException {
        this.checkAuthenticationPermission("refreshCredential");
        if (!this.isRenewable()) {
            return;
        }
        this.getImpl().refresh();
        this.fireRefreshed();
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("Credential refreshed >> ").append(this.toString()).toString());
        }
    }

    public void removeCredentialListener(AS400CredentialListener listener) {
        this.listeners_.removeElement(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos_.removeVetoableChangeListener(listener);
    }

    void setImpl(AS400CredentialImpl impl) {
        this.impl_ = impl;
    }

    void setIsRenewable(boolean b) {
        this.validatePropertyChange("isRenewable");
        this.renewable_ = b;
    }

    void setIsStandalone(boolean b) {
        this.validatePropertyChange("isStandalone");
        this.standalone_ = b;
    }

    void setIsTimed(boolean b) {
        this.validatePropertyChange("isTimed");
        this.timed_ = b;
    }

    public void setPrincipal(AS400Principal p) throws PropertyVetoException {
        this.validatePropertyChange("principal");
        AS400Principal old = this.getPrincipal();
        this.fireVetoableChange("principal", old, p);
        this.principal_ = p;
        this.firePropertyChange("principal", old, p);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        this.validatePropertyChange("system");
        AS400 old = this.getSystem();
        this.fireVetoableChange("system", old, system);
        this.system_ = system;
        this.firePropertyChange("system", old, system);
    }

    public void startAutomaticRefresh(int refreshInterval, int maxRefreshes) {
        int s = this.getAutomaticRefreshStatus();
        if (s == 1) {
            Trace.log(2, "Automatic refresh for " + this.toString() + " not valid.");
            throw new IllegalStateException("automaticRefreshStatus");
        }
        if (s == 2) {
            Trace.log(2, "Automatic refresh for " + this.toString() + " already started.");
            throw new IllegalStateException("automaticRefreshStatus");
        }
        if (refreshInterval <= 0) {
            Trace.log(2, "Refresh interval " + refreshInterval + " must be > 0.");
            throw new ExtendedIllegalArgumentException("refreshInterval", 4);
        }
        if (maxRefreshes < -1) {
            Trace.log(2, "Maximum number of refreshes " + maxRefreshes + " must be >= -1.");
            throw new ExtendedIllegalArgumentException("maxRefreshes", 4);
        }
        this.rAgent_ = new RefreshAgent(this, refreshInterval, maxRefreshes);
        this.rAgent_.start();
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("Automatic refresh started >> ").append(this.toString()).toString());
        }
    }

    public void stopAutomaticRefresh() {
        if (this.rAgent_ == null || !this.rAgent_.isAlive()) {
            return;
        }
        this.rAgent_.stopRefresh();
        this.rAgent_ = null;
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("Automatic refresh stopped >> ").append(this.toString()).toString());
        }
    }

    @Override
    public void swap() throws Exception {
        this.swap(false);
    }

    public AS400Credential swap(boolean returnCredential) throws AS400SecurityException {
        this.checkAuthenticationPermission("modifyThreadIdentity");
        this.validatePrincipalCompatibility();
        AS400Credential cr = null;
        try {
            cr = this.getImpl().swap(returnCredential);
            if (this.getSystem() != AuthenticationSystem.localHost()) {
                AuthenticationSystem.resetLocalHost();
            }
            this.getSystem().resetAllServices();
            this.getSystem().setUserId("*CURRENT");
            this.getSystem().setPassword("*CURRENT".toCharArray());
            this.getSystem().getServicePort(7);
            this.fireSwapped();
            if (Trace.isTraceOn()) {
                Trace.log(3, new StringBuffer("Credential swapped >> ").append(this.toString()).toString());
            }
        }
        catch (PropertyVetoException pve) {
            AuthenticationSystem.handleUnexpectedException(pve);
        }
        return cr;
    }

    boolean typeIsRenewable() {
        return false;
    }

    boolean typeIsStandalone() {
        return false;
    }

    boolean typeIsTimed() {
        return false;
    }

    int typeMinImplVersion() {
        return 1;
    }

    int typeMinVRM() {
        if (minVRM_ == 0) {
            minVRM_ = AS400.generateVRM(4, 5, 0);
        }
        return minVRM_;
    }

    void validatePrincipalCompatibility() {
        if (this.isStandalone() || this.getPrincipal() == null || this.getPrincipal().getSystem() == null) {
            return;
        }
        if (this.getPrincipal().getSystem().equals(this.getSystem())) {
            Trace.log(2, "Incompatible credential and principal systems.");
            throw new IllegalStateException("system");
        }
    }

    void validateProperties() {
        this.validatePropertySet("system", this.getSystem());
        if (!this.isStandalone()) {
            this.validatePropertySet("principal", this.getPrincipal());
        }
    }

    void validatePropertyChange(String propertyName) {
        if (this.isConnected()) {
            Trace.log(2, "Property '" + propertyName + "' not changed (connected=true).");
            throw new ExtendedIllegalStateException(propertyName, 5);
        }
    }

    void validatePropertySet(String propertyName, Object value) {
        if (value == null) {
            Trace.log(2, "Required property '" + propertyName + "' not set.");
            throw new ExtendedIllegalStateException(4);
        }
    }

    void validateVRM() throws AS400SecurityException {
        try {
            if (this.getSystem().getVRM() < this.typeMinVRM()) {
                Trace.log(2, "VRM<" + this.typeMinVRM());
                throw new AS400AuthenticationException(38);
            }
        }
        catch (Exception ioe) {
            AuthenticationSystem.handleUnexpectedException(ioe);
        }
    }

    public static void clearArray(char[] passwordChars) {
        if (passwordChars != null && passwordChars.length > 0) {
            Arrays.fill(passwordChars, '\u0000');
        }
    }

    static {
        permissionClassName_ = "javax.security.auth.AuthPermission";
        permissionClassConstructor_ = null;
        permissionCheckMethodName_ = "checkPermission";
        permissionCheckMethod_ = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                Class<?> permissionClass_ = Class.forName(permissionClassName_);
                permissionClassConstructor_ = permissionClass_.getConstructor(String.class);
                permissionCheckMethod_ = sm.getClass().getMethod(permissionCheckMethodName_, Class.forName("java.security.Permission"));
            }
            catch (AccessControlException acf) {
                Trace.log(4, "Access to permission class is denied by SecurityManager, JAAS permissions will not be checked.", (Throwable)acf);
            }
            catch (ClassNotFoundException cnf) {
                Trace.log(4, "Unable to resolve permission class, JAAS permissions will not be checked.", (Throwable)cnf);
            }
            catch (NoClassDefFoundError ncd) {
                Trace.log(4, "Unable to resolve permission class, JAAS permissions will not be checked.", (Throwable)ncd);
            }
            catch (NoSuchMethodException nsm) {
                Trace.log(4, "Security manager does not implement method '" + permissionCheckMethodName_ + "'. JAAS permissions will not be checked.", (Throwable)nsm);
            }
        }
    }
}

