/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.AbstractValueMap;
import com.ibm.as400.resource.BooleanValueMap;
import com.ibm.as400.resource.ChangeableResource;
import com.ibm.as400.resource.CommandAttributeSetter;
import com.ibm.as400.resource.CommandMap;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.QualifiedValueMap;
import com.ibm.as400.resource.QuoteValueMap;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceLevel;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.ValueMap;
import java.beans.PropertyVetoException;

public class RPrinter
extends ChangeableResource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_;
    private static final String ICON_BASE_NAME_ = "RPrinter";
    private static final String PRESENTATION_KEY_ = "PRINTER";
    public static final String OPERATION_FILE_END = "*FILEEND";
    public static final String OPERATION_NO_FILES_READY = "*NORDYF";
    public static final String OPERATION_NONE = "*NO";
    public static final String PENDING_STATUS_CONTROLLED = "C";
    public static final String PENDING_STATUS_IMMEDIATE = "I";
    public static final String PENDING_STATUS_NONE = "N";
    public static final String PENDING_STATUS_PAGE_END = "P";
    public static final Integer SEPARATOR_PAGE_DEVICE;
    public static final Integer SEPARATOR_PAGE_FILE;
    public static final Integer SEPARATOR_PAGE_NONE;
    public static final String STATUS_HELD = "H";
    public static final String STATUS_RELEASED = "R";
    static ResourceMetaDataTable attributes_;
    private static ProgramMap getterMap_;
    private static CommandMap setterMap_;
    private static final BooleanValueMap booleanValueMap01_;
    private static final BooleanValueMap booleanValueMapNoYes_;
    private static final BooleanValueMap booleanValueMapNY_;
    private static final QuoteValueMap quoteValueMapBlank_;
    private static final QuoteValueMap quoteValueMapEmpty_;
    private static final ValueMap separatorValueMap_;
    private static final String CHGDEVPRT_ = "CHGDEVPRT";
    private static final String CHGWTR_ = "CHGWTR";
    private static final String RPTA0100_ = "qgyrprta_rpta0100";
    private static final String DEVD_PARAMETER_ = "DEVD";
    private static final String WTR_PARAMETER_ = "WTR";
    public static final String ADVANCED_FUNCTION_PRINTING = "ADVANCED_FUNCTION_PRINTING";
    public static final String ALIGN_FORMS = "ALIGN_FORMS";
    public static final String ALIGN_FORMS_WRITER = "*WTR";
    public static final String ALIGN_FORMS_FILE = "*FILE";
    public static final String ALLOW_DIRECT_PRINTING = "ALLOW_DIRECT_PRINTING";
    public static final String AUTOMATICALLY_END_WRITER = "AUTOMATICALLY_END_WRITER";
    public static final String BETWEEN_COPIES_STATUS = "BETWEEN_COPIES_STATUS";
    public static final String BETWEEN_FILES_STATUS = "BETWEEN_FILES_STATUS";
    public static final String CHANGES_TAKE_EFFECT = "CHANGES_TAKE_EFFECT";
    public static final String COPIES_LEFT_TO_PRODUCE = "COPIES_LEFT_TO_PRODUCE";
    public static final String DEVICE_NAME = "DEVICE_NAME";
    public static final String DEVICE_STATUS = "DEVICE_STATUS";
    public static final String DEVICE_TYPE = "DEVICE_TYPE";
    public static final String END_PENDING_STATUS = "END_PENDING_STATUS";
    public static final String FORM_TYPE = "FORM_TYPE";
    public static final String FORM_TYPE_ALL = "*ALL";
    public static final String FORM_TYPE_FORMS = "*FORMS";
    public static final String FORM_TYPE_STANDARD = "*STD";
    public static final String HELD_STATUS = "HELD_STATUS";
    public static final String HOLD_PENDING_STATUS = "HOLD_PENDING_STATUS";
    public static final String JOB_NAME = "JOB_NAME";
    public static final String JOB_NUMBER = "JOB_NUMBER";
    public static final String JOB_QUEUE_STATUS = "JOB_QUEUE_STATUS";
    public static final String MESSAGE_KEY = "MESSAGE_KEY";
    public static final String MESSAGE_OPTION = "MESSAGE_OPTION";
    public static final String MESSAGE_OPTION_MESSAGE = "*MSG";
    public static final String MESSAGE_OPTION_NO_MESSAGE = "*NOMSG";
    public static final String MESSAGE_OPTION_INFORMATIONAL_MESSAGE = "*INFOMSG";
    public static final String MESSAGE_OPTION_INQUIRY_MESSAGE = "*INQMSG";
    public static final String MESSAGE_QUEUE = "MESSAGE_QUEUE";
    public static final String NEXT_FILE_SEPARATORS = "NEXT_FILE_SEPARATORS";
    public static final String NEXT_FORM_TYPE = "NEXT_FORM_TYPE";
    public static final String NEXT_MESSAGE_OPTION = "NEXT_MESSAGE_OPTION";
    public static final String NEXT_OUTPUT_QUEUE = "NEXT_OUTPUT_QUEUE";
    public static final String NEXT_SEPARATOR_DRAWER = "NEXT_SEPARATOR_DRAWER";
    public static final String NUMBER_OF_SEPARATORS = "NUMBER_OF_SEPARATORS";
    public static final String OUTPUT_QUEUE = "OUTPUT_QUEUE";
    public static final String OUTPUT_QUEUE_STATUS = "OUTPUT_QUEUE_STATUS";
    public static final String OVERALL_STATUS = "OVERALL_STATUS";
    public static final String PAGE_BEING_WRITTEN = "PAGE_BEING_WRITTEN";
    public static final String PUBLISHED_STATUS = "PUBLISHED_STATUS";
    public static final String SEPARATOR_DRAWER = "SEPARATOR_DRAWER";
    public static final String SPOOLED_FILE_NAME = "SPOOLED_FILE_NAME";
    public static final String SPOOLED_FILE_NUMBER = "SPOOLED_FILE_NUMBER";
    public static final String STARTED_BY_USER = "STARTED_BY_USER";
    public static final String TEXT_DESCRIPTION = "TEXT_DESCRIPTION";
    public static final String TOTAL_COPIES = "TOTAL_COPIES";
    public static final String TOTAL_PAGES = "TOTAL_PAGES";
    public static final String USER_NAME = "USER_NAME";
    public static final String WAITING_FOR_DATA_STATUS = "WAITING_FOR_DATA_STATUS";
    public static final String WAITING_FOR_DEVICE_STATUS = "WAITING_FOR_DEVICE_STATUS";
    public static final String WAITING_FOR_MESSAGE_STATUS = "WAITING_FOR_MESSAGE_STATUS";
    public static final String WRITER_JOB_NAME = "WRITER_JOB_NAME";
    public static final String WRITER_JOB_NUMBER = "WRITER_JOB_NUMBER";
    public static final String WRITER_JOB_USER_NAME = "WRITER_JOB_USER_NAME";
    public static final String WRITER_STARTED = "WRITER_STARTED";
    public static final String WRITER_STATUS = "WRITER_STATUS";
    public static final byte[] WRITER_STATUS_STARTED;
    public static final byte[] WRITER_STATUS_ENDED;
    public static final byte[] WRITER_STATUS_JOB_QUEUE;
    public static final byte[] WRITER_STATUS_HELD;
    public static final byte[] WRITER_STATUS_MESSAGE_WAITING;
    public static final String WRITING_STATUS = "WRITING_STATUS";
    public static final String WRITING_STATUS_YES = "Y";
    public static final String WRITING_STATUS_NO = "N";
    public static final String WRITING_STATUS_SEPARATORS = "S";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RPrinter";
    private static ProgramCallDocument staticDocument_;
    private String name_ = null;
    private ProgramAttributeGetter attributeGetter_ = null;
    private CommandAttributeSetter attributeSetter_ = null;

    public RPrinter() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    public RPrinter(AS400 system, String name) {
        this();
        try {
            this.setSystem(system);
            this.setName(name);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    protected void commitAttributeChanges(Object[] attributeIDs, Object[] values, int[] bidiStringTypes) throws ResourceException {
        super.commitAttributeChanges(attributeIDs, values, bidiStringTypes);
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        this.attributeSetter_.setValues(attributeIDs, values, bidiStringTypes);
    }

    static Object computeResourceKey(AS400 system, String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(RPrinter.class);
        buffer.append(':');
        buffer.append(system.getSystemName());
        buffer.append(':');
        buffer.append(system.getUserId());
        buffer.append(':');
        buffer.append(name);
        return buffer.toString();
    }

    @Override
    protected void establishConnection() throws ResourceException {
        ProgramCallDocument document;
        AS400 system;
        String nameUpper;
        block3: {
            if (this.name_ == null) {
                throw new ExtendedIllegalStateException("name", 4);
            }
            nameUpper = this.name_.toUpperCase();
            system = this.getSystem();
            document = (ProgramCallDocument)staticDocument_.clone();
            try {
                document.setSystem(system);
                document.setValue("qgyrprta_rpta0100.deviceName", nameUpper);
            }
            catch (PcmlException e) {
                if (!Trace.isTraceOn()) break block3;
                Trace.log(2, "Error setting PCML document values", (Throwable)e);
            }
        }
        this.attributeGetter_ = new ProgramAttributeGetter(system, document, getterMap_);
        this.attributeSetter_ = new CommandAttributeSetter(system, setterMap_);
        this.attributeSetter_.setParameterValue(CHGWTR_, WTR_PARAMETER_, nameUpper);
        this.attributeSetter_.setParameterValue(CHGDEVPRT_, DEVD_PARAMETER_, nameUpper);
        super.establishConnection();
    }

    @Override
    protected void freezeProperties() throws ResourceException {
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        Presentation presentation = this.getPresentation();
        presentation.setName(this.name_);
        if (this.getResourceKey() == null) {
            this.setResourceKey(RPrinter.computeResourceKey(this.getSystem(), this.name_));
        }
        super.freezeProperties();
    }

    @Override
    public Object getAttributeUnchangedValue(Object attributeID, int bidiStringType) throws ResourceException {
        Object value = super.getAttributeUnchangedValue(attributeID, bidiStringType);
        if (value == null) {
            if (!this.isConnectionEstablished()) {
                this.establishConnection();
            }
            value = this.attributeGetter_.getValue(attributeID, bidiStringType);
        }
        return value;
    }

    public String getName() {
        return this.name_;
    }

    @Override
    protected boolean isBidiEnabled() {
        return true;
    }

    @Override
    public void refreshAttributeValues() throws ResourceException {
        super.refreshAttributeValues();
        if (this.attributeGetter_ != null) {
            this.attributeGetter_.clearBuffer();
        }
    }

    public void setName(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String oldValue = this.name_;
        this.fireVetoableChange("name", oldValue, name);
        this.name_ = name;
        this.firePropertyChange("name", oldValue, name);
    }

    static {
        block2: {
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            SEPARATOR_PAGE_DEVICE = -2;
            SEPARATOR_PAGE_FILE = -1;
            SEPARATOR_PAGE_NONE = -10;
            attributes_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            getterMap_ = new ProgramMap();
            setterMap_ = new CommandMap();
            booleanValueMap01_ = new BooleanValueMap("0", "1");
            booleanValueMapNoYes_ = new BooleanValueMap(new String[]{OPERATION_NONE, ""}, new String[]{"*YES"});
            booleanValueMapNY_ = new BooleanValueMap(new String[]{"N", ""}, new String[]{WRITING_STATUS_YES});
            quoteValueMapBlank_ = new QuoteValueMap("*BLANK");
            quoteValueMapEmpty_ = new QuoteValueMap("");
            separatorValueMap_ = new AbstractValueMap(){

                @Override
                public Object ltop(Object logicalValue) {
                    if (logicalValue.equals(SEPARATOR_PAGE_FILE)) {
                        return RPrinter.ALIGN_FORMS_FILE;
                    }
                    if (logicalValue.equals(SEPARATOR_PAGE_DEVICE)) {
                        return "*DEVD";
                    }
                    return logicalValue;
                }
            };
            attributes_.add((Object)ADVANCED_FUNCTION_PRINTING, Boolean.class, true);
            getterMap_.add((Object)ADVANCED_FUNCTION_PRINTING, RPTA0100_, "receiverVariable.advancedFunctionPrinting", booleanValueMapNoYes_);
            attributes_.add(ALIGN_FORMS, String.class, true, new Object[]{ALIGN_FORMS_WRITER, ALIGN_FORMS_FILE, ""}, null, true);
            getterMap_.add(ALIGN_FORMS, RPTA0100_, "receiverVariable.alignForms");
            attributes_.add((Object)ALLOW_DIRECT_PRINTING, Boolean.class, true);
            getterMap_.add((Object)ALLOW_DIRECT_PRINTING, RPTA0100_, "receiverVariable.allowDirectPrinting", booleanValueMapNoYes_);
            attributes_.add(AUTOMATICALLY_END_WRITER, String.class, true, new Object[]{OPERATION_NO_FILES_READY, OPERATION_FILE_END, OPERATION_NONE, ""}, null, true);
            getterMap_.add(AUTOMATICALLY_END_WRITER, RPTA0100_, "receiverVariable.automaticallyEndWriter");
            attributes_.add((Object)BETWEEN_COPIES_STATUS, Boolean.class, true);
            getterMap_.add((Object)BETWEEN_COPIES_STATUS, RPTA0100_, "receiverVariable.betweenCopiesStatus", booleanValueMapNY_);
            attributes_.add((Object)BETWEEN_FILES_STATUS, Boolean.class, true);
            getterMap_.add((Object)BETWEEN_FILES_STATUS, RPTA0100_, "receiverVariable.betweenFilesStatus", booleanValueMapNY_);
            attributes_.add(CHANGES_TAKE_EFFECT, String.class, false, new Object[]{OPERATION_NO_FILES_READY, OPERATION_FILE_END, ""}, null, true);
            getterMap_.add(CHANGES_TAKE_EFFECT, RPTA0100_, "receiverVariable.changesTakeEffect");
            setterMap_.add(CHANGES_TAKE_EFFECT, CHGWTR_, "OPTION");
            attributes_.add((Object)COPIES_LEFT_TO_PRODUCE, Integer.class, true);
            getterMap_.add(COPIES_LEFT_TO_PRODUCE, RPTA0100_, "receiverVariable.copiesLeftToProduce");
            attributes_.add((Object)DEVICE_NAME, String.class, true);
            getterMap_.add(DEVICE_NAME, RPTA0100_, "receiverVariable.deviceName");
            attributes_.add((Object)DEVICE_STATUS, Integer.class, true);
            getterMap_.add(DEVICE_STATUS, RPTA0100_, "receiverVariable.deviceStatus");
            attributes_.add((Object)DEVICE_TYPE, String.class, true);
            getterMap_.add(DEVICE_TYPE, RPTA0100_, "receiverVariable.printerDeviceType");
            attributes_.add(END_PENDING_STATUS, String.class, true, new Object[]{"N", PENDING_STATUS_IMMEDIATE, PENDING_STATUS_CONTROLLED, PENDING_STATUS_PAGE_END, ""}, null, true);
            getterMap_.add(END_PENDING_STATUS, RPTA0100_, "receiverVariable.endPendingStatus");
            attributes_.add(FORM_TYPE, String.class, false, new Object[]{FORM_TYPE_ALL, FORM_TYPE_FORMS, FORM_TYPE_STANDARD}, null, false);
            getterMap_.add(FORM_TYPE, RPTA0100_, "receiverVariable.formType");
            setterMap_.add(FORM_TYPE, CHGWTR_, "FORMTYPE", quoteValueMapEmpty_);
            attributes_.add((Object)HELD_STATUS, Boolean.class, true);
            getterMap_.add((Object)HELD_STATUS, RPTA0100_, "receiverVariable.heldStatus", booleanValueMapNY_);
            attributes_.add(HOLD_PENDING_STATUS, String.class, true, new Object[]{"N", PENDING_STATUS_IMMEDIATE, PENDING_STATUS_CONTROLLED, PENDING_STATUS_PAGE_END, ""}, null, true);
            getterMap_.add(HOLD_PENDING_STATUS, RPTA0100_, "receiverVariable.holdPendingStatus");
            attributes_.add((Object)JOB_NAME, String.class, true);
            getterMap_.add(JOB_NAME, RPTA0100_, "receiverVariable.jobName");
            attributes_.add((Object)JOB_NUMBER, String.class, true);
            getterMap_.add(JOB_NUMBER, RPTA0100_, "receiverVariable.jobNumber");
            attributes_.add((Object)JOB_QUEUE_STATUS, Boolean.class, true);
            getterMap_.add((Object)JOB_QUEUE_STATUS, RPTA0100_, "receiverVariable.onJobQueueStatus", booleanValueMapNY_);
            attributes_.add((Object)MESSAGE_KEY, byte[].class, true);
            getterMap_.add(MESSAGE_KEY, RPTA0100_, "receiverVariable.messageKey");
            attributes_.add(MESSAGE_OPTION, String.class, true, new Object[]{MESSAGE_OPTION_MESSAGE, MESSAGE_OPTION_NO_MESSAGE, MESSAGE_OPTION_INFORMATIONAL_MESSAGE, MESSAGE_OPTION_INQUIRY_MESSAGE, ""}, null, true);
            getterMap_.add(MESSAGE_OPTION, RPTA0100_, "receiverVariable.messageOption");
            attributes_.add((Object)MESSAGE_QUEUE, String.class, true);
            getterMap_.add((Object)MESSAGE_QUEUE, RPTA0100_, "receiverVariable.messageQueue", new QualifiedValueMap(20, "MSGQ"));
            attributes_.add(NEXT_FILE_SEPARATORS, Integer.class, true, new Object[]{SEPARATOR_PAGE_FILE, SEPARATOR_PAGE_NONE}, null, false);
            getterMap_.add(NEXT_FILE_SEPARATORS, RPTA0100_, "receiverVariable.nextFileSeparators");
            attributes_.add(NEXT_FORM_TYPE, String.class, true, new Object[]{FORM_TYPE_ALL, FORM_TYPE_FORMS, FORM_TYPE_STANDARD}, null, false);
            getterMap_.add(NEXT_FORM_TYPE, RPTA0100_, "receiverVariable.nextFormType");
            attributes_.add(NEXT_MESSAGE_OPTION, String.class, true, new Object[]{MESSAGE_OPTION_MESSAGE, MESSAGE_OPTION_NO_MESSAGE, MESSAGE_OPTION_INFORMATIONAL_MESSAGE, MESSAGE_OPTION_INQUIRY_MESSAGE, ""}, null, true);
            getterMap_.add(NEXT_MESSAGE_OPTION, RPTA0100_, "receiverVariable.nextMessageOption");
            attributes_.add((Object)NEXT_OUTPUT_QUEUE, String.class, true);
            getterMap_.add((Object)NEXT_OUTPUT_QUEUE, RPTA0100_, "receiverVariable.nextOutputQueue", new QualifiedValueMap(20, "OUTQ"));
            attributes_.add(NEXT_SEPARATOR_DRAWER, Integer.class, true, new Object[]{SEPARATOR_PAGE_FILE, SEPARATOR_PAGE_DEVICE, SEPARATOR_PAGE_NONE}, null, false);
            getterMap_.add(NEXT_SEPARATOR_DRAWER, RPTA0100_, "receiverVariable.nextSeparatorDrawer");
            attributes_.add(NUMBER_OF_SEPARATORS, Integer.class, false, new Object[]{SEPARATOR_PAGE_FILE}, null, false);
            getterMap_.add(NUMBER_OF_SEPARATORS, RPTA0100_, "receiverVariable.numberOfSeparators");
            setterMap_.add(NUMBER_OF_SEPARATORS, CHGWTR_, "FILESEP", separatorValueMap_);
            attributes_.add((Object)OUTPUT_QUEUE, String.class, false);
            getterMap_.add((Object)OUTPUT_QUEUE, RPTA0100_, "receiverVariable.outputQueue", new QualifiedValueMap(20, "OUTQ"));
            setterMap_.add(OUTPUT_QUEUE, CHGWTR_, "OUTQ", new QualifiedValueMap(13, "OUTQ"));
            attributes_.add(OUTPUT_QUEUE_STATUS, String.class, true, new Object[]{STATUS_HELD, STATUS_RELEASED, ""}, null, true);
            getterMap_.add(OUTPUT_QUEUE_STATUS, RPTA0100_, "receiverVariable.outputQueueStatus");
            attributes_.add((Object)OVERALL_STATUS, Integer.class, true);
            getterMap_.add(OVERALL_STATUS, RPTA0100_, "receiverVariable.overallStatus");
            attributes_.add((Object)PAGE_BEING_WRITTEN, Integer.class, true);
            getterMap_.add(PAGE_BEING_WRITTEN, RPTA0100_, "receiverVariable.pageBeingWritten");
            ResourceLevel level = new ResourceLevel("V5R1M0");
            ResourceMetaData rmd = attributes_.add((Object)PUBLISHED_STATUS, Boolean.class, true);
            rmd.setLevel(level);
            getterMap_.add((Object)PUBLISHED_STATUS, RPTA0100_, "receiverVariable.waitingForDataStatus", booleanValueMapNY_, level);
            attributes_.add(SEPARATOR_DRAWER, Integer.class, false, new Object[]{SEPARATOR_PAGE_FILE, SEPARATOR_PAGE_DEVICE}, null, false);
            getterMap_.add(SEPARATOR_DRAWER, RPTA0100_, "receiverVariable.drawerForSeparators");
            setterMap_.add(SEPARATOR_DRAWER, CHGWTR_, "SEPDRAWER", separatorValueMap_);
            attributes_.add((Object)SPOOLED_FILE_NAME, String.class, true);
            getterMap_.add(SPOOLED_FILE_NAME, RPTA0100_, "receiverVariable.spooledFileName");
            attributes_.add((Object)SPOOLED_FILE_NUMBER, Integer.class, true);
            getterMap_.add(SPOOLED_FILE_NUMBER, RPTA0100_, "receiverVariable.spooledFileNumber");
            attributes_.add((Object)STARTED_BY_USER, String.class, true);
            getterMap_.add(STARTED_BY_USER, RPTA0100_, "receiverVariable.startedByUser");
            attributes_.add((Object)TEXT_DESCRIPTION, String.class, false);
            getterMap_.add(TEXT_DESCRIPTION, RPTA0100_, "receiverVariable.textDescription");
            setterMap_.add(TEXT_DESCRIPTION, CHGDEVPRT_, "TEXT", quoteValueMapBlank_);
            attributes_.add((Object)TOTAL_COPIES, Integer.class, true);
            getterMap_.add(TOTAL_COPIES, RPTA0100_, "receiverVariable.totalCopies");
            attributes_.add((Object)TOTAL_PAGES, Integer.class, true);
            getterMap_.add(TOTAL_PAGES, RPTA0100_, "receiverVariable.totalPages");
            attributes_.add((Object)USER_NAME, String.class, true);
            getterMap_.add(USER_NAME, RPTA0100_, "receiverVariable.userName");
            attributes_.add((Object)WAITING_FOR_DATA_STATUS, Boolean.class, true);
            getterMap_.add((Object)WAITING_FOR_DATA_STATUS, RPTA0100_, "receiverVariable.waitingForDataStatus", booleanValueMapNY_);
            attributes_.add((Object)WAITING_FOR_DEVICE_STATUS, Boolean.class, true);
            getterMap_.add((Object)WAITING_FOR_DEVICE_STATUS, RPTA0100_, "receiverVariable.waitingForDeviceStatus", booleanValueMapNY_);
            attributes_.add((Object)WAITING_FOR_MESSAGE_STATUS, Boolean.class, true);
            getterMap_.add((Object)WAITING_FOR_MESSAGE_STATUS, RPTA0100_, "receiverVariable.waitingForMessageStatus", booleanValueMapNY_);
            attributes_.add((Object)WRITER_JOB_NAME, String.class, true);
            getterMap_.add(WRITER_JOB_NAME, RPTA0100_, "receiverVariable.writerJobName");
            attributes_.add((Object)WRITER_JOB_NUMBER, String.class, true);
            getterMap_.add(WRITER_JOB_NUMBER, RPTA0100_, "receiverVariable.writerJobNumber");
            attributes_.add((Object)WRITER_JOB_USER_NAME, String.class, true);
            getterMap_.add(WRITER_JOB_USER_NAME, RPTA0100_, "receiverVariable.writerJobUserName");
            attributes_.add((Object)WRITER_STARTED, Boolean.class, true);
            getterMap_.add((Object)WRITER_STARTED, RPTA0100_, "receiverVariable.writerStarted", booleanValueMap01_);
            WRITER_STATUS_STARTED = new byte[]{1};
            WRITER_STATUS_ENDED = new byte[]{2};
            WRITER_STATUS_JOB_QUEUE = new byte[]{3};
            WRITER_STATUS_HELD = new byte[]{4};
            WRITER_STATUS_MESSAGE_WAITING = new byte[]{5};
            attributes_.add(WRITER_STATUS, byte[].class, true, new Object[]{WRITER_STATUS_STARTED, WRITER_STATUS_ENDED, WRITER_STATUS_JOB_QUEUE, WRITER_STATUS_HELD, WRITER_STATUS_MESSAGE_WAITING}, null, true);
            getterMap_.add(WRITER_STATUS, RPTA0100_, "receiverVariable.writerStatus");
            attributes_.add(WRITING_STATUS, String.class, true, new Object[]{WRITING_STATUS_YES, "N", WRITING_STATUS_SEPARATORS, ""}, null, true);
            getterMap_.add(WRITING_STATUS, RPTA0100_, "receiverVariable.writingStatus");
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException e) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)e);
            }
        }
    }
}

