/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PanelGroupHelpIdentifier;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class PanelGroup
implements Serializable {
    static final long serialVersionUID = 6L;
    private AS400 system_;
    private String path_;
    private transient PropertyChangeSupport propertyChangeListeners_ = new PropertyChangeSupport(this);

    public PanelGroup() {
        this.initializeTransient();
    }

    public PanelGroup(AS400 system, String path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName.validatePath(path, "PNLGRP");
        this.system_ = system;
        this.path_ = path;
        this.initializeTransient();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeListeners_.addPropertyChangeListener(listener);
    }

    public synchronized PanelGroupHelpIdentifier[] getHelpIdentifiers(String[] keywords) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        int bytesAvailable;
        if (keywords == null) {
            throw new NullPointerException("keywords");
        }
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.path_ == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving help identifiers for " + keywords.length + " keywords: ");
            for (int i = 0; i < keywords.length; ++i) {
                Trace.log(1, keywords[i]);
            }
        }
        CharConverter conv = new CharConverter(this.system_.getCcsid());
        int numHelpIDs = keywords.length;
        int outputLength = 28 + 200 * numHelpIDs;
        int docLength = 8192;
        ProgramParameter[] parms = new ProgramParameter[8];
        parms[0] = new ProgramParameter(outputLength);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(outputLength));
        parms[2] = new ProgramParameter(conv.stringToByteArray("RHLP0100"));
        byte[] helpIDData = new byte[numHelpIDs * 80];
        int offset = 0;
        AS400Text text32 = new AS400Text(32, this.system_.getCcsid());
        AS400Text text10 = new AS400Text(10, this.system_.getCcsid());
        QSYSObjectPathName p = new QSYSObjectPathName(this.path_);
        byte[] panelGroupName = text10.toBytes(p.getObjectName().toUpperCase().trim());
        byte[] panelGroupLibrary = text10.toBytes(p.getLibraryName().toUpperCase().trim());
        byte[] objectType = text10.toBytes("*PNLGRP");
        byte[] reserved = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        for (int i = 0; i < numHelpIDs; ++i) {
            text32.toBytes(keywords[i], helpIDData, offset);
            System.arraycopy(panelGroupName, 0, helpIDData, offset += 32, 10);
            System.arraycopy(panelGroupLibrary, 0, helpIDData, offset += 10, 10);
            System.arraycopy(objectType, 0, helpIDData, offset += 10, 10);
            System.arraycopy(reserved, 0, helpIDData, offset += 10, 18);
            offset += 18;
        }
        parms[3] = new ProgramParameter(helpIDData);
        parms[4] = new ProgramParameter(BinaryConverter.intToByteArray(numHelpIDs));
        parms[5] = new ProgramParameter(docLength);
        parms[6] = new ProgramParameter(BinaryConverter.intToByteArray(docLength));
        parms[7] = new ProgramParameter(4);
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QUHRHLPT.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] outputData = parms[0].getOutputData();
        int bytesReturned = BinaryConverter.byteArrayToInt(outputData, 0);
        if (bytesReturned < (bytesAvailable = BinaryConverter.byteArrayToInt(outputData, 4))) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "Performing secondary program call to retrieve help identifiers.");
                }
                parms[0].setOutputDataLength(bytesAvailable + 8);
                parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(bytesAvailable + 8));
                if (!pc.run()) {
                    throw new AS400Exception(pc.getMessageList());
                }
                outputData = parms[0].getOutputData();
            }
            catch (PropertyVetoException pve) {
                Trace.log(2, pve);
            }
        }
        offset = BinaryConverter.byteArrayToInt(outputData, 16);
        int numEntries = BinaryConverter.byteArrayToInt(outputData, 20);
        int entrySize = BinaryConverter.byteArrayToInt(outputData, 24);
        PanelGroupHelpIdentifier[] ids = new PanelGroupHelpIdentifier[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            String helpIDName = conv.byteArrayToString(outputData, offset, 32).trim();
            String objName = conv.byteArrayToString(outputData, offset + 32, 10).trim();
            String objLib = conv.byteArrayToString(outputData, offset + 42, 10).trim();
            String objType = conv.byteArrayToString(outputData, offset + 52, 10).trim();
            if (objType.startsWith("*")) {
                objType = objType.substring(1);
            }
            String helpIDFound = conv.byteArrayToString(outputData, offset + 62, 1);
            String helpIDAnchor = conv.byteArrayToString(outputData, offset + 63, 96).trim();
            ids[i] = new PanelGroupHelpIdentifier(helpIDName, objName, objLib, objType, helpIDFound, helpIDAnchor);
            offset += entrySize;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Successfully retrieved help identifiers.");
        }
        return ids;
    }

    public synchronized String getHelpText(String[] keywords) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        String helpText;
        if (keywords == null) {
            throw new NullPointerException("keywords");
        }
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.path_ == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving help text for " + keywords.length + " keywords: ");
            for (int i = 0; i < keywords.length; ++i) {
                Trace.log(1, keywords[i]);
            }
        }
        CharConverter conv = new CharConverter(this.system_.getCcsid());
        int numHelpIDs = keywords.length;
        int outputLength = 32 + 192 * numHelpIDs;
        int docLength = 8192;
        ProgramParameter[] parms = new ProgramParameter[8];
        parms[0] = new ProgramParameter(outputLength);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(outputLength));
        parms[2] = new ProgramParameter(conv.stringToByteArray("RHLP0100"));
        byte[] helpIDData = new byte[numHelpIDs * 80];
        int offset = 0;
        AS400Text text32 = new AS400Text(32, this.system_.getCcsid());
        AS400Text text10 = new AS400Text(10, this.system_.getCcsid());
        QSYSObjectPathName p = new QSYSObjectPathName(this.path_);
        byte[] panelGroupName = text10.toBytes(p.getObjectName().toUpperCase().trim());
        byte[] panelGroupLibrary = text10.toBytes(p.getLibraryName().toUpperCase().trim());
        byte[] objectType = text10.toBytes("*PNLGRP");
        byte[] reserved = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        for (int i = 0; i < numHelpIDs; ++i) {
            text32.toBytes(keywords[i], helpIDData, offset);
            System.arraycopy(panelGroupName, 0, helpIDData, offset += 32, 10);
            System.arraycopy(panelGroupLibrary, 0, helpIDData, offset += 10, 10);
            System.arraycopy(objectType, 0, helpIDData, offset += 10, 10);
            System.arraycopy(reserved, 0, helpIDData, offset += 10, 18);
            offset += 18;
        }
        parms[3] = new ProgramParameter(helpIDData);
        parms[4] = new ProgramParameter(BinaryConverter.intToByteArray(numHelpIDs));
        parms[5] = new ProgramParameter(docLength);
        parms[6] = new ProgramParameter(BinaryConverter.intToByteArray(docLength));
        parms[7] = new ProgramParameter(4);
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QUHRHLPT.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] outputData = parms[0].getOutputData();
        byte[] docData = parms[5].getOutputData();
        int bytesReturned = BinaryConverter.byteArrayToInt(outputData, 0);
        int bytesAvailable = BinaryConverter.byteArrayToInt(outputData, 4);
        int docBytesReturned = BinaryConverter.byteArrayToInt(docData, 0);
        int docBytesAvailable = BinaryConverter.byteArrayToInt(docData, 4);
        if (bytesReturned < bytesAvailable || docBytesReturned < docBytesAvailable) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "Performing secondary program call to retrieve help text.");
                }
                parms[0].setOutputDataLength(bytesAvailable + 8);
                parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(bytesAvailable + 8));
                parms[5].setOutputDataLength(docBytesAvailable + 8);
                parms[6] = new ProgramParameter(BinaryConverter.intToByteArray(docBytesAvailable + 8));
                if (!pc.run()) {
                    throw new AS400Exception(pc.getMessageList());
                }
                docData = parms[5].getOutputData();
                docBytesReturned = BinaryConverter.byteArrayToInt(docData, 0);
            }
            catch (PropertyVetoException pve) {
                Trace.log(2, pve);
            }
        }
        ConvTable conv1208 = ConvTable.getTable(1208, null);
        String string = helpText = docBytesReturned <= 8 ? "" : conv1208.byteArrayToString(docData, 8, docBytesReturned - 8, 0);
        if (Trace.traceOn_) {
            Trace.log(1, "Successfully retrieved help text.");
        }
        return helpText;
    }

    public String getPath() {
        return this.path_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    private void initializeTransient() {
        this.propertyChangeListeners_ = new PropertyChangeSupport(this);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeListeners_.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        PanelGroup panelGroup = this;
        synchronized (panelGroup) {
            QSYSObjectPathName.validatePath(path, "PNLGRP");
            String old = this.path_;
            this.path_ = path;
            this.propertyChangeListeners_.firePropertyChange("path", old, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        PanelGroup panelGroup = this;
        synchronized (panelGroup) {
            AS400 old = this.system_;
            this.system_ = system;
            this.propertyChangeListeners_.firePropertyChange("system", old, system);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.path_ + "]";
    }
}

