/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.NPAttributeIFS;
import com.ibm.as400.access.Trace;
import java.io.Serializable;

abstract class NPAttribute
implements Cloneable,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int TWO_BYTE = 1;
    static final int TWO_BYTE_ENU = 2;
    static final int FOUR_BYTE = 3;
    static final int FOUR_BYTE_ENU = 4;
    static final int STRING = 5;
    static final int STRING_ENU = 6;
    static final int FLOAT = 7;
    static final int PACKED_DEC = 7;
    static final int BINARY = 8;
    static final int LISTSTRING = 9;
    private int attrID_;
    private int attrType_;
    private byte[] hostData_;

    private NPAttribute() {
    }

    NPAttribute(NPAttribute attr) {
        this.attrID_ = attr.attrID_;
        this.attrType_ = attr.attrType_;
        if (attr.hostData_ != null) {
            this.hostData_ = new byte[attr.hostData_.length];
            System.arraycopy(attr.hostData_, 0, this.hostData_, 0, this.hostData_.length);
        }
    }

    NPAttribute(int ID, int type) {
        this.attrID_ = ID;
        this.setType(type);
    }

    NPAttribute(int ID, int type, byte[] hostDataStream, int offset, int length, ConverterImpl hostConverter) {
        this.attrID_ = ID;
        this.setType(type);
        this.hostData_ = new byte[length];
        System.arraycopy(hostDataStream, offset, this.hostData_, 0, length);
    }

    protected Object clone() throws CloneNotSupportedException {
        Trace.log(2, "Clone method must be implemented in " + this.getClass().getName());
        throw new CloneNotSupportedException(this.getClass().getName());
    }

    byte[] getHostData(ConverterImpl converter) {
        return this.hostData_;
    }

    int getHostLength(ConverterImpl converter) {
        int i = 0;
        if (this.hostData_ != null) {
            i = this.hostData_.length;
        }
        return i;
    }

    int getID() {
        return this.attrID_;
    }

    int getType() {
        return this.attrType_;
    }

    public int hashCode() {
        return this.attrID_;
    }

    static boolean idIsValid(int ID) {
        boolean fRC = true;
        if (ID == 0 || ID > 335) {
            fRC = false;
        } else if (ID < 0 && (ID = Math.abs(ID) - 1) >= NPAttributeIFS.ifsAttrs.length) {
            fRC = false;
        }
        return fRC;
    }

    void setHostData(byte[] data, ConverterImpl converter) {
        this.hostData_ = new byte[data.length];
        System.arraycopy(data, 0, this.hostData_, 0, data.length);
    }

    void setType(int newType) {
        this.attrType_ = newType;
    }
}

