/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.NativeException;
import com.ibm.as400.access.NativeMethods;
import com.ibm.as400.access.SignonConverter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UnixSocketUser;
import java.io.IOException;

class CurrentUser {
    CurrentUser() {
    }

    static String getUserID(int vrm) {
        byte[] currentUser = null;
        try {
            if (vrm >= 328704) {
                currentUser = NativeMethods.getUserId();
            } else if (vrm >= 328192) {
                if (NativeMethods.loadSCK()) {
                    currentUser = CurrentUser.getUserIdNative();
                }
            } else {
                UnixSocketUser user = new UnixSocketUser();
                currentUser = user.getUserId();
            }
        }
        catch (NativeException e) {
            Trace.log(2, "Error retrieving current userID:", (Throwable)e);
        }
        catch (Throwable e) {
            Trace.log(2, "Error retrieving current userID:", e);
        }
        if (currentUser != null) {
            try {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Current userID in EBCDIC: ", currentUser);
                }
                String userID = SignonConverter.byteArrayToString(currentUser);
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Current userID: '" + userID + "'");
                }
                return userID;
            }
            catch (AS400SecurityException e) {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Current userID convert failed, user id characters are not valid");
                }
                return null;
            }
        }
        return null;
    }

    static byte[] getUserInfo(int vrm, byte[] clientSeed, byte[] serverSeed, String info) throws AS400SecurityException, IOException {
        try {
            if (vrm >= 328704) {
                return NativeMethods.getUserInfo(clientSeed, serverSeed);
            }
            if (vrm >= 328192) {
                return CurrentUser.getUserInfoNative(clientSeed, serverSeed);
            }
            UnixSocketUser user = new UnixSocketUser();
            return user.getSubstitutePassword(clientSeed, serverSeed);
        }
        catch (NativeException e) {
            throw AS400ImplRemote.returnSecurityException(BinaryConverter.byteArrayToInt(e.data, 0), null, info);
        }
    }

    private static native byte[] getUserIdNative() throws NativeException;

    private static native byte[] getUserInfoNative(byte[] var0, byte[] var1) throws NativeException;
}

