/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.gaxx.retrying;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.RetryingContext;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.ServerStreamingAttemptException;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.bigtable.gaxx.retrying.ServerStreamingAttemptCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;

@InternalApi
public final class RetryingServerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> innerCallable;
    private final ScheduledRetryingExecutor<Void> executor;
    private final StreamResumptionStrategy<RequestT, ResponseT> resumptionStrategyPrototype;

    public RetryingServerStreamingCallable(ServerStreamingCallable<RequestT, ResponseT> innerCallable, ScheduledRetryingExecutor<Void> executor, StreamResumptionStrategy<RequestT, ResponseT> resumptionStrategyPrototype) {
        this.innerCallable = innerCallable;
        this.executor = executor;
        this.resumptionStrategyPrototype = resumptionStrategyPrototype;
    }

    public void call(RequestT request, final ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        ServerStreamingAttemptCallable<RequestT, ResponseT> attemptCallable = new ServerStreamingAttemptCallable<RequestT, ResponseT>(this.innerCallable, this.resumptionStrategyPrototype.createNew(), request, context, responseObserver);
        RetryingFuture retryingFuture = this.executor.createFuture(attemptCallable, (RetryingContext)context);
        attemptCallable.setExternalFuture((RetryingFuture<Void>)retryingFuture);
        attemptCallable.start();
        ApiFutures.addCallback((ApiFuture)retryingFuture, (ApiFutureCallback)new ApiFutureCallback<Void>(){

            public void onFailure(Throwable throwable) {
                if (throwable instanceof ServerStreamingAttemptException) {
                    throwable = throwable.getCause();
                }
                responseObserver.onError(throwable);
            }

            public void onSuccess(Void ignored) {
                responseObserver.onComplete();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

