/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public abstract class SafeResponseObserver<ResponseT>
implements ResponseObserver<ResponseT> {
    private static final Logger LOGGER = Logger.getLogger(SafeResponseObserver.class.getName());
    private AtomicBoolean isStarted = new AtomicBoolean(false);
    private AtomicBoolean isClosed = new AtomicBoolean(false);
    private StreamController streamController;
    private ResponseObserver outerObserver;

    public SafeResponseObserver(ResponseObserver outerObserver) {
        this.outerObserver = outerObserver;
    }

    public final void onStart(StreamController streamController) {
        if (!this.isStarted.compareAndSet(false, true)) {
            throw new IllegalStateException("A stream is already started");
        }
        this.streamController = streamController;
        try {
            this.onStartImpl(streamController);
        }
        catch (Throwable t) {
            if (!this.isClosed.compareAndSet(false, true)) {
                this.logException("Tried to cancel a closed stream");
                return;
            }
            streamController.cancel();
            this.outerObserver.onError(t);
        }
    }

    public final void onResponse(ResponseT response) {
        if (this.isClosed.get()) {
            this.logException("Received a response after the stream is closed");
            return;
        }
        try {
            this.onResponseImpl(response);
        }
        catch (Throwable t1) {
            try {
                if (!this.isClosed.compareAndSet(false, true)) {
                    this.logException("Tried to cancel a closed stream");
                    return;
                }
                this.streamController.cancel();
            }
            catch (Throwable t2) {
                t1.addSuppressed(t2);
            }
            this.outerObserver.onError(t1);
        }
    }

    public final void onError(Throwable throwable) {
        if (!this.isClosed.compareAndSet(false, true)) {
            this.logException("Received error after the stream is closed");
            return;
        }
        try {
            this.onErrorImpl(throwable);
        }
        catch (Throwable t) {
            throwable.addSuppressed(t);
            this.outerObserver.onError(throwable);
        }
    }

    public final void onComplete() {
        if (!this.isClosed.compareAndSet(false, true)) {
            this.logException("Tried to double close the stream");
            return;
        }
        try {
            this.onCompleteImpl();
        }
        catch (Throwable t) {
            this.outerObserver.onError(t);
        }
    }

    private void logException(String message) {
        LOGGER.log(Level.WARNING, message, new IllegalStateException(message));
    }

    protected abstract void onStartImpl(StreamController var1);

    protected abstract void onResponseImpl(ResponseT var1);

    protected abstract void onErrorImpl(Throwable var1);

    protected abstract void onCompleteImpl();
}

