/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.multimerge;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.multimerge.MultiMergeJoinData;
import org.apache.hop.pipeline.transforms.multimerge.MultiMergeJoinMeta;

public class MultiMergeJoin
extends BaseTransform<MultiMergeJoinMeta, MultiMergeJoinData> {
    private static final Class<?> PKG = MultiMergeJoinMeta.class;
    public static final String CONST_MULTI_MERGE_JOIN_LOG_UNABLE_TO_FIND_REFERENCE_STREAM = "MultiMergeJoin.Log.UnableToFindReferenceStream";

    public MultiMergeJoin(TransformMeta transformMeta, MultiMergeJoinMeta meta, MultiMergeJoinData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private boolean processFirstRow(MultiMergeJoinMeta smi, MultiMergeJoinData sdi) throws HopException {
        String inputTransformName;
        ITransformIOMeta transformIOMeta = ((MultiMergeJoinMeta)this.meta).getTransformIOMeta();
        List infoStreams = transformIOMeta.getInfoStreams();
        TransformMeta toTransformMeta = ((MultiMergeJoinMeta)this.meta).getParentTransformMeta();
        ArrayList<String> inputTransformNameList = new ArrayList<String>();
        String[] inputTransformNames = ((MultiMergeJoinMeta)this.meta).getInputTransforms();
        for (int i = 0; i < infoStreams.size(); ++i) {
            inputTransformName = inputTransformNames[i];
            IStream stream = (IStream)infoStreams.get(i);
            TransformMeta fromTransformMeta = stream.getTransformMeta();
            if (fromTransformMeta == null) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_MULTI_MERGE_JOIN_LOG_UNABLE_TO_FIND_REFERENCE_STREAM, (String[])new String[]{inputTransformName}));
            }
            PipelineHopMeta pipelineHopMeta = this.getPipelineMeta().findPipelineHop(fromTransformMeta, toTransformMeta, true);
            if (pipelineHopMeta == null) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_MULTI_MERGE_JOIN_LOG_UNABLE_TO_FIND_REFERENCE_STREAM, (String[])new String[]{inputTransformName}));
            }
            if (pipelineHopMeta.isEnabled()) {
                inputTransformNameList.add(inputTransformName);
                continue;
            }
            this.logDetailed(BaseMessages.getString(PKG, (String)"MultiMergeJoin.Log.IgnoringTransform", (String[])new String[]{inputTransformName}));
        }
        int streamSize = inputTransformNameList.size();
        if (streamSize == 0) {
            return false;
        }
        ((MultiMergeJoinData)this.data).rowSets = new IRowSet[streamSize];
        ((MultiMergeJoinData)this.data).rows = new Object[streamSize][];
        ((MultiMergeJoinData)this.data).metas = new IRowMeta[streamSize];
        ((MultiMergeJoinData)this.data).rowLengths = new int[streamSize];
        MultiMergeJoinData.QueueComparator comparator = new MultiMergeJoinData.QueueComparator((MultiMergeJoinData)this.data);
        ((MultiMergeJoinData)this.data).queue = new PriorityQueue<MultiMergeJoinData.QueueEntry>(streamSize, comparator);
        ((MultiMergeJoinData)this.data).results = new ArrayList<List<Object[]>>(streamSize);
        ((MultiMergeJoinData)this.data).queueEntries = new MultiMergeJoinData.QueueEntry[streamSize];
        ((MultiMergeJoinData)this.data).drainIndices = new int[streamSize];
        ((MultiMergeJoinData)this.data).keyNrs = new int[streamSize][];
        ((MultiMergeJoinData)this.data).dummy = new Object[streamSize][];
        ((MultiMergeJoinData)this.data).outputRowMeta = new RowMeta();
        int j = 0;
        for (int i = 0; i < inputTransformNames.length; ++i) {
            IRowMeta rowMeta;
            inputTransformName = inputTransformNames[i];
            if (!inputTransformNameList.contains(inputTransformName)) continue;
            MultiMergeJoinData.QueueEntry queueEntry = new MultiMergeJoinData.QueueEntry();
            queueEntry.index = j;
            ((MultiMergeJoinData)this.data).queueEntries[j] = queueEntry;
            ((MultiMergeJoinData)this.data).results.add(new ArrayList());
            IRowSet rowSet = this.findInputRowSet(inputTransformName);
            if (rowSet == null) {
                throw new HopException(BaseMessages.getString(PKG, (String)"MultiMergeJoin.Exception.UnableToFindSpecifiedTransform", (String[])new String[]{inputTransformName}));
            }
            ((MultiMergeJoinData)this.data).rowSets[j] = rowSet;
            Object[] row = this.getRowFrom(rowSet);
            ((MultiMergeJoinData)this.data).rows[j] = row;
            if (row == null) {
                ((MultiMergeJoinData)this.data).metas[j] = rowMeta = this.getPipelineMeta().getTransformFields((IVariables)this, inputTransformName);
            } else {
                queueEntry.row = row;
                rowMeta = rowSet.getRowMeta();
                String keyField = ((MultiMergeJoinMeta)this.meta).getKeyFields()[i];
                String[] keyFieldParts = keyField.split(",");
                ((MultiMergeJoinData)this.data).keyNrs[j] = new int[keyFieldParts.length];
                for (int k = 0; k < keyFieldParts.length; ++k) {
                    String keyFieldPart = keyFieldParts[k];
                    ((MultiMergeJoinData)this.data).keyNrs[j][k] = rowMeta.indexOfValue(keyFieldPart);
                    if (((MultiMergeJoinData)this.data).keyNrs[j][k] >= 0) continue;
                    String message = BaseMessages.getString(PKG, (String)"MultiMergeJoin.Exception.UnableToFindFieldInReferenceStream", (String[])new String[]{keyFieldPart, inputTransformName});
                    this.logError(message);
                    throw new HopTransformException(message);
                }
                ((MultiMergeJoinData)this.data).metas[j] = rowMeta;
                ((MultiMergeJoinData)this.data).queue.add(((MultiMergeJoinData)this.data).queueEntries[j]);
            }
            ((MultiMergeJoinData)this.data).outputRowMeta.mergeRowMeta(rowMeta.clone());
            ((MultiMergeJoinData)this.data).rowLengths[j] = rowMeta.size();
            ((MultiMergeJoinData)this.data).dummy[j] = RowDataUtil.allocateRowData((int)rowMeta.size());
            ++j;
        }
        return true;
    }

    public boolean processRow() throws HopException {
        int i;
        if (this.first) {
            if (!this.processFirstRow((MultiMergeJoinMeta)this.meta, (MultiMergeJoinData)this.data)) {
                this.setOutputDone();
                return false;
            }
            this.first = false;
        }
        if (this.isRowLevel()) {
            Object metaString = BaseMessages.getString(PKG, (String)"MultiMergeJoin.Log.DataInfo", (String[])new String[]{((MultiMergeJoinData)this.data).metas[0].getString(((MultiMergeJoinData)this.data).rows[0])});
            for (i = 1; i < ((MultiMergeJoinData)this.data).metas.length; ++i) {
                metaString = (String)metaString + ((MultiMergeJoinData)this.data).metas[i].getString(((MultiMergeJoinData)this.data).rows[i]);
            }
            this.logRowlevel((String)metaString);
        }
        int streamSize = ((MultiMergeJoinData)this.data).metas.length;
        if (((MultiMergeJoinData)this.data).optional) {
            int i2;
            int i3;
            if (((MultiMergeJoinData)this.data).queue.isEmpty()) {
                this.setOutputDone();
                return false;
            }
            MultiMergeJoinData.QueueEntry minEntry = ((MultiMergeJoinData)this.data).queue.poll();
            int drainSize = 1;
            ((MultiMergeJoinData)this.data).rows[minEntry.index] = minEntry.row;
            ((MultiMergeJoinData)this.data).drainIndices[0] = minEntry.index;
            MultiMergeJoinData.QueueComparator comparator = (MultiMergeJoinData.QueueComparator)((MultiMergeJoinData)this.data).queue.comparator();
            while (!((MultiMergeJoinData)this.data).queue.isEmpty() && comparator.compare(((MultiMergeJoinData)this.data).queue.peek(), minEntry) == 0) {
                MultiMergeJoinData.QueueEntry entry = ((MultiMergeJoinData)this.data).queue.poll();
                ((MultiMergeJoinData)this.data).rows[entry.index] = entry.row;
                ((MultiMergeJoinData)this.data).drainIndices[drainSize++] = entry.index;
            }
            Object[] row = null;
            for (i3 = 0; i3 < drainSize; ++i3) {
                int index = ((MultiMergeJoinData)this.data).drainIndices[i3];
                ((MultiMergeJoinData)this.data).results.get(index).add(((MultiMergeJoinData)this.data).rows[index]);
                while (!this.isStopped() && (row = this.getRowFrom(((MultiMergeJoinData)this.data).rowSets[index])) != null && ((MultiMergeJoinData)this.data).metas[index].compare(((MultiMergeJoinData)this.data).rows[index], row, ((MultiMergeJoinData)this.data).keyNrs[index]) == 0) {
                    ((MultiMergeJoinData)this.data).results.get(index).add(row);
                }
                if (this.isStopped()) {
                    return false;
                }
                if (row == null) continue;
                ((MultiMergeJoinData)this.data).queueEntries[index].row = row;
                ((MultiMergeJoinData)this.data).queue.add(((MultiMergeJoinData)this.data).queueEntries[index]);
            }
            for (i3 = 0; i3 < streamSize; ++i3) {
                ((MultiMergeJoinData)this.data).drainIndices[i3] = 0;
                if (!((MultiMergeJoinData)this.data).results.get(i3).isEmpty()) continue;
                ((MultiMergeJoinData)this.data).results.get(i3).add(((MultiMergeJoinData)this.data).dummy[i3]);
            }
            int current = 0;
            while (true) {
                for (i2 = 0; i2 < streamSize; ++i2) {
                    ((MultiMergeJoinData)this.data).rows[i2] = ((MultiMergeJoinData)this.data).results.get(i2).get(((MultiMergeJoinData)this.data).drainIndices[i2]);
                }
                row = RowDataUtil.createResizedCopy((Object[][])((MultiMergeJoinData)this.data).rows, (int[])((MultiMergeJoinData)this.data).rowLengths);
                this.putRow(((MultiMergeJoinData)this.data).outputRowMeta, row);
                do {
                    int n = current;
                    ((MultiMergeJoinData)this.data).drainIndices[n] = ((MultiMergeJoinData)this.data).drainIndices[n] + 1;
                    if (((MultiMergeJoinData)this.data).drainIndices[n] < ((MultiMergeJoinData)this.data).results.get(current).size()) break;
                    ((MultiMergeJoinData)this.data).drainIndices[current] = 0;
                } while (++current < streamSize);
                if (current >= streamSize) break;
                current = 0;
            }
            for (i2 = 0; i2 < streamSize; ++i2) {
                ((MultiMergeJoinData)this.data).results.get(i2).clear();
            }
        } else {
            if (((MultiMergeJoinData)this.data).queue.size() < streamSize) {
                ((MultiMergeJoinData)this.data).queue.clear();
                block11: for (i = 0; i < streamSize; ++i) {
                    while (((MultiMergeJoinData)this.data).rows[i] != null && !this.isStopped()) {
                        try {
                            ((MultiMergeJoinData)this.data).rows[i] = this.getRowFrom(((MultiMergeJoinData)this.data).rowSets[i]);
                        }
                        catch (Exception e) {
                            // empty catch block
                            continue block11;
                        }
                    }
                }
                this.setOutputDone();
                return false;
            }
            MultiMergeJoinData.QueueEntry minEntry = ((MultiMergeJoinData)this.data).queue.poll();
            int drainSize = 1;
            ((MultiMergeJoinData)this.data).rows[minEntry.index] = minEntry.row;
            ((MultiMergeJoinData)this.data).drainIndices[0] = minEntry.index;
            MultiMergeJoinData.QueueComparator comparator = (MultiMergeJoinData.QueueComparator)((MultiMergeJoinData)this.data).queue.comparator();
            while (!((MultiMergeJoinData)this.data).queue.isEmpty() && comparator.compare(((MultiMergeJoinData)this.data).queue.peek(), minEntry) == 0) {
                MultiMergeJoinData.QueueEntry entry = ((MultiMergeJoinData)this.data).queue.poll();
                ((MultiMergeJoinData)this.data).rows[entry.index] = entry.row;
                ((MultiMergeJoinData)this.data).drainIndices[drainSize++] = entry.index;
            }
            Object[] row = null;
            if (((MultiMergeJoinData)this.data).queue.isEmpty()) {
                int i4;
                int i5;
                for (i5 = 0; i5 < streamSize; ++i5) {
                    ((MultiMergeJoinData)this.data).results.get(i5).add(((MultiMergeJoinData)this.data).rows[i5]);
                    while (!this.isStopped() && (row = this.getRowFrom(((MultiMergeJoinData)this.data).rowSets[i5])) != null && ((MultiMergeJoinData)this.data).metas[i5].compare(((MultiMergeJoinData)this.data).rows[i5], row, ((MultiMergeJoinData)this.data).keyNrs[i5]) == 0) {
                        ((MultiMergeJoinData)this.data).results.get(i5).add(row);
                    }
                    if (this.isStopped()) {
                        this.setOutputDone();
                        return false;
                    }
                    if (row == null) continue;
                    ((MultiMergeJoinData)this.data).queueEntries[i5].row = row;
                    ((MultiMergeJoinData)this.data).queue.add(((MultiMergeJoinData)this.data).queueEntries[i5]);
                }
                for (i5 = 0; i5 < streamSize; ++i5) {
                    ((MultiMergeJoinData)this.data).drainIndices[i5] = 0;
                }
                int current = 0;
                while (true) {
                    for (i4 = 0; i4 < streamSize; ++i4) {
                        ((MultiMergeJoinData)this.data).rows[i4] = ((MultiMergeJoinData)this.data).results.get(i4).get(((MultiMergeJoinData)this.data).drainIndices[i4]);
                    }
                    row = RowDataUtil.createResizedCopy((Object[][])((MultiMergeJoinData)this.data).rows, (int[])((MultiMergeJoinData)this.data).rowLengths);
                    this.putRow(((MultiMergeJoinData)this.data).outputRowMeta, row);
                    do {
                        int n = current;
                        ((MultiMergeJoinData)this.data).drainIndices[n] = ((MultiMergeJoinData)this.data).drainIndices[n] + 1;
                        if (((MultiMergeJoinData)this.data).drainIndices[n] < ((MultiMergeJoinData)this.data).results.get(current).size()) break;
                        ((MultiMergeJoinData)this.data).drainIndices[current] = 0;
                    } while (++current < streamSize);
                    if (current >= streamSize) break;
                    current = 0;
                }
                for (i4 = 0; i4 < streamSize; ++i4) {
                    ((MultiMergeJoinData)this.data).results.get(i4).clear();
                }
            } else {
                for (int i6 = 0; i6 < drainSize; ++i6) {
                    int index = ((MultiMergeJoinData)this.data).drainIndices[i6];
                    while ((row = this.getRowFrom(((MultiMergeJoinData)this.data).rowSets[index])) != null && ((MultiMergeJoinData)this.data).metas[index].compare(((MultiMergeJoinData)this.data).rows[index], row, ((MultiMergeJoinData)this.data).keyNrs[index]) == 0 && !this.isStopped()) {
                    }
                    if (this.isStopped() || row == null) break;
                    ((MultiMergeJoinData)this.data).queueEntries[index].row = row;
                    ((MultiMergeJoinData)this.data).queue.add(((MultiMergeJoinData)this.data).queueEntries[index]);
                }
                if (this.isStopped()) {
                    this.setOutputDone();
                    return false;
                }
            }
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"MultiMergeJoin.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            ITransformIOMeta transformIOMeta = ((MultiMergeJoinMeta)this.meta).getTransformIOMeta();
            String[] inputTransformNames = ((MultiMergeJoinMeta)this.meta).getInputTransforms();
            List infoStreams = transformIOMeta.getInfoStreams();
            for (int i = 0; i < infoStreams.size(); ++i) {
                String inputTransformName = inputTransformNames[i];
                IStream stream = (IStream)infoStreams.get(i);
                if (stream.getTransformMeta() != null) continue;
                this.logError(BaseMessages.getString(PKG, (String)CONST_MULTI_MERGE_JOIN_LOG_UNABLE_TO_FIND_REFERENCE_STREAM, (String[])new String[]{inputTransformName}));
                return false;
            }
            String joinType = ((MultiMergeJoinMeta)this.meta).getJoinType();
            for (int i = 0; i < MultiMergeJoinMeta.joinTypes.length; ++i) {
                if (!joinType.equalsIgnoreCase(MultiMergeJoinMeta.joinTypes[i])) continue;
                ((MultiMergeJoinData)this.data).optional = MultiMergeJoinMeta.optionals[i];
                return true;
            }
            this.logError(BaseMessages.getString(PKG, (String)"MultiMergeJoin.Log.InvalidJoinType", (String[])new String[]{((MultiMergeJoinMeta)this.meta).getJoinType()}));
            return false;
        }
        return true;
    }

    protected boolean isInputLayoutValid(IRowMeta[] rows) {
        if (rows != null) {
            int i;
            String[] keyFields = ((MultiMergeJoinMeta)this.meta).getKeyFields();
            if (rows.length != keyFields.length) {
                this.logError("keys are not configured for all the streams ");
                return false;
            }
            int prevCount = 0;
            ArrayList<String[]> keyList = new ArrayList<String[]>();
            for (i = 0; i < keyFields.length; ++i) {
                String[] keys = keyFields[i].split(",");
                keyList.add(keys);
                int count = keys.length;
                if (i != 0 && prevCount != count) {
                    this.logError("Number of keys do not match ");
                    return false;
                }
                prevCount = count;
            }
            for (i = 0; i < prevCount; ++i) {
                IValueMeta preValue = null;
                for (int j = 0; j < rows.length; ++j) {
                    IValueMeta v = rows[j].searchValueMeta(((String[])keyList.get(j))[i]);
                    if (v == null) {
                        return false;
                    }
                    if (j != 0 && v.getType() != preValue.getType()) {
                        this.logError("key data type do not match ");
                        return false;
                    }
                    preValue = v;
                }
            }
        }
        return true;
    }
}

