/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaUtils;
import org.apache.beam.sdk.schemas.transforms.AutoValue_CoGroup_By;
import org.apache.beam.sdk.schemas.transforms.AutoValue_CoGroup_Result;
import org.apache.beam.sdk.schemas.utils.RowSelector;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CoGroup {
    private static final @UnknownKeyFor @NonNull @Initialized List<@Nullable @UnknownKeyFor @Initialized Row> NULL_LIST = Lists.newArrayList();

    public static @UnknownKeyFor @NonNull @Initialized Impl join(@UnknownKeyFor @NonNull @Initialized By clause) {
        return new Impl(new JoinArguments(clause));
    }

    public static @UnknownKeyFor @NonNull @Initialized Impl join(@UnknownKeyFor @NonNull @Initialized String tag, @UnknownKeyFor @NonNull @Initialized By clause) {
        return new Impl(new JoinArguments((Map<String, By>)ImmutableMap.of((Object)tag, (Object)clause)));
    }

    static void verify(@UnknownKeyFor @NonNull @Initialized PCollectionTuple input, @UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs) {
        Set joinTags;
        Set inputTags;
        if (joinArgs.allInputsJoinArgs == null && !(inputTags = input.getAll().keySet().stream().map(TupleTag::getId).collect(Collectors.toSet())).equals(joinTags = joinArgs.joinArgsMap.keySet())) {
            throw new IllegalArgumentException("The input PCollectionTuple has tags: " + inputTags + " and the join was specified for tags " + joinTags + ". These do not match.");
        }
    }

    static {
        NULL_LIST.add(null);
    }

    public static class ExpandCrossProduct
    extends PTransform<PCollectionTuple, PCollection<Row>> {
        private final @UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs;

        ExpandCrossProduct(@UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs) {
            this.joinArgs = joinArgs;
        }

        public @UnknownKeyFor @NonNull @Initialized ExpandCrossProduct join(@UnknownKeyFor @NonNull @Initialized String tag, @UnknownKeyFor @NonNull @Initialized By clause) {
            if (this.joinArgs.allInputsJoinArgs != null) {
                throw new IllegalStateException("Cannot set both a global and per-tag fields.");
            }
            return new ExpandCrossProduct(this.joinArgs.with(tag, clause));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionTuple input) {
            PCollection expanded;
            CoGroup.verify(input, this.joinArgs);
            JoinInformation joinInformation = JoinInformation.from(input, x$0 -> this.joinArgs.getFieldAccessDescriptor(x$0), x$0 -> this.joinArgs.getSideInputSource(x$0));
            Result.verifyExpandedArgs(joinInformation, this.joinArgs);
            Schema outputSchema = Result.getExpandedOutputSchema(joinInformation, this.joinArgs);
            Collection views = joinInformation.sideInputs.values();
            if (joinInformation.keyedPCollectionTuple.getKeyedCollections().size() > 1) {
                expanded = (PCollection)((Object)((PCollection)joinInformation.keyedPCollectionTuple.apply("CoGroupByKey", CoGroupByKey.create())).apply(ParDo.of(new ConvertCoGbkResult(joinInformation, this.joinArgs, ConvertCoGbkResult.ConvertType.EXPANDED, outputSchema)).withSideInputs(views)));
            } else {
                KeyedPCollectionTuple.TaggedKeyedPCollection tpc = (KeyedPCollectionTuple.TaggedKeyedPCollection)Iterables.getOnlyElement(joinInformation.keyedPCollectionTuple.getKeyedCollections());
                expanded = (PCollection)((Object)tpc.getCollection().apply(ParDo.of(new ExpandRowResult(joinInformation, this.joinArgs, outputSchema)).withSideInputs(views)));
            }
            return expanded.setRowSchema(outputSchema);
        }
    }

    public static class Impl
    extends PTransform<PCollectionTuple, PCollection<Row>> {
        private final @UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs;
        private final @UnknownKeyFor @NonNull @Initialized String keyFieldName;

        private Impl() {
            this(new JoinArguments(Collections.emptyMap()));
        }

        private Impl(@UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs) {
            this(joinArgs, "key");
        }

        private Impl(@UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs, @UnknownKeyFor @NonNull @Initialized String keyFieldName) {
            this.joinArgs = joinArgs;
            this.keyFieldName = keyFieldName;
        }

        public @UnknownKeyFor @NonNull @Initialized Impl withKeyField(@UnknownKeyFor @NonNull @Initialized String keyFieldName) {
            return new Impl(this.joinArgs, keyFieldName);
        }

        public @UnknownKeyFor @NonNull @Initialized Impl join(@UnknownKeyFor @NonNull @Initialized String tag, @UnknownKeyFor @NonNull @Initialized By clause) {
            if (this.joinArgs.allInputsJoinArgs != null) {
                throw new IllegalStateException("Cannot set both a global and per-tag fields.");
            }
            return new Impl(this.joinArgs.with(tag, clause), this.keyFieldName);
        }

        public @UnknownKeyFor @NonNull @Initialized ExpandCrossProduct crossProductJoin() {
            return new ExpandCrossProduct(this.joinArgs);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionTuple input) {
            CoGroup.verify(input, this.joinArgs);
            JoinInformation joinInformation = JoinInformation.from(input, x$0 -> this.joinArgs.getFieldAccessDescriptor(x$0), x$0 -> this.joinArgs.getSideInputSource(x$0));
            Collection views = joinInformation.sideInputs.values();
            Schema outputSchema = Result.getUnexandedOutputSchema(this.keyFieldName, joinInformation);
            return ((PCollection)((Object)((PCollection)joinInformation.keyedPCollectionTuple.apply("CoGroupByKey", CoGroupByKey.create())).apply(ParDo.of(new ConvertCoGbkResult(joinInformation, this.joinArgs, ConvertCoGbkResult.ConvertType.UNEXPANDED, outputSchema)).withSideInputs(views)))).setRowSchema(outputSchema);
        }
    }

    static class ExpandRowResult
    extends DoFn<KV<Row, Row>, Row> {
        private final @UnknownKeyFor @NonNull @Initialized JoinInformation joinInformation;
        private final @UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs;
        private final @UnknownKeyFor @NonNull @Initialized Schema outputSchema;

        public ExpandRowResult(@UnknownKeyFor @NonNull @Initialized JoinInformation joinInformation, @UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs, @UnknownKeyFor @NonNull @Initialized Schema outputSchema) {
            this.joinInformation = joinInformation;
            this.joinArgs = joinArgs;
            this.outputSchema = outputSchema;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row> element, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
            Result result = Result.from(this.joinInformation, this.joinArgs, element.getKey(), this.outputSchema, element.getValue(), c);
            result.outputExpandedRows(o);
        }
    }

    static class ConvertCoGbkResult
    extends DoFn<KV<Row, CoGbkResult>, Row> {
        private final @UnknownKeyFor @NonNull @Initialized JoinInformation joinInformation;
        private final @UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs;
        private final @UnknownKeyFor @NonNull @Initialized Schema outputSchema;
        private @UnknownKeyFor @NonNull @Initialized ConvertType convertType;

        public ConvertCoGbkResult(@UnknownKeyFor @NonNull @Initialized JoinInformation joinInformation, @UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs, @UnknownKeyFor @NonNull @Initialized ConvertType convertType, @UnknownKeyFor @NonNull @Initialized Schema outputSchema) {
            this.joinInformation = joinInformation;
            this.joinArgs = joinArgs;
            this.outputSchema = outputSchema;
            this.convertType = convertType;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized CoGbkResult> element, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
            Result result = Result.from(this.joinInformation, this.joinArgs, element.getKey(), this.outputSchema, element.getValue(), c);
            if (this.convertType == ConvertType.UNEXPANDED) {
                result.outputUnexpandedRow(this.outputSchema, o);
            } else {
                result.outputExpandedRows(o);
            }
        }

        static enum ConvertType {
            UNEXPANDED,
            EXPANDED;

        }
    }

    @AutoValue
    public static abstract class Result {
        abstract @UnknownKeyFor @NonNull @Initialized Row getKey();

        abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>> getIterables();

        abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getTags();

        abstract @UnknownKeyFor @NonNull @Initialized JoinArguments getJoinArguments();

        abstract @UnknownKeyFor @NonNull @Initialized Schema getOutputSchema();

        static @UnknownKeyFor @NonNull @Initialized Result from(@UnknownKeyFor @NonNull @Initialized JoinInformation joinInformation, @UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs, @UnknownKeyFor @NonNull @Initialized Row key, @UnknownKeyFor @NonNull @Initialized Schema outputSchema, @UnknownKeyFor @NonNull @Initialized CoGbkResult coGbkResult, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext) {
            return Result.from(joinInformation, joinArgs, key, outputSchema, coGbkResult::getAll, processContext);
        }

        static @UnknownKeyFor @NonNull @Initialized Result from(@UnknownKeyFor @NonNull @Initialized JoinInformation joinInformation, @UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs, @UnknownKeyFor @NonNull @Initialized Row key, @UnknownKeyFor @NonNull @Initialized Schema outputSchema, @UnknownKeyFor @NonNull @Initialized Row leftRow, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext) {
            return Result.from(joinInformation, joinArgs, key, outputSchema, (String t) -> Lists.newArrayList((Object[])new Row[]{leftRow}), processContext);
        }

        private static @UnknownKeyFor @NonNull @Initialized Result from(@UnknownKeyFor @NonNull @Initialized JoinInformation joinInformation, @UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs, @UnknownKeyFor @NonNull @Initialized Row key, @UnknownKeyFor @NonNull @Initialized Schema outputSchema, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>> leftSideSupplier, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext) {
            ArrayList fields = Lists.newArrayListWithCapacity((int)joinInformation.sortedTags.size());
            ArrayList tags = Lists.newArrayListWithCapacity((int)joinInformation.sortedTags.size());
            for (int i = 0; i < joinInformation.sortedTags.size(); ++i) {
                Iterable rows;
                String tupleTag = (String)joinInformation.tagToKeyedTag.get(i);
                PCollectionView sideView = (PCollectionView)joinInformation.sideInputs.get(tupleTag);
                Iterable iterable = rows = sideView != null ? (Iterable)((Map)processContext.sideInput(sideView)).get(key) : leftSideSupplier.apply(tupleTag);
                if (rows == null) {
                    rows = Collections::emptyIterator;
                }
                fields.add(rows);
                tags.add((String)joinInformation.sortedTags.get(i));
            }
            return new AutoValue_CoGroup_Result(key, fields, tags, joinArgs, outputSchema);
        }

        static @UnknownKeyFor @NonNull @Initialized Schema getUnexandedOutputSchema(@UnknownKeyFor @NonNull @Initialized String keyFieldName, @UnknownKeyFor @NonNull @Initialized JoinInformation joinInformation) {
            Schema.Builder schemaBuilder = Schema.builder().addRowField(keyFieldName, joinInformation.keySchema);
            for (Map.Entry entry : joinInformation.componentSchemas.entrySet()) {
                schemaBuilder.addIterableField((String)entry.getKey(), Schema.FieldType.row((Schema)entry.getValue()));
            }
            return schemaBuilder.build();
        }

        void outputUnexpandedRow(@UnknownKeyFor @NonNull @Initialized Schema outputSchema, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
            ArrayList fields = Lists.newArrayListWithCapacity((int)(this.getIterables().size() + 1));
            fields.add(this.getKey());
            fields.addAll(this.getIterables());
            o.output(Row.withSchema(outputSchema).attachValues(fields));
        }

        static void verifyExpandedArgs(@UnknownKeyFor @NonNull @Initialized JoinInformation joinInformation, @UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs) {
            boolean hasSideInput = false;
            boolean allMainInputsOptional = true;
            for (int i = 0; i < joinInformation.sortedTags.size(); ++i) {
                String tupleTag = (String)joinInformation.tagToKeyedTag.get(i);
                if (joinInformation.sideInputs.get(tupleTag) != null) {
                    hasSideInput = true;
                    continue;
                }
                if (joinArgs.getOptionalParticipation((String)joinInformation.sortedTags.get(i))) continue;
                allMainInputsOptional = false;
            }
            Preconditions.checkArgument((!hasSideInput || !allMainInputsOptional ? 1 : 0) != 0, (Object)"Cannot perform join when all main inputs are optional and there is a side input.  consider removing the side input.");
        }

        static @UnknownKeyFor @NonNull @Initialized Schema getExpandedOutputSchema(@UnknownKeyFor @NonNull @Initialized JoinInformation joinInformation, @UnknownKeyFor @NonNull @Initialized JoinArguments joinArgs) {
            Schema.Builder joinedSchemaBuilder = Schema.builder();
            for (Map.Entry entry : joinInformation.componentSchemas.entrySet()) {
                Schema.FieldType fieldType = Schema.FieldType.row((Schema)entry.getValue());
                if (joinArgs.getOptionalParticipation((String)entry.getKey())) {
                    fieldType = fieldType.withNullable(true);
                }
                joinedSchemaBuilder.addField((String)entry.getKey(), fieldType);
            }
            return joinedSchemaBuilder.build();
        }

        void outputExpandedRows(@UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
            List<Iterable<Row>> allIterables = this.extractIterables();
            ArrayList accumulatedRows = Lists.newArrayListWithCapacity((int)this.getIterables().size());
            this.crossProduct(0, accumulatedRows, allIterables, o);
        }

        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>> extractIterables() {
            ArrayList iterables = Lists.newArrayListWithCapacity((int)this.getIterables().size());
            for (int i = 0; i < this.getIterables().size(); ++i) {
                Iterable<Row> items = this.getIterables().get(i);
                String tag = this.getTags().get(i);
                if (!items.iterator().hasNext() && this.getJoinArguments().getOptionalParticipation(tag)) {
                    items = () -> NULL_LIST.iterator();
                }
                iterables.add(items);
            }
            return iterables;
        }

        private void crossProduct(@UnknownKeyFor @NonNull @Initialized int tagIndex, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> accumulatedRows, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>> iterables, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
            if (tagIndex >= iterables.size()) {
                return;
            }
            for (Row row : iterables.get(tagIndex)) {
                this.crossProductHelper(tagIndex, accumulatedRows, row, iterables, o);
            }
        }

        private void crossProductHelper(@UnknownKeyFor @NonNull @Initialized int tagIndex, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> accumulatedRows, @UnknownKeyFor @NonNull @Initialized Row newRow, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>> iterables, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
            boolean atBottom = tagIndex == iterables.size() - 1;
            accumulatedRows.add(newRow);
            if (atBottom) {
                Row row = Row.withSchema(this.getOutputSchema()).attachValues(Lists.newArrayList(accumulatedRows));
                o.output(row);
            } else {
                this.crossProduct(tagIndex + 1, accumulatedRows, iterables, o);
            }
            accumulatedRows.remove(accumulatedRows.size() - 1);
        }
    }

    static class JoinInformation
    implements Serializable {
        private final transient @UnknownKeyFor @NonNull @Initialized KeyedPCollectionTuple<@UnknownKeyFor @NonNull @Initialized Row> keyedPCollectionTuple;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>>>> sideInputs;
        private final @UnknownKeyFor @NonNull @Initialized Schema keySchema;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Schema> componentSchemas;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> sortedTags;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized String> tagToKeyedTag;

        private JoinInformation(@UnknownKeyFor @NonNull @Initialized KeyedPCollectionTuple<@UnknownKeyFor @NonNull @Initialized Row> keyedPCollectionTuple, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>>>> sideInputs, @UnknownKeyFor @NonNull @Initialized Schema keySchema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Schema> componentSchemas, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> sortedTags, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized String> tagToKeyedTag) {
            this.keyedPCollectionTuple = keyedPCollectionTuple;
            this.sideInputs = sideInputs;
            this.keySchema = keySchema;
            this.componentSchemas = componentSchemas;
            this.sortedTags = sortedTags;
            this.tagToKeyedTag = tagToKeyedTag;
        }

        private static @UnknownKeyFor @NonNull @Initialized JoinInformation from(@UnknownKeyFor @NonNull @Initialized PCollectionTuple input, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor> getFieldAccessDescriptor, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Boolean> getIsSideInput) {
            String tag;
            KeyedPCollectionTuple<Row> keyedPCollectionTuple = KeyedPCollectionTuple.empty(input.getPipeline());
            List<String> sortedTags = input.getAll().keySet().stream().map(TupleTag::getId).sorted().collect(Collectors.toList());
            TreeMap componentSchemas = Maps.newTreeMap();
            HashMap sideInputs = Maps.newHashMap();
            HashMap tagToKeyedTag = Maps.newHashMap();
            Schema keySchema = null;
            for (Map.Entry<TupleTag<?>, PCollection<?>> entry : input.getAll().entrySet()) {
                tag = entry.getKey().getId();
                PCollection<?> pc = entry.getValue();
                Schema schema = pc.getSchema();
                componentSchemas.put(tag, schema);
                FieldAccessDescriptor fieldAccessDescriptor = getFieldAccessDescriptor.apply(tag);
                if (fieldAccessDescriptor == null) {
                    throw new IllegalStateException("No fields were set for input " + tag);
                }
                FieldAccessDescriptor resolved = fieldAccessDescriptor.resolve(schema);
                Schema currentKeySchema = SelectHelpers.getOutputSchema(schema, resolved);
                if (keySchema == null) {
                    keySchema = currentKeySchema;
                    continue;
                }
                keySchema = SchemaUtils.mergeWideningNullable(keySchema, currentKeySchema);
            }
            for (Map.Entry<TupleTag<?>, PCollection<?>> entry : input.getAll().entrySet()) {
                tag = entry.getKey().getId();
                int tagIndex = sortedTags.indexOf(tag);
                PCollection<?> pc = entry.getValue();
                Schema schema = pc.getSchema();
                FieldAccessDescriptor fieldAccessDescriptor = getFieldAccessDescriptor.apply(tag);
                FieldAccessDescriptor resolved = fieldAccessDescriptor.resolve(schema);
                TupleTag randomTag = new TupleTag();
                String keyedTag = tag + "_" + randomTag;
                tagToKeyedTag.put(tagIndex, keyedTag);
                PCollection keyedPCollection = JoinInformation.extractKey(pc, schema, keySchema, resolved, tag);
                if (getIsSideInput.apply(tag).booleanValue()) {
                    sideInputs.put(keyedTag, (PCollectionView)keyedPCollection.apply("computeSideInputView" + tag, View.asMultimap()));
                    continue;
                }
                keyedPCollectionTuple = keyedPCollectionTuple.and(keyedTag, keyedPCollection);
            }
            return new JoinInformation(keyedPCollectionTuple, sideInputs, keySchema, componentSchemas, sortedTags, tagToKeyedTag);
        }

        private static <T> @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row>> extractKey(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection, final @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Schema keySchema, final @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor keyFields, @UnknownKeyFor @NonNull @Initialized String tag) {
            return ((PCollection)pCollection.apply("extractKey" + tag, ParDo.of(new DoFn<T, KV<Row, Row>>(){
                private @UnknownKeyFor @NonNull @Initialized RowSelector rowSelector;
                {
                    this.rowSelector = new SelectHelpers.RowSelectorContainer(schema, keyFields, true);
                }

                @DoFn.ProcessElement
                public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row>> o) {
                    o.output(KV.of(this.rowSelector.select(row), row));
                }
            }))).setCoder(KvCoder.of(SchemaCoder.of(keySchema), SchemaCoder.of(schema)));
        }
    }

    static class JoinArguments
    implements Serializable {
        private final @Nullable @UnknownKeyFor @Initialized By allInputsJoinArgs;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized By> joinArgsMap;

        JoinArguments(@Nullable @UnknownKeyFor @Initialized By allInputsJoinArgs) {
            this.allInputsJoinArgs = allInputsJoinArgs;
            this.joinArgsMap = Collections.emptyMap();
        }

        JoinArguments(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized By> joinArgsMap) {
            this.allInputsJoinArgs = null;
            this.joinArgsMap = joinArgsMap;
        }

        @UnknownKeyFor @NonNull @Initialized JoinArguments with(@UnknownKeyFor @NonNull @Initialized String tag, @UnknownKeyFor @NonNull @Initialized By clause) {
            return new JoinArguments((Map<String, By>)new ImmutableMap.Builder().putAll(this.joinArgsMap).put((Object)tag, (Object)clause).build());
        }

        private @Nullable @UnknownKeyFor @Initialized FieldAccessDescriptor getFieldAccessDescriptor(@UnknownKeyFor @NonNull @Initialized String tag) {
            return this.allInputsJoinArgs != null ? this.allInputsJoinArgs.getFieldAccessDescriptor() : this.joinArgsMap.get(tag).getFieldAccessDescriptor();
        }

        private @UnknownKeyFor @NonNull @Initialized boolean getOptionalParticipation(@UnknownKeyFor @NonNull @Initialized String tag) {
            return this.allInputsJoinArgs != null ? this.allInputsJoinArgs.getOptionalParticipation() : this.joinArgsMap.get(tag).getOptionalParticipation();
        }

        private @UnknownKeyFor @NonNull @Initialized boolean getSideInputSource(@UnknownKeyFor @NonNull @Initialized String tag) {
            return this.allInputsJoinArgs != null ? this.allInputsJoinArgs.getSideInput() : this.joinArgsMap.get(tag).getSideInput();
        }
    }

    @AutoValue
    public static abstract class By
    implements Serializable {
        abstract @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor getFieldAccessDescriptor();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getOptionalParticipation();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getSideInput();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public static @UnknownKeyFor @NonNull @Initialized By fieldNames(String ... fieldNames) {
            return By.fieldAccessDescriptor(FieldAccessDescriptor.withFieldNames(fieldNames));
        }

        public static @UnknownKeyFor @NonNull @Initialized By fieldIds(Integer ... fieldIds) {
            return By.fieldAccessDescriptor(FieldAccessDescriptor.withFieldIds(fieldIds));
        }

        public static @UnknownKeyFor @NonNull @Initialized By fieldAccessDescriptor(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
            return new AutoValue_CoGroup_By.Builder().setFieldAccessDescriptor(fieldAccessDescriptor).setOptionalParticipation(false).setSideInput(false).build();
        }

        public @UnknownKeyFor @NonNull @Initialized By withOptionalParticipation() {
            return this.toBuilder().setOptionalParticipation(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized By withSideInput() {
            return this.toBuilder().setSideInput(true).build();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFieldAccessDescriptor(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setOptionalParticipation(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSideInput(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized By build();
        }
    }
}

