/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import com.inmethod.grid.column.PropertyColumn;
import com.inmethod.grid.treegrid.TreeGrid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.event.SaveModelEvent;
import org.apache.directory.fortress.web.modal.ModalWindow;
import org.apache.directory.fortress.web.model.GroupListModel;
import org.apache.directory.fortress.web.panel.GroupListPanel;
import org.apache.directory.fortress.web.panel.UserSearchModalPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupListPanel
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)GroupListPanel.class.getName());
    private Form listForm;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode node;
    private TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid;
    private DefaultMutableTreeNode rootNode;
    private TextField searchValFld;
    private RadioGroup radioGroup;
    private String searchVal;
    private char selectedRadioButton;
    private static final char NAMES = 'N';
    private static final char MEMBERS = 'M';

    public GroupListPanel(String id) {
        super(id);
        GroupListModel groupListModel = new GroupListModel(new Group(""), SecUtils.getSession((Component)this));
        this.setDefaultModel((IModel)groupListModel);
        this.addGrid();
        this.radioGroup = new RadioGroup("searchOptions", (IModel)new PropertyModel((Object)this, "selectedRadioButton"));
        this.add(new Component[]{this.radioGroup});
        Radio groupRb = new Radio("groupRb", (IModel)new Model((Serializable)Character.valueOf('N')));
        this.radioGroup.add(new Component[]{groupRb});
        Radio memberRb = new Radio("memberRb", (IModel)new Model((Serializable)Character.valueOf('M')));
        this.radioGroup.add(new Component[]{memberRb});
        this.addMemberSearchModal(memberRb);
        this.radioGroup.setOutputMarkupId(true);
        this.radioGroup.setRenderBodyOnly(false);
        this.searchValFld = new TextField("searchVal", (IModel)new PropertyModel((Object)this, "searchVal"));
        this.searchValFld.setOutputMarkupId(true);
        1 ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.searchValFld.add(new Behavior[]{ajaxUpdater});
        this.radioGroup.add(new Component[]{this.searchValFld});
        this.listForm.add(new Component[]{this.radioGroup});
        this.selectedRadioButton = (char)78;
        this.listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    public void onEvent(IEvent event) {
        if (event.getPayload() instanceof SaveModelEvent) {
            SaveModelEvent modelEvent = (SaveModelEvent)event.getPayload();
            switch (6.$SwitchMap$org$apache$directory$fortress$web$event$SaveModelEvent$Operations[modelEvent.getOperation().ordinal()]) {
                case 1: {
                    this.add(modelEvent.getEntity());
                    break;
                }
                case 2: {
                    this.modelChanged();
                    break;
                }
                case 3: {
                    this.prune();
                    break;
                }
                default: {
                    LOG.error("onEvent caught invalid operation");
                }
            }
            AjaxRequestTarget target = ((SaveModelEvent)event.getPayload()).getAjaxRequestTarget();
            LOG.debug(".onEvent AJAX - GroupListPanel - SaveModelEvent: " + target.toString());
        }
    }

    private void removeSelectedItems(TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid) {
        Collection selected = grid.getSelectedItems();
        for (IModel model : selected) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getObject();
            this.treeModel.removeNodeFromParent(node);
            Group group = (Group)node.getUserObject();
            LOG.debug(".removeSelectedItems user node: " + group.getName());
        }
    }

    private DefaultTreeModel createTreeModel(List<Group> groups) {
        this.rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel model = new DefaultTreeModel(this.rootNode);
        if (groups == null) {
            LOG.debug("no Groups found");
        } else {
            LOG.debug(".createTreeModel Groups found:" + groups.size());
            for (Group group : groups) {
                this.rootNode.add(new DefaultMutableTreeNode(group));
            }
        }
        return model;
    }

    private void addGrid() {
        ArrayList<PropertyColumn> columns = new ArrayList<PropertyColumn>();
        PropertyColumn groupName = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Group Name")), "userObject.Name");
        groupName.setInitialSize(250);
        columns.add(groupName);
        PropertyColumn description = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Description")), "userObject.Description");
        description.setInitialSize(300);
        columns.add(description);
        List groups = (List)this.getDefaultModel().getObject();
        this.treeModel = this.createTreeModel(groups);
        this.grid = new /* Unavailable Anonymous Inner Class!! */;
        this.grid.setAllowSelectMultiple(false);
        this.grid.setClickRowToSelect(true);
        this.grid.setClickRowToDeselect(false);
        this.grid.setSelectToEdit(false);
        this.grid.getTreeState().expandAll();
        this.listForm = new Form("grouplistform");
        this.listForm.add(new Component[]{this.grid});
        this.add(new Component[]{this.listForm});
        this.grid.setOutputMarkupId(true);
    }

    private void addMemberSearchModal(Radio memberRb) {
        Component[] componentArray = new Component[1];
        ModalWindow memberModalWindow = new ModalWindow("membersearchmodal");
        componentArray[0] = memberModalWindow;
        this.listForm.add(componentArray);
        UserSearchModalPanel userSearchModalPanel = new UserSearchModalPanel(memberModalWindow.getContentId(), memberModalWindow);
        memberModalWindow.setContent((Component)userSearchModalPanel);
        memberModalWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        memberRb.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        memberModalWindow.setTitle("Member Search Modal");
        memberModalWindow.setInitialWidth(450);
        memberModalWindow.setInitialHeight(450);
        memberModalWindow.setCookieName("member-modal");
    }

    public void add(FortEntity entity) {
        if (this.getDefaultModelObject() != null) {
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(entity), this.rootNode, 0);
        }
    }

    public void prune() {
        this.removeSelectedItems(this.grid);
    }
}

