/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc.dsfactory;

import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.InstanceKeyDataSource;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class SharedPoolDataSourceFactory
implements DataSourceFactory {
    private static final Log log = LogManager.getLog(SharedPoolDataSourceFactory.class);
    private String name;
    private SharedPoolDataSource ds;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataSource getDataSource() {
        return this.ds;
    }

    @Override
    public void initialize(JDBCDiskCacheAttributes config) throws SQLException {
        this.name = config.getConnectionPoolName();
        ConnectionPoolDataSource cpds = SharedPoolDataSourceFactory.initCPDS(config);
        SharedPoolDataSource dataSource = new SharedPoolDataSource();
        SharedPoolDataSourceFactory.initJdbc2Pool((InstanceKeyDataSource)dataSource, config);
        dataSource.setConnectionPoolDataSource(cpds);
        dataSource.setMaxTotal(config.getMaxTotal());
        this.ds = dataSource;
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (Exception e) {
            throw new SQLException("Exception caught closing data source", e);
        }
        this.ds = null;
    }

    private static ConnectionPoolDataSource initCPDS(JDBCDiskCacheAttributes config) throws SQLException {
        log.debug("Starting initCPDS");
        DriverAdapterCPDS cpds = new DriverAdapterCPDS();
        try {
            cpds.setDriver(config.getDriverClassName());
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Driver class not found " + config.getDriverClassName(), e);
        }
        cpds.setUrl(config.getUrl());
        cpds.setUser(config.getUserName());
        cpds.setPassword(config.getPassword());
        return cpds;
    }

    private static void initJdbc2Pool(InstanceKeyDataSource dataSource, JDBCDiskCacheAttributes config) throws SQLException {
        log.debug("Starting initJdbc2Pool");
        dataSource.setDescription(config.getConnectionPoolName());
    }
}

