/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

import java.io.IOException;
import org.eclipse.jgit.blame.BlameGenerator;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;

public class BlameResult {
    private final String resultPath;
    private final RevCommit[] sourceCommits;
    private final PersonIdent[] sourceAuthors;
    private final PersonIdent[] sourceCommitters;
    private final String[] sourcePaths;
    private final int[] sourceLines;
    private RawText resultContents;
    private BlameGenerator generator;
    private int lastLength;

    public static BlameResult create(BlameGenerator gen) throws IOException {
        String path = gen.getResultPath();
        RawText contents = gen.getResultContents();
        if (contents == null) {
            gen.release();
            return null;
        }
        return new BlameResult(gen, path, contents);
    }

    BlameResult(BlameGenerator bg, String path, RawText text) {
        this.generator = bg;
        this.resultPath = path;
        this.resultContents = text;
        int cnt = text.size();
        this.sourceCommits = new RevCommit[cnt];
        this.sourceAuthors = new PersonIdent[cnt];
        this.sourceCommitters = new PersonIdent[cnt];
        this.sourceLines = new int[cnt];
        this.sourcePaths = new String[cnt];
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public RawText getResultContents() {
        return this.resultContents;
    }

    public void discardResultContents() {
        this.resultContents = null;
    }

    public boolean hasSourceData(int idx) {
        return this.sourceLines[idx] != 0;
    }

    public boolean hasSourceData(int start, int end) {
        while (start < end) {
            if (this.sourceLines[start] == 0) {
                return false;
            }
            ++start;
        }
        return true;
    }

    public RevCommit getSourceCommit(int idx) {
        return this.sourceCommits[idx];
    }

    public PersonIdent getSourceAuthor(int idx) {
        return this.sourceAuthors[idx];
    }

    public PersonIdent getSourceCommitter(int idx) {
        return this.sourceCommitters[idx];
    }

    public String getSourcePath(int idx) {
        return this.sourcePaths[idx];
    }

    public int getSourceLine(int idx) {
        return this.sourceLines[idx] - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeAll() throws IOException {
        BlameGenerator gen = this.generator;
        if (gen == null) {
            return;
        }
        try {
            while (gen.next()) {
                this.loadFrom(gen);
            }
        }
        finally {
            gen.release();
            this.generator = null;
        }
    }

    public int computeNext() throws IOException {
        BlameGenerator gen = this.generator;
        if (gen == null) {
            return -1;
        }
        if (gen.next()) {
            this.loadFrom(gen);
            this.lastLength = gen.getRegionLength();
            return gen.getResultStart();
        }
        gen.release();
        this.generator = null;
        return -1;
    }

    public int lastLength() {
        return this.lastLength;
    }

    public void computeRange(int start, int end) throws IOException {
        BlameGenerator gen = this.generator;
        if (gen == null) {
            return;
        }
        while (start < end) {
            if (this.hasSourceData(start, end)) {
                return;
            }
            if (!gen.next()) {
                gen.release();
                this.generator = null;
                return;
            }
            this.loadFrom(gen);
            int resLine = gen.getResultStart();
            int resEnd = gen.getResultEnd();
            if (resLine <= start && start < resEnd) {
                start = resEnd;
            }
            if (resLine > end || end >= resEnd) continue;
            end = resLine;
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("BlameResult: ");
        r.append(this.getResultPath());
        return r.toString();
    }

    private void loadFrom(BlameGenerator gen) {
        RevCommit srcCommit = gen.getSourceCommit();
        PersonIdent srcAuthor = gen.getSourceAuthor();
        PersonIdent srcCommitter = gen.getSourceCommitter();
        String srcPath = gen.getSourcePath();
        int srcLine = gen.getSourceStart();
        int resEnd = gen.getResultEnd();
        for (int resLine = gen.getResultStart(); resLine < resEnd; ++resLine) {
            if (this.sourceLines[resLine] != 0) continue;
            this.sourceCommits[resLine] = srcCommit;
            this.sourceAuthors[resLine] = srcAuthor;
            this.sourceCommitters[resLine] = srcCommitter;
            this.sourcePaths[resLine] = srcPath;
            this.sourceLines[resLine] = ++srcLine;
        }
    }
}

