/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.BufferPositionInvariantsException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.collections.Lists;

public class BufferTest {
    @Test
    public void checkDirectRoundTrip() throws Exception {
        int n = 1024;
        try (WritableMemory wmem = WritableMemory.allocateDirect((long)(n * 8));){
            int i;
            WritableBuffer wbuf = wmem.asWritableBuffer();
            for (i = 0; i < n; ++i) {
                wbuf.putLong((long)i);
            }
            wbuf.resetPosition();
            for (i = 0; i < n; ++i) {
                long v = wbuf.getLong();
                Assert.assertEquals((long)v, (long)i);
            }
        }
    }

    @Test
    public void checkAutoHeapRoundTrip() {
        int i;
        int n = 1024;
        WritableBuffer wbuf = WritableMemory.allocate((int)(n * 8)).asWritableBuffer();
        for (i = 0; i < n; ++i) {
            wbuf.putLong((long)i);
        }
        wbuf.resetPosition();
        for (i = 0; i < n; ++i) {
            long v = wbuf.getLong();
            Assert.assertEquals((long)v, (long)i);
        }
    }

    @Test
    public void checkArrayWrap() {
        int i;
        int n = 1024;
        byte[] arr = new byte[n * 8];
        WritableBuffer wbuf = WritableMemory.writableWrap((byte[])arr).asWritableBuffer();
        for (i = 0; i < n; ++i) {
            wbuf.putLong((long)i);
        }
        wbuf.resetPosition();
        for (i = 0; i < n; ++i) {
            long v = wbuf.getLong();
            Assert.assertEquals((long)v, (long)i);
        }
        Buffer buf = Memory.wrap((byte[])arr).asBuffer();
        buf.resetPosition();
        for (int i2 = 0; i2 < n; ++i2) {
            long v = buf.getLong();
            Assert.assertEquals((long)v, (long)i2);
        }
        Memory mem = Memory.wrap((byte[])new byte[0]);
        Buffer buffZeroLengthArrayWrap = mem.asBuffer();
        Assert.assertEquals((long)buffZeroLengthArrayWrap.getCapacity(), (long)0L);
        List buffersToCheck = Lists.newArrayList();
        buffersToCheck.add(WritableMemory.allocate((int)0).asBuffer());
        buffersToCheck.add(WritableBuffer.writableWrap((ByteBuffer)ByteBuffer.allocate(0)));
        buffersToCheck.add(Buffer.wrap((ByteBuffer)ByteBuffer.allocate(0)));
        buffersToCheck.add(Memory.wrap((byte[])new byte[0]).asBuffer());
        buffersToCheck.add(Memory.wrap((char[])new char[0]).asBuffer());
        buffersToCheck.add(Memory.wrap((short[])new short[0]).asBuffer());
        buffersToCheck.add(Memory.wrap((int[])new int[0]).asBuffer());
        buffersToCheck.add(Memory.wrap((long[])new long[0]).asBuffer());
        buffersToCheck.add(Memory.wrap((float[])new float[0]).asBuffer());
        buffersToCheck.add(Memory.wrap((double[])new double[0]).asBuffer());
        for (Buffer buffer : buffersToCheck) {
            Assert.assertEquals((long)buffer.getCapacity(), (long)0L);
        }
    }

    @Test
    public void simpleBBTest() {
        long v;
        int i;
        int n = 1024;
        byte[] arr = new byte[n * 8];
        ByteBuffer bb = ByteBuffer.wrap(arr);
        bb.order(ByteOrder.nativeOrder());
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)bb);
        for (i = 0; i < n; ++i) {
            wbuf.putLong((long)i);
        }
        wbuf.resetPosition();
        for (i = 0; i < n; ++i) {
            v = wbuf.getLong();
            Assert.assertEquals((long)v, (long)i);
        }
        for (i = 0; i < n; ++i) {
            v = bb.getLong();
            Assert.assertEquals((long)v, (long)i);
        }
    }

    @Test
    public void checkByteBufHeap() {
        long v;
        int i;
        int n = 1024;
        byte[] arr = new byte[n * 8];
        ByteBuffer bb = ByteBuffer.wrap(arr);
        bb.order(ByteOrder.nativeOrder());
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)bb);
        for (i = 0; i < n; ++i) {
            wbuf.putLong((long)i);
        }
        wbuf.resetPosition();
        for (i = 0; i < n; ++i) {
            v = wbuf.getLong();
            Assert.assertEquals((long)v, (long)i);
        }
        for (i = 0; i < n; ++i) {
            v = bb.getLong(i * 8);
            Assert.assertEquals((long)v, (long)i);
        }
        Buffer buf1 = Memory.wrap((byte[])arr).asBuffer();
        for (int i2 = 0; i2 < n; ++i2) {
            long v2 = buf1.getLong();
            Assert.assertEquals((long)v2, (long)i2);
        }
        WritableBuffer buf = wbuf;
        buf.resetPosition();
        for (int i3 = 0; i3 < n; ++i3) {
            long v3 = buf.getLong();
            Assert.assertEquals((long)v3, (long)i3);
        }
    }

    @Test
    public void checkByteBufDirect() {
        long v;
        int i;
        int n = 1024;
        ByteBuffer bb = ByteBuffer.allocateDirect(n * 8);
        bb.order(ByteOrder.nativeOrder());
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)bb);
        for (i = 0; i < n; ++i) {
            wbuf.putLong((long)i);
        }
        wbuf.resetPosition();
        for (i = 0; i < n; ++i) {
            v = wbuf.getLong();
            Assert.assertEquals((long)v, (long)i);
        }
        for (i = 0; i < n; ++i) {
            v = bb.getLong(i * 8);
            Assert.assertEquals((long)v, (long)i);
        }
        Buffer buf1 = Buffer.wrap((ByteBuffer)bb);
        for (int i2 = 0; i2 < n; ++i2) {
            long v2 = buf1.getLong();
            Assert.assertEquals((long)v2, (long)i2);
        }
        WritableBuffer buf = wbuf;
        buf.resetPosition();
        for (int i3 = 0; i3 < n; ++i3) {
            long v3 = buf.getLong();
            Assert.assertEquals((long)v3, (long)i3);
        }
    }

    @Test
    public void checkByteBufBigEndianOrder() {
        int n = 1024;
        ByteBuffer bb = ByteBuffer.allocate(n * 8);
        bb.order(ByteOrder.BIG_ENDIAN);
        Buffer buf = Buffer.wrap((ByteBuffer)bb);
        Assert.assertEquals((Object)buf.getTypeByteOrder(), (Object)ByteOrder.BIG_ENDIAN);
    }

    @Test
    public void checkReadOnlyHeapByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(128);
        bb.order(ByteOrder.nativeOrder());
        for (int i = 0; i < 128; ++i) {
            bb.put(i, (byte)i);
        }
        bb.position(64);
        ByteBuffer slice = bb.slice().asReadOnlyBuffer();
        slice.order(ByteOrder.nativeOrder());
        Buffer buf = Buffer.wrap((ByteBuffer)slice);
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((int)buf.getByte(), (int)(64 + i));
        }
        buf.toString("slice", 0L, slice.capacity(), true);
    }

    @Test
    public void checkPutGetArraysHeap() {
        int n = 1024;
        long[] arr = new long[n];
        for (int i = 0; i < n; ++i) {
            arr[i] = i;
        }
        WritableBuffer wbuf = WritableMemory.allocate((int)(n * 8)).asWritableBuffer();
        wbuf.putLongArray(arr, 0, n);
        long[] arr2 = new long[n];
        wbuf.resetPosition();
        wbuf.getLongArray(arr2, 0, n);
        for (int i = 0; i < n; ++i) {
            Assert.assertEquals((long)arr2[i], (long)i);
        }
    }

    @Test
    public void checkRORegions() {
        int n = 16;
        int n2 = n / 2;
        long[] arr = new long[n];
        for (int i = 0; i < n; ++i) {
            arr[i] = i;
        }
        Buffer buf = Memory.wrap((long[])arr).asBuffer();
        buf.setPosition((long)(n2 * 8));
        Buffer reg = buf.region();
        for (int i = 0; i < n2; ++i) {
            long v = reg.getLong();
            Assert.assertEquals((long)v, (long)(i + n2));
        }
    }

    @Test
    public void checkWRegions() {
        int i;
        int n = 16;
        int n2 = n / 2;
        long[] arr = new long[n];
        for (int i2 = 0; i2 < n; ++i2) {
            arr[i2] = i2;
        }
        WritableMemory mem = WritableMemory.writableWrap((long[])arr);
        WritableBuffer wbuf = mem.asWritableBuffer();
        for (int i3 = 0; i3 < n; ++i3) {
            Assert.assertEquals((long)wbuf.getLong(), (long)i3);
            BufferTest.println("" + wbuf.getLong((long)(i3 * 8)));
        }
        BufferTest.println("");
        wbuf.setPosition((long)(n2 * 8));
        WritableBuffer reg = wbuf.writableRegion();
        for (i = 0; i < n2; ++i) {
            reg.putLong((long)i);
        }
        wbuf.resetPosition();
        for (i = 0; i < n; ++i) {
            BufferTest.println("" + wbuf.getLong((long)(i * 8)));
            Assert.assertEquals((long)wbuf.getLong(), (long)(i % 8));
        }
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void checkParentUseAfterFree() throws Exception {
        int bytes = 512;
        WritableMemory wmem = WritableMemory.allocateDirect((long)bytes);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        wmem.close();
        wbuf.getLong();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void checkRegionUseAfterFree() throws Exception {
        int bytes = 64;
        WritableMemory wmem = WritableMemory.allocateDirect((long)bytes);
        Buffer reg = wmem.asBuffer().region();
        wmem.close();
        reg.getByte();
    }

    @Test(expectedExceptions={BufferPositionInvariantsException.class})
    public void checkBaseBufferInvariants() {
        WritableBuffer wbuf = WritableMemory.allocate((int)64).asWritableBuffer();
        wbuf.setStartPositionEnd(1L, 0L, 2L);
    }

    @Test
    public void printlnTest() {
        BufferTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

