/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.chain.ComposableRequestProcessor;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.TilesRequestProcessor;
import org.apache.struts.tiles.TilesUtil;
import org.apache.struts.tiles.TilesUtilStrutsImpl;
import org.apache.struts.tiles.TilesUtilStrutsModulesImpl;
import org.apache.struts.util.RequestUtils;

public class TilesPlugin
implements PlugIn {
    protected static Log log = LogFactory.getLog(TilesPlugin.class);
    protected boolean moduleAware = false;
    protected String tilesUtilImplClassname = null;
    protected DefinitionsFactory definitionFactory = null;
    protected PlugInConfig currentPlugInConfigObject = null;

    public boolean isModuleAware() {
        return this.moduleAware;
    }

    public void setModuleAware(boolean moduleAware) {
        this.moduleAware = moduleAware;
    }

    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        DefinitionsFactoryConfig factoryConfig = this.readFactoryConfig(servlet, moduleConfig);
        factoryConfig.setFactoryName(moduleConfig.getPrefix());
        this.initRequestProcessorClass(moduleConfig);
        this.initTilesUtil();
        this.initDefinitionsFactory(servlet.getServletContext(), moduleConfig, factoryConfig);
    }

    private void initTilesUtil() throws ServletException {
        if (TilesUtil.isTilesUtilImplSet()) {
            return;
        }
        if (this.getTilesUtilImplClassname() == null) {
            if (this.isModuleAware()) {
                TilesUtil.setTilesUtil(new TilesUtilStrutsModulesImpl());
            } else {
                TilesUtil.setTilesUtil(new TilesUtilStrutsImpl());
            }
        } else {
            try {
                TilesUtilStrutsImpl impl = (TilesUtilStrutsImpl)RequestUtils.applicationClass(this.getTilesUtilImplClassname()).newInstance();
                TilesUtil.setTilesUtil(impl);
            }
            catch (ClassCastException ex) {
                throw new ServletException("Can't set TilesUtil implementation to '" + this.getTilesUtilImplClassname() + "'. TilesUtil implementation should be a subclass of '" + TilesUtilStrutsImpl.class.getName() + "'");
            }
            catch (Exception ex) {
                throw new ServletException("Can't set TilesUtil implementation.", (Throwable)ex);
            }
        }
    }

    private void initDefinitionsFactory(ServletContext servletContext, ModuleConfig moduleConfig, DefinitionsFactoryConfig factoryConfig) throws ServletException {
        this.definitionFactory = ((TilesUtilStrutsImpl)TilesUtil.getTilesUtil()).getDefinitionsFactory(servletContext, moduleConfig);
        if (this.definitionFactory != null) {
            log.info("Factory already exists for module '" + moduleConfig.getPrefix() + "'. The factory found is from module '" + this.definitionFactory.getConfig().getFactoryName() + "'. No new creation.");
            return;
        }
        try {
            this.definitionFactory = TilesUtil.createDefinitionsFactory(servletContext, factoryConfig);
        }
        catch (DefinitionsFactoryException ex) {
            log.error("Can't create Tiles definition factory for module '" + moduleConfig.getPrefix() + "'.");
            throw new ServletException((Throwable)ex);
        }
        log.info("Tiles definition factory loaded for module '" + moduleConfig.getPrefix() + "'.");
    }

    public void destroy() {
        this.definitionFactory.destroy();
        this.definitionFactory = null;
    }

    protected DefinitionsFactoryConfig readFactoryConfig(ActionServlet servlet, ModuleConfig config) throws ServletException {
        DefinitionsFactoryConfig factoryConfig = new DefinitionsFactoryConfig();
        try {
            DefinitionsUtil.populateDefinitionsFactoryConfig(factoryConfig, servlet.getServletConfig());
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("", ex);
            }
            ex.printStackTrace();
            throw new UnavailableException("Can't populate DefinitionsFactoryConfig class from 'web.xml': " + ex.getMessage());
        }
        try {
            Map strutsProperties = this.findStrutsPlugInConfigProperties(servlet, config);
            factoryConfig.populate(strutsProperties);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("", ex);
            }
            throw new UnavailableException("Can't populate DefinitionsFactoryConfig class from '" + config.getPrefix() + "/struts-config.xml':" + ex.getMessage());
        }
        return factoryConfig;
    }

    protected Map findStrutsPlugInConfigProperties(ActionServlet servlet, ModuleConfig config) throws ServletException {
        return this.currentPlugInConfigObject.getProperties();
    }

    protected void initRequestProcessorClass(ModuleConfig config) throws ServletException {
        Class tilesProcessorClass;
        Class configProcessorClass;
        String tilesProcessorClassname = TilesRequestProcessor.class.getName();
        ControllerConfig ctrlConfig = config.getControllerConfig();
        String configProcessorClassname = ctrlConfig.getProcessorClass();
        try {
            configProcessorClass = RequestUtils.applicationClass(configProcessorClassname);
        }
        catch (ClassNotFoundException ex) {
            log.fatal("Can't set TilesRequestProcessor: bad class name '" + configProcessorClassname + "'.");
            throw new ServletException((Throwable)ex);
        }
        if (ComposableRequestProcessor.class.isAssignableFrom(configProcessorClass)) {
            return;
        }
        if (configProcessorClassname.equals(RequestProcessor.class.getName()) || configProcessorClassname.endsWith(tilesProcessorClassname)) {
            ctrlConfig.setProcessorClass(tilesProcessorClassname);
            return;
        }
        Class clazz = tilesProcessorClass = TilesRequestProcessor.class;
        if (!tilesProcessorClass.isAssignableFrom(configProcessorClass)) {
            String msg = "TilesPlugin : Specified RequestProcessor not compatible with TilesRequestProcessor";
            if (log.isFatalEnabled()) {
                log.fatal(msg);
            }
            throw new ServletException(msg);
        }
    }

    public void setTilesUtilImplClassname(String tilesUtilImplClassname) {
        this.tilesUtilImplClassname = tilesUtilImplClassname;
    }

    public String getTilesUtilImplClassname() {
        return this.tilesUtilImplClassname;
    }

    public void setCurrentPlugInConfigObject(PlugInConfig plugInConfigObject) {
        this.currentPlugInConfigObject = plugInConfigObject;
    }
}

