/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.creadur.tentacles.Archive;

public class Notice {
    private final String text;
    private final String key;
    private final Set<Archive> archives = new HashSet<Archive>();
    private final List<File> locations = new ArrayList<File>();

    public Notice(String text) {
        this.text = text.intern();
        this.key = text.replaceAll("[ \\n\\t\\r]+", "").toLowerCase().intern();
    }

    public String getText() {
        return this.text;
    }

    public String getKey() {
        return this.key;
    }

    public Set<Archive> getArchives() {
        return this.archives;
    }

    public List<File> getLocations() {
        return this.locations;
    }

    public Set<URI> locations(Archive archive) {
        URI contents = archive.contentsURI();
        HashSet<URI> locations = new HashSet<URI>();
        for (File file : this.locations) {
            URI uri = file.toURI();
            URI relativize = contents.relativize(uri);
            if (relativize.equals(uri)) continue;
            locations.add(relativize);
        }
        return locations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notice notice = (Notice)o;
        return this.key.equals(notice.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean implies(Notice fullLicense) {
        return fullLicense.key.contains(this.key);
    }
}

