/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.TestBean;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JXPath151Test
extends AbstractJXPathTest {
    private JXPathContext context;

    @Override
    @BeforeEach
    public void setUp() {
        TestBean testBean = new TestBean();
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("a", 1);
        m.put("b", null);
        m.put("c", 1);
        m.put("d", 0);
        testBean.setMap(m);
        this.context = JXPathContext.newContext((Object)testBean);
        this.context.setLocale(Locale.US);
    }

    @Test
    public void testMapValueEquality() {
        this.assertXPathValue(this.context, "map/b != map/a", Boolean.TRUE);
        this.assertXPathValue(this.context, "map/a != map/b", Boolean.TRUE);
        this.assertXPathValue(this.context, "map/a != map/c", Boolean.FALSE);
        this.assertXPathValue(this.context, "map/a = map/b", Boolean.FALSE);
        this.assertXPathValue(this.context, "map/a = map/c", Boolean.TRUE);
        this.assertXPathValue(this.context, "not(map/a = map/b)", Boolean.TRUE);
        this.assertXPathValue(this.context, "not(map/a = map/c)", Boolean.FALSE);
    }

    @Test
    public void testMapValueEqualityUsingNameAttribute() {
        this.assertXPathValue(this.context, "map[@name = 'b'] != map[@name = 'c']", Boolean.TRUE);
        this.assertXPathValue(this.context, "map[@name = 'a'] != map[@name = 'b']", Boolean.TRUE);
        this.assertXPathValue(this.context, "map[@name = 'a'] != map[@name = 'c']", Boolean.FALSE);
        this.assertXPathValue(this.context, "map[@name = 'a'] = map[@name = 'b']", Boolean.FALSE);
        this.assertXPathValue(this.context, "map[@name = 'a'] = map[@name = 'c']", Boolean.TRUE);
        this.assertXPathValue(this.context, "map[@name = 'd'] = map[@name = 'b']", Boolean.TRUE);
        this.assertXPathValue(this.context, "map[@name = 'd'] = map[@name = 'b']", Boolean.TRUE);
        this.assertXPathValue(this.context, "not(map[@name = 'a'] = map[@name = 'b'])", Boolean.TRUE);
        this.assertXPathValue(this.context, "not(map[@name = 'a'] = map[@name = 'c'])", Boolean.FALSE);
    }
}

