/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class NamespaceResolver
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1085590057838651311L;
    protected final NamespaceResolver parent;
    protected HashMap<String, String> namespaceMap = new HashMap();
    protected HashMap<String, String> reverseMap = new HashMap();
    protected NodePointer pointer;
    private boolean sealed;

    protected static String getPrefix(NodePointer pointer, String namespaceURI) {
        for (NodePointer currentPointer = pointer; currentPointer != null; currentPointer = currentPointer.getParent()) {
            NodeIterator ni = currentPointer.namespaceIterator();
            int position = 1;
            while (ni != null && ni.setPosition(position)) {
                String prefix;
                NodePointer nsPointer = ni.getNodePointer();
                String uri = nsPointer.getNamespaceURI();
                if (uri.equals(namespaceURI) && !"".equals(prefix = nsPointer.getName().getName())) {
                    return prefix;
                }
                ++position;
            }
        }
        return null;
    }

    public NamespaceResolver() {
        this(null);
    }

    public NamespaceResolver(NamespaceResolver parent) {
        this.parent = parent;
    }

    public Object clone() {
        try {
            NamespaceResolver result = (NamespaceResolver)super.clone();
            result.sealed = false;
            return result;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected synchronized String getExternallyRegisteredNamespaceURI(String prefix) {
        String uri = this.namespaceMap.get(prefix);
        return uri == null && this.parent != null ? this.parent.getExternallyRegisteredNamespaceURI(prefix) : uri;
    }

    protected synchronized String getExternallyRegisteredPrefix(String namespaceURI) {
        String prefix = this.reverseMap.get(namespaceURI);
        return prefix == null && this.parent != null ? this.parent.getExternallyRegisteredPrefix(namespaceURI) : prefix;
    }

    public Pointer getNamespaceContextPointer() {
        if (this.pointer == null && this.parent != null) {
            return this.parent.getNamespaceContextPointer();
        }
        return this.pointer;
    }

    public synchronized String getNamespaceURI(String prefix) {
        String uri = this.getExternallyRegisteredNamespaceURI(prefix);
        return uri == null && this.pointer != null ? this.pointer.getNamespaceURI(prefix) : uri;
    }

    public synchronized String getPrefix(String namespaceURI) {
        String prefix = this.getExternallyRegisteredPrefix(namespaceURI);
        return prefix == null && this.pointer != null ? NamespaceResolver.getPrefix(this.pointer, namespaceURI) : prefix;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public synchronized void registerNamespace(String prefix, String namespaceURI) {
        if (this.isSealed()) {
            throw new IllegalStateException("Cannot register namespaces on a sealed NamespaceResolver");
        }
        this.namespaceMap.put(prefix, namespaceURI);
        this.reverseMap.put(namespaceURI, prefix);
    }

    public void seal() {
        this.sealed = true;
        if (this.parent != null) {
            this.parent.seal();
        }
    }

    public void setNamespaceContextPointer(NodePointer pointer) {
        this.pointer = pointer;
    }
}

