/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.ResultSetMetaData;
import org.apache.commons.dbutils.ProxyFactory;

public class MockResultSetMetaData
implements InvocationHandler {
    private String[] columnNames = null;
    private String[] columnLabels = null;

    public static ResultSetMetaData create(String[] columnNames) {
        return ProxyFactory.instance().createResultSetMetaData((InvocationHandler)new MockResultSetMetaData(columnNames));
    }

    public MockResultSetMetaData(String[] columnNames) {
        this.columnNames = columnNames;
        this.columnLabels = new String[columnNames.length];
    }

    public MockResultSetMetaData(String[] columnNames, String[] columnLabels) {
        this.columnNames = columnNames;
        this.columnLabels = columnLabels;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("getColumnCount")) {
            return this.columnNames.length;
        }
        if (methodName.equals("getColumnName")) {
            int col = (Integer)args[0] - 1;
            return this.columnNames[col];
        }
        if (methodName.equals("getColumnLabel")) {
            int col = (Integer)args[0] - 1;
            return this.columnLabels[col];
        }
        if (methodName.equals("hashCode")) {
            return System.identityHashCode(proxy);
        }
        if (methodName.equals("toString")) {
            return "MockResultSetMetaData " + System.identityHashCode(proxy);
        }
        if (methodName.equals("equals")) {
            return proxy == args[0];
        }
        throw new UnsupportedOperationException("Unsupported method: " + methodName);
    }
}

