/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.flags;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.classloading.JavaBrooklynClassLoadingContext;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonType;
import org.apache.brooklyn.core.resolve.jackson.WrappedValue;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.TypeTokens;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Timestamp;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynTypeNameResolution {
    private static Logger LOG = LoggerFactory.getLogger(BrooklynTypeNameResolution.class);
    private static final Map<String, Class<?>> BUILT_IN_TYPES = ImmutableMap.builder().put((Object)"string", String.class).put((Object)"bool", Boolean.class).put((Object)"boolean", Boolean.class).put((Object)"byte", Byte.class).put((Object)"char", Character.class).put((Object)"character", Character.class).put((Object)"short", Short.class).put((Object)"integer", Integer.class).put((Object)"int", Integer.class).put((Object)"long", Long.class).put((Object)"float", Float.class).put((Object)"double", Double.class).put((Object)"map", Map.class).put((Object)"list", List.class).put((Object)"set", Set.class).put((Object)"wrapped", WrappedValue.class).put((Object)"wrapped-value", WrappedValue.class).put((Object)"wrappedvalue", WrappedValue.class).put((Object)"duration", Duration.class).put((Object)"timestamp", Timestamp.class).put((Object)"instant", Instant.class).put((Object)"port", PortRange.class).build();
    private static final Map<String, Class<?>> BUILT_IN_TYPE_CLASSES;
    private static final Set<String> BUILT_IN_TYPE_RESERVED_WORDS;

    public static Maybe<TypeToken<?>> getTypeTokenForBuiltInTypeName(String className) {
        return BrooklynTypeNameResolution.getClassForBuiltInTypeName(className).transform(TypeToken::of);
    }

    public static Maybe<Class<?>> getClassForBuiltInTypeName(String className) {
        if (className == null) {
            return Maybe.absent((Throwable)new NullPointerException("className is null"));
        }
        Class<?> candidate = BUILT_IN_TYPES.get(className.trim().toLowerCase());
        if (candidate != null) {
            return Maybe.of(candidate);
        }
        candidate = BUILT_IN_TYPE_CLASSES.get(className);
        if (candidate != null) {
            return Maybe.of(candidate);
        }
        return Maybe.absent();
    }

    public static Map<String, Class<?>> standardTypesMap() {
        return BUILT_IN_TYPES;
    }

    public static boolean isBuiltInType(String s) {
        return BUILT_IN_TYPE_RESERVED_WORDS.contains(s.trim().toLowerCase());
    }

    static Maybe<GenericsRecord> parseTypeGenerics(String s) {
        return BrooklynTypeNameResolution.parseTypeGenerics(s, (t, tt) -> Maybe.of((Object)new GenericsRecord((String)t, (List<GenericsRecord>)tt)));
    }

    @VisibleForTesting
    public static Maybe<TypeToken<?>> parseTypeToken(String s, Function<String, Maybe<TypeToken<?>>> typeLookup) {
        return BrooklynTypeNameResolution.parseTypeGenerics(s, (t, tt) -> {
            Maybe c = (Maybe)typeLookup.apply((String)t);
            if (c.isAbsent()) {
                return c;
            }
            if (tt.isEmpty()) {
                return c;
            }
            return Maybe.of((Object)TypeToken.of((Type)BrooklynTypeNameResolution.parameterizedType(TypeTokens.getRawRawType((TypeToken)((TypeToken)c.get())), tt.stream().map(TypeToken::getType).collect(Collectors.toList()))));
        });
    }

    static ParameterizedType parameterizedType(Class<?> raw, List<Type> types) {
        return new BetterToStringParameterizedTypeImpl(raw, null, types.toArray(new Type[0]));
    }

    @Beta
    public static ParameterizedType parameterizedType(ParameterizedType t) {
        return new BetterToStringParameterizedTypeImpl(t);
    }

    static <T> Maybe<T> parseTypeGenerics(String s, BiFunction<String, List<T>, Maybe<T>> baseTypeConverter) {
        GenericsRecord.Parser p = new GenericsRecord.Parser();
        p.s = s;
        p.baseTypeConverter = baseTypeConverter;
        return p.parse(0);
    }

    static {
        MutableMap collector = MutableMap.of();
        BUILT_IN_TYPES.values().forEach(t -> {
            Class cfr_ignored_0 = (Class)collector.put((Object)t.getName(), t);
        });
        BUILT_IN_TYPE_CLASSES = collector.asUnmodifiable();
        BUILT_IN_TYPE_RESERVED_WORDS = MutableSet.copyOf((Iterable)BUILT_IN_TYPE_CLASSES.keySet().stream().map(String::toLowerCase).collect(Collectors.toList())).asUnmodifiable();
    }

    static class GenericsRecord {
        String baseName;
        List<GenericsRecord> params;

        GenericsRecord(String baseName, List<GenericsRecord> params) {
            this.baseName = baseName;
            this.params = params;
        }

        public String toString() {
            return this.baseName + (!this.params.isEmpty() ? "<" + Strings.join(this.params, (String)",") + ">" : "");
        }

        static class Parser<T> {
            String s;
            BiFunction<String, List<T>, Maybe<T>> baseTypeConverter;
            int index = 0;

            Parser() {
            }

            private void skipWhitespace() {
                while (this.index < this.s.length() && Character.isWhitespace(this.s.charAt(this.index))) {
                    ++this.index;
                }
            }

            Maybe<T> parse(int depth) {
                String baseName;
                int baseNameStart = this.index;
                MutableList params = MutableList.of();
                int baseNameEnd = -1;
                while (this.index < this.s.length()) {
                    char c = this.s.charAt(this.index);
                    if (c == '<') {
                        baseNameEnd = this.index++;
                        do {
                            Maybe<T> pd;
                            if ((pd = this.parse(depth + 1)).isAbsent()) {
                                return pd;
                            }
                            params.add(pd.get());
                            c = this.s.charAt(this.index);
                            ++this.index;
                            this.skipWhitespace();
                        } while (c == ',');
                        if (c == '>') break;
                        return Maybe.absent(() -> new IllegalArgumentException("Invalid type '" + this.s + "': unexpected character preceeding position " + this.index));
                    }
                    if (depth > 0 && (c == ',' || c == '>')) {
                        baseNameEnd = this.index;
                        break;
                    }
                    ++this.index;
                }
                if (depth == 0) {
                    if (this.index < this.s.length()) {
                        return Maybe.absent(() -> new IllegalArgumentException("Invalid type '" + this.s + "': characters not permitted after generics at position " + this.index));
                    }
                    if (baseNameEnd < 0) {
                        baseNameEnd = this.s.length();
                    }
                } else if (this.index >= this.s.length()) {
                    return Maybe.absent(() -> new IllegalArgumentException("Invalid type '" + this.s + "': unterminated generics for argument starting at position " + baseNameStart));
                }
                if ((baseName = this.s.substring(baseNameStart, baseNameEnd).trim()).isEmpty()) {
                    return Maybe.absent(() -> new IllegalArgumentException("Invalid type '" + this.s + "': missing base type name at position " + baseNameStart));
                }
                return this.baseTypeConverter.apply(baseName, params.asUnmodifiable());
            }
        }
    }

    @Beta
    public static final class BetterToStringParameterizedTypeImpl
    implements ParameterizedType {
        private Type raw;
        private Type useOwner;
        private Type[] typeArguments;

        private BetterToStringParameterizedTypeImpl(Class<?> raw, Type useOwner, Type[] typeArguments) {
            this.raw = raw;
            this.useOwner = useOwner;
            this.typeArguments = typeArguments;
        }

        private BetterToStringParameterizedTypeImpl() {
            this(null, null, null);
        }

        private BetterToStringParameterizedTypeImpl(ParameterizedType t) {
            this.raw = t.getRawType();
            this.useOwner = t.getOwnerType();
            this.typeArguments = t.getActualTypeArguments();
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        public Type getOwnerType() {
            return this.useOwner;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getRawType().getTypeName());
            sb.append("<");
            Type[] args = this.getActualTypeArguments();
            if (args.length > 0) {
                sb.append(BetterToStringParameterizedTypeImpl.toString(args[0]));
                for (int i = 1; i < args.length; ++i) {
                    sb.append(",");
                    sb.append(BetterToStringParameterizedTypeImpl.toString(args[i]));
                }
            }
            sb.append(">");
            return sb.toString();
        }

        private static String toString(Type t) {
            if (t instanceof BetterToStringParameterizedTypeImpl) {
                return t.toString();
            }
            if (t instanceof BrooklynJacksonType) {
                return t.getTypeName();
            }
            return TypeUtils.toString((Type)t);
        }

        public boolean equals(Object t) {
            if (t instanceof ParameterizedType) {
                ParameterizedType other = (ParameterizedType)t;
                if (Objects.equals(this.getRawType(), other.getRawType()) && Objects.equals(this.getOwnerType(), other.getOwnerType())) {
                    return Objects.deepEquals(this.getActualTypeArguments(), other.getActualTypeArguments());
                }
            }
            return false;
        }

        public int hashCode() {
            int result = 1136;
            result |= this.raw.hashCode();
            result <<= 4;
            result |= ObjectUtils.hashCode((Object)this.useOwner);
            result <<= 8;
            return result |= Arrays.hashCode(this.typeArguments);
        }

        private void setActualTypeArguments(Type[] typeArguments) {
            this.typeArguments = typeArguments;
        }

        private void setOwnerType(Type useOwner) {
            this.useOwner = useOwner;
        }

        private void setRawType(Type raw) {
            this.raw = raw;
        }

        private void setTypeName(Object ignored) {
        }
    }

    public static class BrooklynTypeNameResolver {
        final String context;
        final ManagementContext mgmt;
        final BrooklynClassLoadingContext loader;
        final boolean allowJavaType;
        final boolean allowRegisteredTypes;
        final Map<String, Function<String, Maybe<TypeToken<?>>>> rules = MutableMap.of();

        public BrooklynTypeNameResolver(String context) {
            this(context, null, null, false, false);
        }

        public BrooklynTypeNameResolver(String context, ManagementContext mgmt) {
            this(context, mgmt, null, false, mgmt != null);
        }

        public BrooklynTypeNameResolver(String context, @Nullable BrooklynClassLoadingContext loader, boolean allowJavaType, boolean allowRegisteredTypes) {
            this(context, loader == null ? null : loader.getManagementContext(), loader, allowJavaType, allowRegisteredTypes);
        }

        public BrooklynTypeNameResolver(String context, @Nullable ManagementContext mgmt, @Nullable BrooklynClassLoadingContext loader, boolean allowJavaType, boolean allowRegisteredTypes) {
            this.context = context;
            Object object = mgmt != null ? mgmt : (this.mgmt = loader != null ? loader.getManagementContext() : null);
            this.loader = loader == null ? (mgmt == null ? null : JavaBrooklynClassLoadingContext.create(mgmt)) : loader;
            this.allowJavaType = allowJavaType;
            this.allowRegisteredTypes = allowRegisteredTypes;
            this.rules.put("simple types (" + Strings.join(BrooklynTypeNameResolution.standardTypesMap().keySet(), (String)", ") + ")", BrooklynTypeNameResolution::getTypeTokenForBuiltInTypeName);
            if (allowJavaType) {
                this.rules.put("Java types visible to bundles", s -> loader.tryLoadClass(s).map(TypeToken::of));
                this.rules.put("Java types", s -> JavaBrooklynClassLoadingContext.create(mgmt).tryLoadClass((String)s).map(TypeToken::of));
            }
            if (allowRegisteredTypes && mgmt != null) {
                this.rules.put("Brooklyn registered types", s -> mgmt.getTypeRegistry().getMaybe(s, RegisteredTypeLoadingContexts.loader(loader)).map(BrooklynJacksonType::asTypeToken));
            }
        }

        Maybe<TypeToken<?>> findTypeTokenOfBaseNameInternal(String s) {
            for (Function<String, Maybe<TypeToken<?>>> r : this.rules.values()) {
                Maybe<TypeToken<?>> candidate = r.apply(s);
                if (!candidate.isPresent()) continue;
                return candidate;
            }
            return Maybe.absent(() -> new IllegalArgumentException("Invalid type for " + this.context + ": '" + s + "' not found in " + this.rules.keySet()));
        }

        public Maybe<TypeToken<?>> findBaseTypeToken(String typeName) {
            typeName = Strings.removeAfter((String)typeName, (String)"<", (boolean)true).trim();
            return this.findTypeTokenOfBaseNameInternal(typeName);
        }

        public TypeToken<?> getTypeToken(String typeName) {
            return (TypeToken)BrooklynTypeNameResolution.parseTypeToken(typeName, bs -> this.findTypeTokenOfBaseNameInternal((String)bs)).get();
        }

        public Maybe<TypeToken<?>> findTypeToken(String typeName) {
            try {
                return BrooklynTypeNameResolution.parseTypeToken(typeName, bs -> this.findTypeTokenOfBaseNameInternal((String)bs));
            }
            catch (Exception e) {
                return Maybe.absent((Throwable)e);
            }
        }
    }
}

