/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.crypto;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.brooklyn.core.internal.BrooklynInitialization;
import org.apache.brooklyn.util.core.crypto.SecureKeys;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;

public class FluentKeySigner {
    protected X500Principal issuerPrincipal;
    protected KeyPair issuerKey;
    protected SecureRandom srand = new SecureRandom();
    protected Date validityStartDate;
    protected Date validityEndDate;
    protected BigInteger serialNumber;
    protected String signatureAlgorithm = "SHA256WithRSAEncryption";
    protected AuthorityKeyIdentifier authorityKeyIdentifier;
    protected X509Certificate authorityCertificate;
    protected Integer numAllowedIntermediateCAs;

    public FluentKeySigner(X500Principal issuerPrincipal, KeyPair issuerKey) {
        this.issuerPrincipal = issuerPrincipal;
        this.issuerKey = issuerKey;
        this.validFromDaysAgo(7L);
        this.validForYears(10L);
    }

    public FluentKeySigner(String issuerCommonName, KeyPair issuerKey) {
        this(SecureKeys.getX500PrincipalWithCommonName((String)issuerCommonName), issuerKey);
    }

    public FluentKeySigner(String issuerCommonName) {
        this(issuerCommonName, SecureKeys.newKeyPair());
    }

    public FluentKeySigner(X509Certificate caCert, KeyPair caKey) {
        this(caCert.getIssuerX500Principal(), caKey);
        this.authorityCertificate(caCert);
    }

    public KeyPair getKey() {
        return this.issuerKey;
    }

    public X500Principal getPrincipal() {
        return this.issuerPrincipal;
    }

    public String getCommonName() {
        return (String)new X509Principal(this.issuerPrincipal.getName()).getValues(X509Name.CN).elementAt(0);
    }

    public X509Certificate getAuthorityCertificate() {
        return this.authorityCertificate;
    }

    public FluentKeySigner ca(int numAllowedIntermediateCAs) {
        this.numAllowedIntermediateCAs = numAllowedIntermediateCAs;
        return this;
    }

    public FluentKeySigner validFromDaysAgo(long days) {
        return this.validFrom(new Date((System.currentTimeMillis() / 86400000L - days) * 1000L * 60L * 60L * 24L));
    }

    public FluentKeySigner validFrom(Date d) {
        this.validityStartDate = d;
        return this;
    }

    public FluentKeySigner validForYears(long years) {
        return this.validUntil(new Date((System.currentTimeMillis() / 86400000L + 365L * years) * 1000L * 60L * 60L * 24L));
    }

    public FluentKeySigner validUntil(Date d) {
        this.validityEndDate = d;
        return this;
    }

    public FluentKeySigner serialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public FluentKeySigner signatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    public FluentKeySigner authorityCertificate(X509Certificate certificate) {
        try {
            this.authorityKeyIdentifier((AuthorityKeyIdentifier)new AuthorityKeyIdentifierStructure(certificate));
            this.authorityCertificate = certificate;
            return this;
        }
        catch (CertificateParsingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public FluentKeySigner authorityKeyIdentifier(AuthorityKeyIdentifier authorityKeyIdentifier) {
        this.authorityKeyIdentifier = authorityKeyIdentifier;
        return this;
    }

    public FluentKeySigner selfsign() {
        if (this.authorityCertificate != null) {
            throw new IllegalStateException("Signer already has certificate");
        }
        this.authorityCertificate(this.newCertificateFor(this.getCommonName(), this.getKey()));
        return this;
    }

    public X509Certificate newCertificateFor(X500Principal subject, PublicKey keyToCertify) {
        try {
            X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
            v3CertGen.setSerialNumber(this.serialNumber != null ? this.serialNumber : BigInteger.valueOf(this.srand.nextLong()).abs().add(BigInteger.ONE));
            v3CertGen.setIssuerDN(this.issuerPrincipal);
            v3CertGen.setNotBefore(this.validityStartDate);
            v3CertGen.setNotAfter(this.validityEndDate);
            v3CertGen.setSignatureAlgorithm(this.signatureAlgorithm);
            v3CertGen.setSubjectDN(subject);
            v3CertGen.setPublicKey(keyToCertify);
            JcaX509ExtensionUtils jcaX509ExtensionUtils = new JcaX509ExtensionUtils();
            v3CertGen.addExtension(X509Extension.subjectKeyIdentifier, false, (ASN1Encodable)jcaX509ExtensionUtils.createSubjectKeyIdentifier(keyToCertify));
            if (this.numAllowedIntermediateCAs != null) {
                v3CertGen.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(this.numAllowedIntermediateCAs.intValue()));
            }
            if (this.authorityKeyIdentifier != null) {
                v3CertGen.addExtension(X509Extension.authorityKeyIdentifier, false, (ASN1Encodable)this.authorityKeyIdentifier);
            }
            X509Certificate pkCertificate = v3CertGen.generate(this.issuerKey.getPrivate(), "BC");
            return pkCertificate;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public X509Certificate newCertificateFor(String commonName, PublicKey key) {
        return this.newCertificateFor(SecureKeys.getX500PrincipalWithCommonName((String)commonName), key);
    }

    public X509Certificate newCertificateFor(String commonName, KeyPair key) {
        return this.newCertificateFor(commonName, key.getPublic());
    }

    static {
        BrooklynInitialization.initSecureKeysBouncyCastleProvider();
    }
}

