/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy;

import com.google.common.base.Objects;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInvokeEffectorPolicy
extends AbstractPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInvokeEffectorPolicy.class);
    public static final ConfigKey<String> IS_BUSY_SENSOR_NAME = ConfigKeys.newStringConfigKey("isBusySensor", "Name of the sensor to publish on the entity that indicates that this policy has incomplete effectors. If unset running tasks will not be tracked.");
    private final AtomicInteger taskCounter = new AtomicInteger();
    private boolean moreUpdatesComing;
    private long mostRecentUpdate = 0L;
    private final Object[] moreUpdatesLock = new Object[0];

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        if (this.isBusySensorEnabled()) {
            this.publishIsBusy();
        }
    }

    protected <T> Task<T> invoke(Effector<T> effector, Map<String, ?> parameters) {
        if (this.isBusySensorEnabled()) {
            this.getTaskCounter().incrementAndGet();
            this.publishIsBusy();
        }
        Task task = this.entity.invoke(effector, parameters);
        if (this.isBusySensorEnabled()) {
            task.addListener((Runnable)new EffectorListener(), Runnable::run);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBusy() {
        Object[] objectArray = this.moreUpdatesLock;
        synchronized (this.moreUpdatesLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getTaskCounter().get() != 0 || this.moreUpdatesComing;
        }
    }

    protected boolean isBusySensorEnabled() {
        return Strings.isNonBlank((CharSequence)this.getIsBusySensorName());
    }

    protected Maybe<Effector<?>> getEffectorNamed(String name) {
        return this.entity.getEntityType().getEffectorByName(name);
    }

    @Nonnull
    protected String getIsBusySensorName() {
        return this.getConfig(IS_BUSY_SENSOR_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> void setMoreUpdatesComing(long eventTimestamp, T eventValue, T current) {
        if (eventTimestamp < this.mostRecentUpdate) return;
        Object[] objectArray = this.moreUpdatesLock;
        synchronized (this.moreUpdatesLock) {
            if (eventTimestamp < this.mostRecentUpdate) return;
            this.moreUpdatesComing = !Objects.equal(eventValue, current);
            this.mostRecentUpdate = eventTimestamp;
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    private AtomicInteger getTaskCounter() {
        return this.taskCounter;
    }

    private void publishIsBusy() {
        boolean busy = this.isBusy();
        LOG.trace("{} taskCount={}, isBusy={}", new Object[]{this, this.getTaskCounter().get(), busy});
        AttributeSensor<Boolean> sensor = Sensors.newBooleanSensor(this.getIsBusySensorName());
        this.entity.sensors().set(sensor, (Object)busy);
    }

    private class EffectorListener
    implements Runnable {
        private EffectorListener() {
        }

        @Override
        public void run() {
            AbstractInvokeEffectorPolicy.this.getTaskCounter().decrementAndGet();
            AbstractInvokeEffectorPolicy.this.publishIsBusy();
        }
    }
}

