/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.byon;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.location.AbstractLocationResolver;
import org.apache.brooklyn.core.mgmt.internal.LocalLocationManager;
import org.apache.brooklyn.location.byon.FixedListMachineProvisioningLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.net.UserAndHostAndPort;
import org.apache.brooklyn.util.text.WildcardGlobs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByonLocationResolver
extends AbstractLocationResolver {
    public static final Logger log = LoggerFactory.getLogger(ByonLocationResolver.class);
    public static final String BYON = "byon";
    public static final ConfigKey<String> OS_FAMILY = ConfigKeys.newStringConfigKey("osFamily", "OS Family of the machine, either windows or linux", "linux");
    public static final Map<String, String> OS_TO_MACHINE_LOCATION_TYPE = ImmutableMap.of((Object)"windows", (Object)"org.apache.brooklyn.location.winrm.WinRmMachineLocation", (Object)"linux", (Object)"org.apache.brooklyn.location.ssh.SshMachineLocation");

    public String getPrefix() {
        return BYON;
    }

    @Override
    protected Class<? extends Location> getLocationType() {
        return FixedListMachineProvisioningLocation.class;
    }

    @Override
    protected AbstractLocationResolver.SpecParser getSpecParser() {
        return new AbstractLocationResolver.SpecParser(this.getPrefix()).setExampleUsage("\"byon(hosts='addr1,addr2')\"");
    }

    @Override
    protected ConfigBag extractConfig(Map<?, ?> locationFlags, String spec, LocationRegistry registry) {
        Object hostAddresses;
        ConfigBag config = super.extractConfig(locationFlags, spec, registry);
        Object hosts = config.getStringKey("hosts");
        config.remove("hosts");
        String user = (String)config.getStringKey("user");
        Integer port = TypeCoercions.coerce(config.getStringKey("port"), Integer.class);
        Class<? extends MachineLocation> locationClass = this.getLocationClass(config.get(OS_FAMILY));
        MutableMap defaultProps = MutableMap.of();
        defaultProps.addIfNotNull((Object)"user", (Object)user);
        defaultProps.addIfNotNull((Object)"port", (Object)port);
        if (hosts instanceof String) {
            hostAddresses = ((String)hosts).isEmpty() ? ImmutableList.of() : WildcardGlobs.getGlobsAfterBraceExpansion((String)("{" + hosts + "}"), (boolean)true, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.NOT_A_SPECIAL_CHAR, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.NOT_A_SPECIAL_CHAR);
        } else if (hosts instanceof Iterable) {
            hostAddresses = ImmutableList.copyOf((Iterable)((Iterable)hosts));
        } else {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; at least one host must be defined");
        }
        if (hostAddresses.isEmpty()) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; at least one host must be defined");
        }
        ArrayList machineSpecs = Lists.newArrayList();
        for (Object host : hostAddresses) {
            LocationSpec<? extends MachineLocation> machineSpec;
            if (host instanceof String) {
                machineSpec = this.parseMachine((String)host, locationClass, (Map<String, ?>)defaultProps, spec);
            } else if (host instanceof Map) {
                machineSpec = this.parseMachine((Map)host, locationClass, (Map<String, ?>)defaultProps, spec);
            } else {
                throw new IllegalArgumentException("Expected machine to be String or Map, but was " + host.getClass().getName() + " (" + host + ")");
            }
            machineSpec.configureIfNotNull(LocalLocationManager.CREATE_UNMANAGED, config.get(LocalLocationManager.CREATE_UNMANAGED));
            machineSpecs.add(machineSpec);
        }
        config.put(FixedListMachineProvisioningLocation.MACHINE_SPECS, machineSpecs);
        return config;
    }

    protected LocationSpec<? extends MachineLocation> parseMachine(Map<String, ?> vals, Class<? extends MachineLocation> locationClass, Map<String, ?> defaults, String specForErrMsg) {
        String host;
        Map<String, Object> valSanitized = Sanitizer.sanitize(vals);
        MutableMap machineConfig = MutableMap.copyOf(vals);
        String osFamily = (String)machineConfig.remove(OS_FAMILY.getName());
        String ssh = (String)machineConfig.remove("ssh");
        String winrm = (String)machineConfig.remove("winrm");
        Map tcpPortMappings = (Map)machineConfig.get("tcpPortMappings");
        Preconditions.checkArgument((boolean)(ssh != null ^ winrm != null), (String)"Must specify exactly one of 'ssh' or 'winrm' for machine: %s", valSanitized);
        UserAndHostAndPort userAndHostAndPort = ssh != null ? this.parseUserAndHostAndPort(ssh, 22) : this.parseUserAndHostAndPort(winrm, vals.get("winrm.useHttps") != null && (Boolean)vals.get("winrm.useHttps") != false ? 5986 : 5985);
        int port = userAndHostAndPort.getHostAndPort().getPort();
        if (tcpPortMappings != null && tcpPortMappings.containsKey(port)) {
            String override = (String)tcpPortMappings.get(port);
            HostAndPort hostAndPortOverride = HostAndPort.fromString((String)override);
            if (!hostAndPortOverride.hasPort()) {
                throw new IllegalArgumentException("Invalid portMapping ('" + override + "') for port " + port + " in " + specForErrMsg);
            }
            port = hostAndPortOverride.getPort();
            host = hostAndPortOverride.getHost().trim();
        } else {
            host = userAndHostAndPort.getHostAndPort().getHost().trim();
        }
        machineConfig.put("address", host);
        try {
            InetAddress.getByName(host);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid host '" + host + "' specified in '" + specForErrMsg + "': " + e);
        }
        if (userAndHostAndPort.getUser() != null) {
            Preconditions.checkArgument((!vals.containsKey("user") ? 1 : 0) != 0, (String)"Must not specify user twice for machine: %s", valSanitized);
            machineConfig.put("user", userAndHostAndPort.getUser());
        }
        if (userAndHostAndPort.getHostAndPort().hasPort()) {
            Preconditions.checkArgument((!vals.containsKey("port") ? 1 : 0) != 0, (String)"Must not specify port twice for machine: %s", valSanitized);
            machineConfig.put("port", port);
        }
        for (Map.Entry<String, ?> entry : defaults.entrySet()) {
            if (machineConfig.containsKey(entry.getKey())) continue;
            machineConfig.put(entry.getKey(), entry.getValue());
        }
        Class<? extends MachineLocation> locationClassHere = locationClass;
        if (osFamily != null) {
            locationClassHere = this.getLocationClass(osFamily);
        }
        return (LocationSpec)LocationSpec.create(locationClassHere).configure((Map)machineConfig);
    }

    private Class<? extends MachineLocation> getLocationClass(String osFamily) {
        try {
            if (osFamily != null) {
                String className = OS_TO_MACHINE_LOCATION_TYPE.get(osFamily.toLowerCase(Locale.ENGLISH));
                return new ClassLoaderUtils((Object)this, this.managementContext).loadClass(className).asSubclass(MachineLocation.class);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    protected LocationSpec<? extends MachineLocation> parseMachine(String val, Class<? extends MachineLocation> locationClass, Map<String, ?> defaults, String specForErrMsg) {
        LinkedHashMap machineConfig = Maps.newLinkedHashMap();
        UserAndHostAndPort userAndHostAndPort = this.parseUserAndHostAndPort(val);
        String host = userAndHostAndPort.getHostAndPort().getHost().trim();
        machineConfig.put("address", host);
        try {
            InetAddress.getByName(host.trim());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid host '" + host + "' specified in '" + specForErrMsg + "': " + e);
        }
        if (userAndHostAndPort.getUser() != null) {
            machineConfig.put("user", userAndHostAndPort.getUser());
        }
        if (userAndHostAndPort.getHostAndPort().hasPort()) {
            machineConfig.put("port", userAndHostAndPort.getHostAndPort().getPort());
        }
        for (Map.Entry<String, ?> entry : defaults.entrySet()) {
            if (machineConfig.containsKey(entry.getKey())) continue;
            machineConfig.put(entry.getKey(), entry.getValue());
        }
        return (LocationSpec)LocationSpec.create(locationClass).configure((Map)machineConfig);
    }

    private UserAndHostAndPort parseUserAndHostAndPort(String val) {
        String userPart = null;
        String hostPart = val;
        if (val.contains("@")) {
            userPart = val.substring(0, val.indexOf("@"));
            hostPart = val.substring(val.indexOf("@") + 1);
        }
        return UserAndHostAndPort.fromParts(userPart, (HostAndPort)HostAndPort.fromString((String)hostPart));
    }

    private UserAndHostAndPort parseUserAndHostAndPort(String val, int defaultPort) {
        UserAndHostAndPort result = this.parseUserAndHostAndPort(val);
        if (!result.getHostAndPort().hasPort()) {
            result = UserAndHostAndPort.fromParts((String)result.getUser(), (String)result.getHostAndPort().getHost(), (int)defaultPort);
        }
        return result;
    }
}

