/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Map Updater", description="Updates an entry in a sensor Map")
public class UpdatingMap<S, TKey, TVal>
extends AbstractEnricher
implements SensorEventListener<S> {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatingMap.class);
    public static final ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer", "The entity with the trigger sensor (defaults to the enricher's entity)");
    @SetFromFlag(value="fromSensor")
    public static final ConfigKey<Sensor<?>> SOURCE_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.sourceSensor", "The sensor whose change triggers re-evaluation of the target value");
    @SetFromFlag(value="targetSensor")
    public static final ConfigKey<Sensor<?>> TARGET_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.targetSensor", "The map-sensor to be updated on the associated entity with the value computed here");
    @SetFromFlag(value="key")
    public static final ConfigKey<Object> KEY_IN_TARGET_SENSOR = ConfigKeys.newConfigKey(Object.class, "enricher.updatingMap.keyInTargetSensor", "Key to update in the target sensor map, defaulting to the name of the source sensor");
    @SetFromFlag(value="computing")
    public static final ConfigKey<Function<?, ?>> COMPUTING = ConfigKeys.newConfigKey(new TypeToken<Function<?, ?>>(){}, "enricher.updatingMap.computing", "The function to evaluate the value, which will to be set in the target map-sensor. See 'removingIfResultIsNull' for how null is handled.");
    @SetFromFlag(value="removingIfResultIsNull")
    public static final ConfigKey<Boolean> REMOVING_IF_RESULT_IS_NULL = ConfigKeys.newBooleanConfigKey("enricher.updatingMap.removingIfResultIsNull", "Whether the key in the target map is removed if the result if the computation is null", Boolean.TRUE);
    protected Entity producer;
    protected AttributeSensor<S> sourceSensor;
    protected AttributeSensor<Map<TKey, TVal>> targetSensor;
    protected TKey key;
    protected Function<S, ? extends TVal> computing;
    protected Boolean removingIfResultIsNull;

    @Override
    public void init() {
        super.init();
        if (Boolean.TRUE.equals(this.getConfig(SUPPRESS_DUPLICATES))) {
            LOG.warn("suppress-duplicates must not be set on " + this + " because map is updated in-place; unsetting config; will always implicitly suppress duplicates");
            this.config().set(SUPPRESS_DUPLICATES, null);
        }
    }

    @Override
    protected <T> void doReconfigureConfig(ConfigKey<T> key, T val) {
        if (key.getName().equals(SUPPRESS_DUPLICATES.getName()) && Boolean.TRUE.equals(val)) {
            throw new UnsupportedOperationException("suppress-duplicates must not be set on " + this + " because map is updated in-place; will always implicitly suppress duplicates");
        }
        super.doReconfigureConfig(key, val);
    }

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.producer = this.getConfig(PRODUCER) == null ? entity : this.getConfig(PRODUCER);
        this.sourceSensor = (AttributeSensor)this.getRequiredConfig(SOURCE_SENSOR);
        this.targetSensor = (AttributeSensor)this.getRequiredConfig(TARGET_SENSOR);
        this.key = this.getConfig(KEY_IN_TARGET_SENSOR);
        this.computing = this.getRequiredConfig(COMPUTING);
        this.removingIfResultIsNull = this.getConfig(REMOVING_IF_RESULT_IS_NULL);
        this.subscriptions().subscribe((Map<String, ?>)ImmutableMap.of((Object)"notifyOfInitialValue", (Object)true), this.producer, this.sourceSensor, this);
        this.highlightTriggers((Sensor<?>)this.sourceSensor, (Object)this.producer);
    }

    public void onEvent(SensorEvent<S> event) {
        this.onUpdated();
    }

    protected void onUpdated() {
        try {
            Object v = this.computing.apply(this.producer.getAttribute(this.sourceSensor));
            if (v == null && Boolean.TRUE.equals(this.removingIfResultIsNull)) {
                v = Entities.REMOVE;
            }
            if (v != Entities.UNCHANGED) {
                Object key = this.key;
                if (key == null) {
                    key = this.sourceSensor.getName();
                }
                ServiceStateLogic.updateMapSensorEntry((Entity)this.entity, this.targetSensor, key, v);
            }
        }
        catch (Throwable t) {
            LOG.warn("Error calculating map update for enricher " + this, t);
            throw Exceptions.propagate((Throwable)t);
        }
    }
}

