/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.brooklyn.util.collections.CollectionMerger;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.QuotedStringTokenizer;
import org.apache.brooklyn.util.text.Strings;

public class ShorthandProcessor {
    private final String template;
    boolean finalMatchRaw = false;
    boolean failOnMismatch = true;

    public ShorthandProcessor(String template) {
        this.template = template;
    }

    public Maybe<Map<String, Object>> process(String input) {
        return new ShorthandProcessorAttempt(this, input).call();
    }

    public ShorthandProcessor withFinalMatchRaw(boolean finalMatchRaw) {
        this.finalMatchRaw = finalMatchRaw;
        return this;
    }

    public ShorthandProcessor withFailOnMismatch(boolean failOnMismatch) {
        this.failOnMismatch = failOnMismatch;
        return this;
    }

    static class ShorthandProcessorAttempt {
        private final List<String> templateTokens;
        private final String inputOriginal;
        private final QuotedStringTokenizer qst;
        private final String template;
        private final ShorthandProcessor options;
        int optionalDepth = 0;
        int optionalSkippingInput = 0;
        private String inputRemaining;
        Map<String, Object> result;
        Consumer<String> valueUpdater;

        ShorthandProcessorAttempt(ShorthandProcessor proc, String input) {
            this.template = proc.template;
            this.options = proc;
            this.qst = this.qst(this.template);
            this.templateTokens = this.qst.remainderAsList();
            this.inputOriginal = input;
        }

        private QuotedStringTokenizer qst(String x) {
            return QuotedStringTokenizer.builder().includeQuotes(true).includeDelimiters(false).expectQuotesDelimited(true).failOnOpenQuote(this.options.failOnMismatch).build(x);
        }

        public synchronized Maybe<Map<String, Object>> call() {
            if (this.result != null) {
                throw new IllegalStateException("Only allowed to use once");
            }
            this.result = MutableMap.of();
            this.inputRemaining = this.inputOriginal;
            Maybe<Object> error = this.doCall();
            if (error.isAbsent()) {
                return Maybe.Absent.castAbsent(error);
            }
            this.inputRemaining = Strings.trimStart((String)this.inputRemaining);
            if (Strings.isNonBlank((CharSequence)this.inputRemaining)) {
                if (this.valueUpdater != null) {
                    QuotedStringTokenizer qstInput = this.qst(this.inputRemaining);
                    this.valueUpdater.accept(this.getRemainderPossiblyRaw(qstInput));
                } else {
                    return Maybe.absent((String)("Input has trailing characters after template is matched: '" + this.inputRemaining + "'"));
                }
            }
            return Maybe.of(this.result);
        }

        protected Maybe<Object> doCall() {
            String t;
            boolean isEndOfOptional = false;
            block0: while (true) {
                String value;
                QuotedStringTokenizer qstInput;
                if (isEndOfOptional) {
                    if (this.optionalDepth <= 0) {
                        throw new IllegalStateException("Unexpected optional block closure");
                    }
                    --this.optionalDepth;
                    if (this.optionalSkippingInput > 0) {
                        return Maybe.of((Object)true);
                    }
                    isEndOfOptional = false;
                }
                if (this.templateTokens.isEmpty()) {
                    if (Strings.isNonBlank((CharSequence)this.inputRemaining) && this.valueUpdater == null) {
                        return Maybe.absent((String)("Input has trailing characters after template is matched: '" + this.inputRemaining + "'"));
                    }
                    if (this.optionalDepth > 0) {
                        return Maybe.absent((String)"Mismatched optional marker in template");
                    }
                    return Maybe.of((Object)true);
                }
                t = this.templateTokens.remove(0);
                if (t.startsWith("[")) {
                    Maybe<Object> cr;
                    if (!(t = t.substring(1)).isEmpty()) {
                        this.templateTokens.add(0, t);
                    }
                    String optionalPresentVar = null;
                    if (!this.templateTokens.isEmpty() && this.templateTokens.get(0).startsWith("?")) {
                        String v = this.templateTokens.remove(0);
                        if (v.startsWith("?${") && v.endsWith("}")) {
                            optionalPresentVar = v.substring(3, v.length() - 1);
                        } else {
                            throw new IllegalStateException("? after [ should indicate optional presence variable using syntax '?${var}', not '" + v + "'");
                        }
                    }
                    if (this.optionalSkippingInput <= 0) {
                        Map backupResult = CollectionMerger.builder().deep(true).build().merge((Map)MutableMap.of(), this.result);
                        Consumer<String> backupValueUpdater = this.valueUpdater;
                        String backupInputRemaining = this.inputRemaining;
                        MutableList backupTemplateTokens = MutableList.copyOf(this.templateTokens);
                        int oldDepth = this.optionalDepth++;
                        int oldSkippingDepth = this.optionalSkippingInput;
                        cr = this.doCall();
                        if (cr.isPresent()) {
                            if (optionalPresentVar == null) continue;
                            this.result.put(optionalPresentVar, true);
                            continue;
                        }
                        this.result = backupResult;
                        this.valueUpdater = backupValueUpdater;
                        if (optionalPresentVar != null) {
                            this.result.put(optionalPresentVar, false);
                        }
                        this.inputRemaining = backupInputRemaining;
                        this.templateTokens.clear();
                        this.templateTokens.addAll((Collection<String>)backupTemplateTokens);
                        this.optionalDepth = oldDepth;
                        this.optionalSkippingInput = oldSkippingDepth;
                        ++this.optionalSkippingInput;
                        ++this.optionalDepth;
                        cr = this.doCall();
                        if (cr.isPresent()) {
                            --this.optionalSkippingInput;
                            continue;
                        }
                    } else {
                        if (optionalPresentVar != null) {
                            this.result.put(optionalPresentVar, false);
                            this.valueUpdater = null;
                        }
                        ++this.optionalDepth;
                        cr = this.doCall();
                        if (cr.isPresent()) continue;
                    }
                    return cr;
                }
                isEndOfOptional = t.endsWith("]");
                if (isEndOfOptional && (t = t.substring(0, t.length() - 1)).isEmpty()) continue;
                if (this.qst.isQuoted(t)) {
                    if (this.optionalSkippingInput > 0) continue;
                    String literal = this.qst.unwrapIfQuoted(t);
                    while (true) {
                        this.inputRemaining = Strings.trimStart((String)this.inputRemaining);
                        if (this.inputRemaining.startsWith(Strings.trimStart((String)literal))) {
                            this.inputRemaining = this.inputRemaining.substring(Strings.trimStart((String)literal).length());
                            continue block0;
                        }
                        if (this.inputRemaining.isEmpty()) {
                            return Maybe.absent((String)("Literal '" + literal + "' expected, when end of input reached"));
                        }
                        if (this.valueUpdater == null) break;
                        qstInput = this.qst(this.inputRemaining);
                        if (!qstInput.hasMoreTokens()) {
                            return Maybe.absent((String)("Literal '" + literal + "' expected, when end of input tokens reached"));
                        }
                        String value2 = this.getNextInputTokenUpToPossibleExpectedLiteral(qstInput, literal);
                        this.valueUpdater.accept(value2);
                    }
                    return Maybe.absent((String)("Literal '" + literal + "' expected, when encountered '" + this.inputRemaining + "'"));
                }
                if (!t.startsWith("${") || !t.endsWith("}")) break;
                if (this.optionalSkippingInput > 0) continue;
                t = t.substring(2, t.length() - 1);
                this.inputRemaining = this.inputRemaining.trim();
                qstInput = this.qst(this.inputRemaining);
                if (!qstInput.hasMoreTokens()) {
                    return Maybe.absent((String)("End of input when looking for variable " + t));
                }
                if (!this.templateTokens.stream().filter(x -> !x.equals("]")).findFirst().isPresent()) {
                    value = this.getRemainderPossiblyRaw(qstInput);
                    this.inputRemaining = "";
                } else {
                    value = this.getNextInputTokenUpToPossibleExpectedLiteral(qstInput, null);
                }
                boolean multiMatch = t.endsWith("...");
                if (multiMatch) {
                    t = Strings.removeFromEnd((String)t, (String)"...");
                }
                String[] keys = t.split("\\.");
                String tt = t;
                this.valueUpdater = v2 -> {
                    Map target = this.result;
                    for (int i = 0; i < keys.length; ++i) {
                        if (!Pattern.compile("[A-Za-z0-9_-]+").matcher(keys[i]).matches()) {
                            throw new IllegalArgumentException("Invalid variable '" + tt + "'");
                        }
                        if (i == keys.length - 1) {
                            target.compute((String)keys[i], (k, v) -> v == null ? v2 : v + " " + v2);
                            continue;
                        }
                        target = (Map)target.compute((String)keys[i], (k, v) -> {
                            if (v == null) {
                                return MutableMap.of();
                            }
                            if (v instanceof Map) {
                                return v;
                            }
                            return Maybe.absent((String)("Cannot process shorthand for " + Arrays.asList(keys) + " because entry '" + k + "' is not a map (" + v + ")"));
                        });
                    }
                };
                this.valueUpdater.accept(value);
                if (multiMatch) continue;
                this.valueUpdater = null;
            }
            return Maybe.absent((String)("Unexpected token in shorthand pattern '" + this.template + "' at position " + (this.template.lastIndexOf(t) + 1)));
        }

        private String getRemainderPossiblyRaw(QuotedStringTokenizer qstInput) {
            String value = Strings.join((Iterable)qstInput.remainderRaw(), (String)"");
            if (!this.options.finalMatchRaw) {
                return qstInput.unwrapIfQuoted(value);
            }
            return value;
        }

        private String getNextInputTokenUpToPossibleExpectedLiteral(QuotedStringTokenizer qstInput, String nextLiteral) {
            String value;
            String v = qstInput.nextToken();
            if (qstInput.isQuoted(v)) {
                value = qstInput.unwrapIfQuoted(v);
                this.inputRemaining = this.inputRemaining.substring(v.length());
            } else {
                boolean isLiteralExpected;
                if (nextLiteral == null) {
                    nextLiteral = this.templateTokens.get(0);
                    if (qstInput.isQuoted(nextLiteral)) {
                        nextLiteral = qstInput.unwrapIfQuoted(nextLiteral);
                        isLiteralExpected = true;
                    } else {
                        isLiteralExpected = false;
                    }
                } else {
                    isLiteralExpected = true;
                }
                if (isLiteralExpected) {
                    int nli = v.indexOf(nextLiteral);
                    if (nli > 0) {
                        value = v.substring(0, nli);
                        this.inputRemaining = this.inputRemaining.substring(value.length());
                    } else {
                        value = v;
                        this.inputRemaining = this.inputRemaining.substring(value.length());
                    }
                } else {
                    value = v;
                    this.inputRemaining = this.inputRemaining.substring(value.length());
                }
            }
            return value;
        }
    }
}

