/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import com.google.common.reflect.TypeToken;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.BasicAttributeSensor;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttributeSensorAndConfigKey<ConfigType, SensorType>
extends BasicAttributeSensor<SensorType>
implements ConfigKey.HasConfigKey<ConfigType> {
    private static final long serialVersionUID = -3103809215973264600L;
    private static final Logger log = LoggerFactory.getLogger(AttributeSensorAndConfigKey.class);
    private ConfigKey<ConfigType> configKey;

    public AttributeSensorAndConfigKey(Class<ConfigType> configType, Class<SensorType> sensorType, String name) {
        this(configType, sensorType, name, name, null);
    }

    public AttributeSensorAndConfigKey(Class<ConfigType> configType, Class<SensorType> sensorType, String name, String description) {
        this(TypeToken.of(configType), TypeToken.of(sensorType), name, description, null);
    }

    public AttributeSensorAndConfigKey(Class<ConfigType> configType, Class<SensorType> sensorType, String name, String description, Object defaultValue) {
        this(TypeToken.of(configType), TypeToken.of(sensorType), name, description, defaultValue);
    }

    public AttributeSensorAndConfigKey(TypeToken<ConfigType> configType, TypeToken<SensorType> sensorType, String name) {
        this(configType, sensorType, name, null);
    }

    public AttributeSensorAndConfigKey(TypeToken<ConfigType> configType, TypeToken<SensorType> sensorType, String name, String description) {
        this(configType, sensorType, name, description, null);
    }

    public AttributeSensorAndConfigKey(TypeToken<ConfigType> configType, TypeToken<SensorType> sensorType, String name, String description, Object defaultValue) {
        super(sensorType, name, description);
        ConfigType defaultValueTyped;
        try {
            defaultValueTyped = TypeCoercions.coerce(defaultValue, configType);
        }
        catch (Exception e) {
            log.warn("Invalid default value '" + defaultValue + "' for " + name + " (rethrowing: " + e, (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        this.configKey = new BasicConfigKey<ConfigType>(configType, name, description, defaultValueTyped);
    }

    public AttributeSensorAndConfigKey(AttributeSensorAndConfigKey<ConfigType, SensorType> orig, ConfigType defaultValue) {
        super(orig.getTypeToken(), orig.getName(), orig.getDescription());
        this.configKey = ConfigKeys.newConfigKeyWithDefault(orig.configKey, TypeCoercions.coerce(defaultValue, orig.configKey.getTypeToken()));
    }

    public AttributeSensorAndConfigKey(BasicConfigKey.Builder<ConfigType, ?> configKeyBuilder, TypeToken<SensorType> sensorType) {
        super(sensorType, configKeyBuilder.getName(), configKeyBuilder.getDescription());
        this.configKey = new BasicConfigKey<ConfigType>(configKeyBuilder);
    }

    public ConfigKey<ConfigType> getConfigKey() {
        return this.configKey;
    }

    public SensorType getAsSensorValue(Entity e) {
        Object sensorValue = e.getAttribute((AttributeSensor)this);
        if (sensorValue != null) {
            return (SensorType)sensorValue;
        }
        Object v = e.config().get((ConfigKey.HasConfigKey)this);
        try {
            return this.convertConfigToSensor(v, e);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Cannot convert config value " + v + " for sensor " + this + ": " + t, t);
        }
    }

    public SensorType getAsSensorValue(ManagementContext managementContext) {
        Object v = managementContext.getConfig().getConfig((ConfigKey.HasConfigKey)this);
        try {
            return this.convertConfigToSensor(v, managementContext);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Cannot convert config value " + v + " for sensor " + this + ": " + t, t);
        }
    }

    protected abstract SensorType convertConfigToSensor(ConfigType var1, Entity var2);

    protected abstract SensorType convertConfigToSensor(ConfigType var1, ManagementContext var2);
}

