/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.StructuredConfigKey;
import org.apache.brooklyn.core.config.internal.AbstractCollectionConfigKey;
import org.apache.brooklyn.util.collections.MutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ListConfigKey<V>
extends AbstractCollectionConfigKey<List<V>, List<Object>, V> {
    private static final long serialVersionUID = 751024268729803210L;
    private static final Logger log = LoggerFactory.getLogger(ListConfigKey.class);

    private static <V> TypeToken<List<V>> typeTokenFor(TypeToken<V> subType) {
        return new TypeToken<List<V>>(){}.where(new TypeParameter<V>(){}, subType);
    }

    public ListConfigKey(Builder<V> builder) {
        super(builder, builder.subType);
    }

    public ListConfigKey(TypeToken<V> subType, String name) {
        this(subType, name, name, null);
    }

    public ListConfigKey(TypeToken<V> subType, String name, String description) {
        this(subType, name, description, null);
    }

    public ListConfigKey(TypeToken<V> subType, String name, String description, List<? extends V> defaultValue) {
        super(ListConfigKey.typeTokenFor(subType), subType, name, description, defaultValue);
    }

    public ListConfigKey(Class<V> subType, String name) {
        this((TypeToken<V>)TypeToken.of(subType), name);
    }

    public ListConfigKey(Class<V> subType, String name, String description) {
        this((TypeToken<V>)TypeToken.of(subType), name, description);
    }

    public ListConfigKey(Class<V> subType, String name, String description, List<? extends V> defaultValue) {
        this(TypeToken.of(subType), name, description, defaultValue);
    }

    @Override
    public String toString() {
        return String.format("%s[ListConfigKey:%s]", this.name, this.getTypeName());
    }

    @Override
    protected List<Object> merge(boolean unmodifiable, Iterable<?> ... sets) {
        MutableList result = MutableList.of();
        for (Iterable<?> set : sets) {
            result.addAll(set);
        }
        if (unmodifiable) {
            return result.asUnmodifiable();
        }
        return result;
    }

    public static class ListModificationBase<T>
    extends ArrayList<T>
    implements ListModification<T> {
        private static final long serialVersionUID = 7131812294560446235L;
        private final boolean clearFirst;

        public ListModificationBase(Collection<T> delegate, boolean clearFirst) {
            super(delegate);
            this.clearFirst = clearFirst;
        }

        @Override
        public Object applyToKeyInMap(ListConfigKey<T> key, Map target) {
            if (this.clearFirst) {
                ListConfigKey<T> clearing = StructuredConfigKey.StructuredModifications.clearing();
                clearing.applyToKeyInMap(key, target);
            }
            for (Object o : this) {
                target.put(key.subKey(), o);
            }
            return null;
        }
    }

    public static class ListModifications
    extends StructuredConfigKey.StructuredModifications {
        public static final <T> ListModification<T> add(T o1, T o2, T ... oo) {
            ArrayList<T> l = new ArrayList<T>();
            l.add(o1);
            l.add(o2);
            for (T o : oo) {
                l.add(o);
            }
            return new ListModificationBase(l, false);
        }

        public static final <T> ListModification<T> addAll(Collection<T> items) {
            return new ListModificationBase<T>(items, false);
        }

        public static final <T> ListModification<T> addItem(T item) {
            return new ListModificationBase<T>(Collections.singletonList(item), false);
        }

        public static final <T> ListModification<T> set(Collection<T> items) {
            return new ListModificationBase<T>(items, true);
        }
    }

    public static interface ListModification<T>
    extends StructuredConfigKey.StructuredModification<ListConfigKey<T>>,
    List<T> {
    }

    public static class Builder<V>
    extends BasicConfigKey.Builder<List<V>, Builder<V>> {
        protected TypeToken<V> subType;

        public Builder(TypeToken<V> subType, String name) {
            super(ListConfigKey.typeTokenFor(subType), name);
            this.subType = (TypeToken)Preconditions.checkNotNull(subType);
        }

        public Builder(Class<V> subType, String name) {
            this((TypeToken<V>)TypeToken.of(subType), name);
        }

        public Builder(ListConfigKey<V> key) {
            this(key.getName(), key);
        }

        public Builder(String newName, ListConfigKey<V> key) {
            super(newName, key);
            this.subType = ((ListConfigKey)key).getSubTypeToken();
        }

        @Override
        public Builder<V> self() {
            return this;
        }

        @Override
        @Deprecated
        public Builder<V> name(String val) {
            throw new UnsupportedOperationException("Builder must be constructed with name");
        }

        @Override
        @Deprecated
        public Builder<V> type(Class<List<V>> val) {
            throw new UnsupportedOperationException("Builder must be constructed with type");
        }

        @Override
        @Deprecated
        public Builder<V> type(TypeToken<List<V>> val) {
            throw new UnsupportedOperationException("Builder must be constructed with type");
        }

        @Override
        public ListConfigKey<V> build() {
            return new ListConfigKey(this);
        }
    }
}

