/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.classloading.BrooklynClassLoadingContextSequential;
import org.apache.brooklyn.core.mgmt.classloading.JavaBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.classloading.OsgiBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.rebind.RebindManagerImpl;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.typereg.BasicManagedBundle;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.core.typereg.RegisteredTypeNaming;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Time;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogUtils {
    private static final Logger log = LoggerFactory.getLogger(CatalogUtils.class);
    public static final char VERSION_DELIMITER = ':';

    public static BrooklynClassLoadingContext newClassLoadingContext(ManagementContext mgmt, CatalogItem<?, ?> item) {
        if (item.getLibraries() == null) {
            log.debug("CatalogItemDtoAbstract.getLibraries() is null.", (Throwable)new Exception("Trace for null CatalogItemDtoAbstract.getLibraries()"));
        }
        return CatalogUtils.newClassLoadingContext(mgmt, item.getId(), item.getLibraries());
    }

    public static BrooklynClassLoadingContext newClassLoadingContext(ManagementContext mgmt, RegisteredType item) {
        return CatalogUtils.newClassLoadingContext(mgmt, item.getId(), item.getLibraries(), null);
    }

    @Beta
    public static BrooklynClassLoadingContext newClassLoadingContext(ManagementContext mgmt, RegisteredType item, BrooklynClassLoadingContext loader) {
        return CatalogUtils.newClassLoadingContext(mgmt, item.getId(), item.getLibraries(), loader);
    }

    public static BrooklynClassLoadingContext getClassLoadingContext(Entity entity) {
        ManagementContext mgmt = ((EntityInternal)entity).getManagementContext();
        String catId = entity.getCatalogItemId();
        if (Strings.isBlank((CharSequence)catId)) {
            return JavaBrooklynClassLoadingContext.create(mgmt);
        }
        Maybe<RegisteredType> cat = RegisteredTypes.tryValidate(mgmt.getTypeRegistry().get(catId), RegisteredTypeLoadingContexts.spec(Entity.class));
        if (cat.isNull()) {
            log.warn("Cannot load " + catId + " to get classloader for " + entity + "; will try with standard loader, but might fail subsequently");
            return JavaBrooklynClassLoadingContext.create(mgmt);
        }
        return CatalogUtils.newClassLoadingContext(mgmt, (RegisteredType)cat.get(), JavaBrooklynClassLoadingContext.create(mgmt));
    }

    public static BrooklynClassLoadingContext newClassLoadingContext(@Nullable ManagementContext mgmt, String catalogItemId, Collection<? extends OsgiBundleWithUrl> libraries) {
        return CatalogUtils.newClassLoadingContext(mgmt, catalogItemId, libraries, JavaBrooklynClassLoadingContext.create(mgmt));
    }

    @Deprecated
    private static BrooklynClassLoadingContext newClassLoadingContext(@Nullable ManagementContext mgmt, String catalogItemId, Collection<? extends OsgiBundleWithUrl> libraries, BrooklynClassLoadingContext loader) {
        BrooklynClassLoadingContext threadLocalLoader;
        BrooklynClassLoadingContextSequential result = new BrooklynClassLoadingContextSequential(mgmt, new BrooklynClassLoadingContext[0]);
        if (libraries != null && !libraries.isEmpty()) {
            result.add(new OsgiBrooklynClassLoadingContext(mgmt, catalogItemId, libraries));
        }
        if (loader != null) {
            result.add(loader);
        }
        if ((threadLocalLoader = BasicBrooklynCatalog.BrooklynLoaderTracker.getLoader()) != null) {
            result.add(threadLocalLoader);
        }
        result.addSecondary(JavaBrooklynClassLoadingContext.create(mgmt));
        return result;
    }

    public static BrooklynClassLoadingContext newClassLoadingContextForCatalogItems(ManagementContext managementContext, String primaryItemId, List<String> searchPath) {
        return CatalogUtils.newClassLoadingContextForCatalogItems(managementContext, primaryItemId, searchPath, false);
    }

    public static BrooklynClassLoadingContext newClassLoadingContextForCatalogItems(ManagementContext managementContext, String primaryItemId, List<String> searchPath, boolean omitPrimaryIfContainedInSearchPath) {
        BrooklynClassLoadingContextSequential seqLoader = new BrooklynClassLoadingContextSequential(managementContext, new BrooklynClassLoadingContext[0]);
        MutableSet path = MutableSet.copyOf(searchPath);
        if (!(primaryItemId == null || omitPrimaryIfContainedInSearchPath && searchPath.contains(primaryItemId))) {
            CatalogUtils.addSearchItem(managementContext, seqLoader, primaryItemId, false);
            path.remove(primaryItemId);
        }
        for (String searchId : path) {
            CatalogUtils.addSearchItem(managementContext, seqLoader, searchId, true);
        }
        return seqLoader;
    }

    public static void installLibraries(ManagementContext managementContext, @Nullable Collection<CatalogItem.CatalogBundle> libraries) {
        CatalogUtils.installLibraries(managementContext, libraries, true);
    }

    public static void installLibraries(ManagementContext managementContext, @Nullable Collection<CatalogItem.CatalogBundle> libraries, boolean startBundlesAndInstallToBrooklyn) {
        if (libraries == null) {
            return;
        }
        ManagementContextInternal mgmt = (ManagementContextInternal)managementContext;
        if (!libraries.isEmpty()) {
            Maybe<OsgiManager> osgi = mgmt.getOsgiManager();
            if (osgi.isAbsent()) {
                throw new IllegalStateException("Unable to load bundles " + libraries + " because OSGi is not running.");
            }
            if (log.isDebugEnabled()) {
                CatalogUtils.logDebugOrTraceIfRebinding(log, "Loading bundles in {}: {}", managementContext, Joiner.on((String)", ").join(libraries));
            }
            Stopwatch timer = Stopwatch.createStarted();
            MutableList results = MutableList.of();
            for (CatalogItem.CatalogBundle bundle : libraries) {
                ReferenceWithError<OsgiBundleInstallationResult> result = ((OsgiManager)osgi.get()).installDeferredStart(BasicManagedBundle.of(bundle), null, true);
                if (log.isDebugEnabled()) {
                    CatalogUtils.logDebugOrTraceIfRebinding(log, "Installation of library " + bundle + ": " + result, new Object[0]);
                }
                if (result.hasError()) {
                    throw Exceptions.propagateAnnotated((String)("Error installing " + bundle), (Throwable)result.getError());
                }
                results.add(result.get());
            }
            MutableMap errors = MutableMap.of();
            if (startBundlesAndInstallToBrooklyn) {
                for (OsgiBundleInstallationResult r : results) {
                    if (r.getDeferredStart() == null) continue;
                    try {
                        r.getDeferredStart().run();
                    }
                    catch (Throwable t) {
                        Exceptions.propagateIfFatal((Throwable)t);
                        errors.put(r.getVersionedName().toString(), t);
                    }
                }
            }
            if (!errors.isEmpty()) {
                CatalogUtils.logDebugOrTraceIfRebinding(log, "Tried registering {} libraries, {} succeeded, but failed {} (throwing)", libraries.size(), libraries.size() - errors.size(), errors.keySet());
                if (errors.size() == 1) {
                    throw Exceptions.propagateAnnotated((String)("Error starting referenced library in Brooklyn bundle " + (String)Iterables.getOnlyElement(errors.keySet())), (Throwable)((Throwable)Iterables.getOnlyElement(errors.values())));
                }
                throw Exceptions.create((String)("Error starting referenced libraries in Brooklyn bundles " + errors.keySet()), errors.values());
            }
            if (log.isDebugEnabled()) {
                CatalogUtils.logDebugOrTraceIfRebinding(log, "Registered {} bundle{} in {}", libraries.size(), Strings.s((int)libraries.size()), Time.makeTimeStringRounded((Stopwatch)timer));
            }
        }
    }

    public static String getCatalogItemIdFromLoader(BrooklynClassLoadingContext loader) {
        if (loader instanceof OsgiBrooklynClassLoadingContext) {
            return ((OsgiBrooklynClassLoadingContext)loader).getCatalogItemId();
        }
        return null;
    }

    public static void setCatalogItemIdOnAddition(Entity entity, BrooklynObject itemBeingAdded) {
        if (entity.getCatalogItemId() != null) {
            if (itemBeingAdded.getCatalogItemId() == null) {
                if (log.isDebugEnabled()) {
                    BrooklynLogging.log(log, BrooklynLogging.levelDebugOrTraceIfReadOnly(entity), "Entity " + entity + " from " + entity.getCatalogItemId() + " applying its catalog item ID to " + itemBeingAdded, new Object[0]);
                }
                BrooklynObjectInternal addInternal = (BrooklynObjectInternal)itemBeingAdded;
                addInternal.setCatalogItemIdAndSearchPath(entity.getCatalogItemId(), entity.getCatalogItemIdSearchPath());
            } else if (!itemBeingAdded.getCatalogItemId().equals(entity.getCatalogItemId())) {
                log.debug("Blueprint for " + entity + " from " + entity.getCatalogItemId() + " includes " + itemBeingAdded + " from other catalog " + itemBeingAdded.getCatalogItemId());
            }
        } else if (itemBeingAdded.getCatalogItemId() != null && log.isDebugEnabled()) {
            BrooklynLogging.log(log, BrooklynLogging.levelDebugOrTraceIfReadOnly(entity), "Catalog item addition: " + entity + " without catalog item ID has " + itemBeingAdded + " from " + itemBeingAdded.getCatalogItemId(), new Object[0]);
        }
    }

    @Beta
    public static void logDebugOrTraceIfRebinding(Logger log, String message, Object ... args) {
        if (RebindManagerImpl.RebindTracker.isRebinding()) {
            log.trace(message, args);
        } else {
            log.debug(message, args);
        }
    }

    @Deprecated
    public static boolean looksLikeVersionedId(String versionedId) {
        if (versionedId == null) {
            return false;
        }
        int fi = versionedId.indexOf(58);
        if (fi < 0) {
            return false;
        }
        int li = versionedId.lastIndexOf(58);
        if (li != fi) {
            return false;
        }
        String candidateVersion = versionedId.substring(li + 1);
        if (!candidateVersion.matches("[0-9]+(|(\\.|_).*)")) {
            return false;
        }
        if (!RegisteredTypeNaming.isUsableTypeColonVersion(versionedId)) {
            log.warn("Reference '" + versionedId + "' is being treated as a versioned type but it contains deprecated characters (slashes or whitespace); likely to be unsupported in future versions.");
        }
        return true;
    }

    public static String getSymbolicNameFromVersionedId(String versionedId) {
        if (versionedId == null) {
            return null;
        }
        int versionDelimiterPos = versionedId.lastIndexOf(58);
        if (versionDelimiterPos != -1) {
            return versionedId.substring(0, versionDelimiterPos);
        }
        return null;
    }

    public static String getVersionFromVersionedId(String versionedId) {
        if (versionedId == null) {
            return null;
        }
        int versionDelimiterPos = versionedId.lastIndexOf(58);
        if (versionDelimiterPos != -1) {
            return versionedId.substring(versionDelimiterPos + 1);
        }
        return null;
    }

    public static String getVersionedId(String id, String version) {
        return id + ':' + version;
    }

    @Deprecated
    public static CatalogItem<?, ?> getCatalogItemOptionalVersion(ManagementContext mgmt, String versionedId) {
        if (versionedId == null) {
            return null;
        }
        if (CatalogUtils.looksLikeVersionedId(versionedId)) {
            String id = CatalogUtils.getSymbolicNameFromVersionedId(versionedId);
            String version = CatalogUtils.getVersionFromVersionedId(versionedId);
            return mgmt.getCatalog().getCatalogItem(id, version);
        }
        return mgmt.getCatalog().getCatalogItem(versionedId, "0.0.0_DEFAULT_VERSION");
    }

    public static boolean isBestVersion(ManagementContext mgmt, CatalogItem<?, ?> item) {
        RegisteredType best = RegisteredTypes.getBestVersion(mgmt.getTypeRegistry().getMatching(RegisteredTypePredicates.symbolicName(item.getSymbolicName())));
        if (best == null) {
            return false;
        }
        return best.getVersion().equals(item.getVersion());
    }

    @Deprecated
    public static void setDeprecated(ManagementContext mgmt, String symbolicNameAndOptionalVersion, boolean newValue) {
        RegisteredType item = mgmt.getTypeRegistry().get(symbolicNameAndOptionalVersion);
        Preconditions.checkNotNull((Object)item, (Object)("No such item: " + symbolicNameAndOptionalVersion));
        CatalogUtils.setDeprecated(mgmt, item.getSymbolicName(), item.getVersion(), newValue);
    }

    @Deprecated
    public static void setDisabled(ManagementContext mgmt, String symbolicNameAndOptionalVersion, boolean newValue) {
        RegisteredType item = mgmt.getTypeRegistry().get(symbolicNameAndOptionalVersion);
        Preconditions.checkNotNull((Object)item, (Object)("No such item: " + symbolicNameAndOptionalVersion));
        CatalogUtils.setDisabled(mgmt, item.getSymbolicName(), item.getVersion(), newValue);
    }

    @Deprecated
    public static void setDeprecated(ManagementContext mgmt, String symbolicName, String version, boolean newValue) {
        RegisteredType type;
        CatalogItem item = mgmt.getCatalog().getCatalogItem(symbolicName, version);
        if (item != null) {
            item.setDeprecated(newValue);
            mgmt.getCatalog().persist(item);
        }
        if ((type = mgmt.getTypeRegistry().get(symbolicName, version)) != null) {
            RegisteredTypes.setDeprecated(type, newValue);
        } else if (item == null) {
            throw new NoSuchElementException(symbolicName + ":" + version);
        }
    }

    @Deprecated
    public static void setDisabled(ManagementContext mgmt, String symbolicName, String version, boolean newValue) {
        RegisteredType type;
        CatalogItem item = mgmt.getCatalog().getCatalogItem(symbolicName, version);
        if (item != null) {
            item.setDisabled(newValue);
            mgmt.getCatalog().persist(item);
        }
        if ((type = mgmt.getTypeRegistry().get(symbolicName, version)) != null) {
            RegisteredTypes.setDisabled(type, newValue);
        } else if (item == null) {
            throw new NoSuchElementException(symbolicName + ":" + version);
        }
    }

    private static void addSearchItem(ManagementContext managementContext, BrooklynClassLoadingContextSequential loader, String itemId, boolean warnIfNotFound) {
        RegisteredType item;
        ManagedBundle bundle;
        OsgiManager osgi = (OsgiManager)((ManagementContextInternal)managementContext).getOsgiManager().orNull();
        boolean didSomething = false;
        if (osgi != null && (bundle = osgi.getManagedBundle(VersionedName.fromString((String)itemId))) != null) {
            loader.add(CatalogUtils.newClassLoadingContext(managementContext, itemId, (Collection<? extends OsgiBundleWithUrl>)MutableSet.of((Object)bundle)));
            didSomething = true;
        }
        if ((item = managementContext.getTypeRegistry().get(itemId)) != null) {
            BrooklynClassLoadingContext itemLoader = CatalogUtils.newClassLoadingContext(managementContext, item);
            loader.add(itemLoader);
            didSomething = true;
        }
        if (!didSomething) {
            if (warnIfNotFound) {
                log.warn("Can't find catalog item " + itemId + " when searching; a search path may be incomplete and other errors may follow");
            } else {
                log.trace("Can't find catalog item " + itemId + " when searching; ignoring as this can be normal in setup/scans, but it can also mean a search path may be incomplete and other errors may follow");
            }
        }
    }

    public static String[] bundleIds(Bundle bundle) {
        return new String[]{String.valueOf(bundle.getBundleId()), bundle.getSymbolicName(), bundle.getVersion().toString()};
    }
}

