/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.filters;

import com.google.common.base.Optional;
import com.google.common.reflect.Invokable;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.annotations.ApiVersionOverride;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public final class FormSignerUtils {
    private FormSignerUtils() {
    }

    public static Optional<String> getAnnotatedApiVersion(HttpRequest request) {
        if (request instanceof GeneratedHttpRequest) {
            GeneratedHttpRequest generatedRequest = (GeneratedHttpRequest)request;
            return FormSignerUtils.getAnnotatedApiVersion(generatedRequest.getInvocation());
        }
        return Optional.absent();
    }

    private static Optional<String> getAnnotatedApiVersion(Invocation invocation) {
        Invokable invokable = invocation.getInvokable();
        if (invokable.isAnnotationPresent(ApiVersionOverride.class)) {
            return Optional.fromNullable((Object)((ApiVersionOverride)invokable.getAnnotation(ApiVersionOverride.class)).value());
        }
        Class owner = invokable.getOwnerType().getRawType();
        if (owner.isAnnotationPresent(ApiVersionOverride.class)) {
            return Optional.fromNullable((Object)owner.getAnnotation(ApiVersionOverride.class).value());
        }
        return Optional.absent();
    }
}

