/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;

public class Item {
    @Nullable
    protected final String uuid;
    protected final String name;
    protected final Set<String> tags;
    protected final Map<String, String> userMetadata;

    public Item(@Nullable String uuid, String name, Iterable<String> tags, Map<String, String> userMetadata) {
        this.uuid = uuid;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.tags = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(tags, (Object)"tags")));
        this.userMetadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(userMetadata, (Object)"userMetadata")));
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.userMetadata == null ? 0 : this.userMetadata.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return !(this.userMetadata == null ? other.userMetadata != null : !this.userMetadata.equals(other.userMetadata));
    }

    public String toString() {
        return "[uuid=" + this.uuid + ", name=" + this.name + ", tags=" + this.tags + ", userMetadata=" + this.userMetadata + "]";
    }

    public static class Builder {
        protected String uuid;
        protected String name;
        protected Set<String> tags = ImmutableSet.of();
        protected Map<String, String> userMetadata = ImmutableMap.of();

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder tags(Iterable<String> tags) {
            this.tags = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this;
        }

        public Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(userMetadata, (Object)"userMetadata")));
            return this;
        }

        public Item build() {
            return new Item(this.uuid, this.name, this.tags, this.userMetadata);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
            result = 31 * result + (this.userMetadata == null ? 0 : this.userMetadata.hashCode());
            result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
                return false;
            }
            if (this.userMetadata == null ? other.userMetadata != null : !this.userMetadata.equals(other.userMetadata)) {
                return false;
            }
            return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
        }
    }
}

