/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.rest.domain.EntitySummary;
import org.apache.brooklyn.rest.domain.LocationSummary;
import org.apache.brooklyn.rest.domain.RelationSummary;
import org.apache.brooklyn.rest.domain.TaskSummary;

@Path(value="/applications/{application}/entities")
@Api(value="Entities")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface EntityApi {
    @GET
    @ApiOperation(value="Fetch the list of children entities directly under the root of an application", response=EntitySummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<EntitySummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1);

    @GET
    @Path(value="/{entity}")
    @ApiOperation(value="Fetch details of an entity", response=EntitySummary.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public EntitySummary get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @GET
    @ApiOperation(value="Fetch the list of children of an entity", response=EntitySummary.class)
    @Path(value="/{entity}/children")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<EntitySummary> getChildren(@PathParam(value="application") String var1, @PathParam(value="entity") String var2);

    @GET
    @ApiOperation(value="Fetch the list of relations of an entity", response=RelationSummary.class)
    @Path(value="/{entity}/relations")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<RelationSummary> getRelations(@PathParam(value="application") String var1, @PathParam(value="entity") String var2);

    @POST
    @ApiOperation(value="Add a child or children to this entity given a YAML spec", response=TaskSummary.class)
    @Consumes(value={"application/x-yaml", "text/yaml", "text/x-yaml", "application/yaml", "application/json"})
    @Path(value="/{entity}/children")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response addChildren(@PathParam(value="application") String var1, @PathParam(value="entity") String var2, @ApiParam(name="start", value="Whether to automatically start this child; if omitted, true for Startable entities") @QueryParam(value="start") Boolean var3, @ApiParam(name="timeout", value="Delay before server should respond with incomplete activity task, rather than completed task: 'never' means block until complete; '0' means return task immediately; and e.g. '20ms' (the default) will wait 20ms for completed task information to be available", required=false, defaultValue="20ms") @QueryParam(value="timeout") String var4, @ApiParam(name="childrenSpec", value="Entity spec in CAMP YAML format (including 'services' root element)", required=true) String var5);

    @GET
    @Path(value="/{entity}/activities")
    @ApiOperation(value="Fetch list of tasks for this entity")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<TaskSummary> listTasks(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Max number of tasks, or -1 for all (default 200)", required=false) @QueryParam(value="limit") @DefaultValue(value="200") int var3, @ApiParam(value="Whether to include subtasks recursively across different entities (default false)", required=false) @QueryParam(value="recurse") @DefaultValue(value="false") Boolean var4, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var5);

    @GET
    @Path(value="/{entity}/activities/{task}")
    @ApiOperation(value="Fetch task details", response=TaskSummary.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find application, entity or task"), @ApiResponse(code=500, message="Internal Server Error")})
    @Produces(value={"text/json"})
    public TaskSummary getTask(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Task ID", required=true) @PathParam(value="task") String var3, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var4);

    @GET
    @ApiOperation(value="Returns an icon for the entity, if defined")
    @Path(value="/{entity}/icon")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response getIcon(@PathParam(value="application") String var1, @PathParam(value="entity") String var2);

    @GET
    @Path(value="/{entity}/tags")
    @ApiOperation(value="Fetch list of tags on this entity")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<Object> listTags(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @POST
    @Path(value="/{entity}/tag/add")
    @ApiOperation(value="Add a tag on this entity")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public void addTag(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Tag to add", required=true) Object var3);

    @POST
    @Path(value="/{entity}/tag/delete")
    @ApiOperation(value="Delete a tag on this entity, returning whether the tag was found (and deleted)")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public boolean deleteTag(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Tag to delete", required=true) Object var3);

    @POST
    @Path(value="/{entity}/tag/upsert/{tagKey}")
    @ApiOperation(value="Inserts a tag which is a single-key map with the given key (path parameter) and value (post body), removing any existing tag matching the key")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public void upsertTag(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="tagKey") String var3, @ApiParam(value="Tag map value to upsert for the given key", required=true) Object var4);

    @GET
    @Path(value="/{entity}/tag/get/{tagKey}")
    @ApiOperation(value="Returns the tag value for a tag which is a single-key map with the given key, or null (not 404 for missing tag key)")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public Object getTag(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="tagKey") String var3);

    @POST
    @ApiOperation(value="Rename an entity")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Undefined application or entity"), @ApiResponse(code=500, message="Internal Server Error")})
    @Path(value="/{entity}/name")
    public Response rename(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="New name for this entity", required=true) @QueryParam(value="name") String var3);

    @POST
    @ApiOperation(value="Expunge an entity", response=TaskSummary.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    @Path(value="/{entity}/expunge")
    public Response expunge(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Whether to gracefully release all resources (failing and keeping if unsuccessful)", required=true) @QueryParam(value="release") boolean var3);

    @GET
    @Path(value="/{entity}/descendants")
    @ApiOperation(value="Fetch entity info for all (or filtered) descendants", response=EntitySummary.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<EntitySummary> getDescendants(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Regular expression for an entity type which must be matched", required=false) @DefaultValue(value=".*") @QueryParam(value="typeRegex") String var3);

    @GET
    @Path(value="/{entity}/descendants/sensor/{sensor}")
    @ApiOperation(value="Fetch values of a given sensor for all (or filtered) descendants")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public Map<String, Object> getDescendantsSensor(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String var3, @ApiParam(value="Regular expression applied to filter descendant entities based on their type", required=false) @DefaultValue(value=".*") @QueryParam(value="typeRegex") String var4, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var5);

    @GET
    @Path(value="/{entity}/locations")
    @ApiOperation(value="List the locations set on the entity")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<LocationSummary> getLocations(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @GET
    @Path(value="/{entity}/spec")
    @ApiOperation(value="Get the YAML spec used to create the entity, if available")
    @Produces(value={"text/x-yaml", "application/x-yaml", "text/yaml", "text/plain", "application/yaml", "text/plain"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public String getSpec(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @GET
    @Path(value="/{entity}/speclist")
    @ApiOperation(value="Get the list of YAML spec used to create the entity, if available")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<Object> getSpecList(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @GET
    @Path(value="/{entity}/workflows")
    @ApiOperation(value="Get all workflows stored on this entity", response=WorkflowExecutionContext.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response getWorkflows(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var3);

    @GET
    @Path(value="/{entity}/workflows/{workflowId}")
    @ApiOperation(value="Get a workflow on this entity", response=WorkflowExecutionContext.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response getWorkflow(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Workflow ID", required=true) @PathParam(value="workflowId") String var3, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var4);

    @DELETE
    @Path(value="/{entity}/workflows/{workflowId}")
    @ApiOperation(value="Delete a workflow on this entity, causing it not to be retained. Not supported for ongoing workflows (cancel first).", response=WorkflowExecutionContext.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response deleteWorkflow(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Workflow ID", required=true) @PathParam(value="workflowId") String var3, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var4);

    @POST
    @ApiOperation(value="Run a workflow on this entity from a YAML workflow spec", response=TaskSummary.class)
    @Consumes(value={"application/x-yaml", "text/yaml", "text/x-yaml", "application/yaml", "application/json"})
    @Path(value="/{entity}/workflows")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public TaskSummary runWorkflow(@PathParam(value="application") String var1, @PathParam(value="entity") String var2, @ApiParam(name="timeout", value="Delay before server should respond with incomplete activity task, rather than completed task: 'never' means block until complete; '0' means return task immediately; and e.g. '20ms' (the default) will wait 20ms for completed task information to be available", required=false, defaultValue="20ms") @QueryParam(value="timeout") String var3, @ApiParam(name="workflowSpec", value="Workflow spec in YAML (including 'steps' root element with a list of steps)", required=true) String var4);

    @POST
    @Path(value="/{entity}/workflows/{workflowId}/replay/from/{step}")
    @ApiOperation(value="Replays a workflow from the given step, or 'start' to restart, 'last' to use the last replay point, or 'end' to replay resuming; returns the task of the replay")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public TaskSummary replayWorkflow(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Workflow ID", required=true) @PathParam(value="workflowId") String var3, @ApiParam(value="step", required=true) @PathParam(value="step") String var4, @ApiParam(value="reason", required=false) @QueryParam(value="reason") String var5, @ApiParam(value="force", required=false) @QueryParam(value="force") Boolean var6);
}

