/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jclouds.docker.util.StdStreamData;

public final class DockerInputStream
extends DataInputStream {
    public DockerInputStream(InputStream in) {
        super(in);
    }

    public StdStreamData readStdStreamData() throws IOException {
        byte[] header = new byte[8];
        if (-1 == this.read(header, 0, 1)) {
            return null;
        }
        this.readFully(header, 1, 7);
        long size = (long)(header[4] & 0xFF) << 24 | (long)((header[5] & 0xFF) << 16) | (long)((header[6] & 0xFF) << 8) | (long)(header[7] & 0xFF);
        byte[] payload = new byte[(int)Math.min(Integer.MAX_VALUE, size)];
        this.readFully(payload);
        boolean truncated = false;
        if (size > Integer.MAX_VALUE) {
            truncated = true;
            this.readFully(new byte[(int)(size - Integer.MAX_VALUE)]);
        }
        return new StdStreamData(header[0], payload, truncated);
    }
}

