/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.handlers;

import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import org.jclouds.b2.B2ResponseException;
import org.jclouds.b2.domain.B2Error;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.rest.ResourceNotFoundException;

public final class ParseB2ErrorFromJsonContent
extends ParseJson<B2Error>
implements HttpErrorHandler {
    @Inject
    ParseB2ErrorFromJsonContent(Json json) {
        super(json, TypeLiteral.get(B2Error.class));
    }

    private static Exception refineException(B2Error error, Exception exception) {
        if ("bad_bucket_id".equals(error.code())) {
            return new ContainerNotFoundException((Throwable)exception);
        }
        if ("bad_json".equals(error.code())) {
            return new IllegalArgumentException(error.message(), exception);
        }
        if ("bad_request".equals(error.code())) {
            return new IllegalArgumentException(error.message(), exception);
        }
        if ("file_not_present".equals(error.code())) {
            return new KeyNotFoundException((Throwable)exception);
        }
        if ("not_found".equals(error.code())) {
            return new ResourceNotFoundException(error.message(), (Throwable)exception);
        }
        return exception;
    }

    public void handleError(HttpCommand command, HttpResponse response) {
        B2Error error = (B2Error)this.apply(response);
        Exception exception = ParseB2ErrorFromJsonContent.refineException(error, (Exception)((Object)new B2ResponseException(command, response, error)));
        command.setException(exception);
    }
}

