/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.apidoc;

import io.swagger.annotations.Api;
import io.swagger.config.Scanner;
import io.swagger.config.ScannerFactory;
import io.swagger.config.SwaggerConfig;
import io.swagger.jaxrs.config.AbstractScanner;
import io.swagger.jaxrs.config.JaxrsScanner;
import io.swagger.jaxrs.config.SwaggerScannerLocator;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.refs.RefFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;

public class RestApiResourceScanner
extends AbstractScanner
implements JaxrsScanner,
SwaggerConfig {
    private boolean scannerDirty = true;
    private final Set<Class<?>> globalClasses = new HashSet();
    private final Map<Application, Set<Class<?>>> appCache = new WeakHashMap();

    private RestApiResourceScanner() {
    }

    private RestApiResourceScanner(Collection<Class<?>> resourceClasses) {
        this.addAnnotatedClasses(this.globalClasses, resourceClasses);
    }

    private void addAnnotatedClasses(Collection<Class<?>> classes) {
        this.addAnnotatedClasses(this.globalClasses, classes);
    }

    private void addAnnotatedClasses(Set<Class<?>> output, Collection<Class<?>> classes) {
        if (classes != null) {
            for (Class<?> clz : classes) {
                if (clz.getAnnotation(Api.class) != null) {
                    output.add(clz);
                }
                this.addAnnotatedClasses(output, Arrays.asList(clz.getInterfaces()));
            }
        }
    }

    private synchronized Set<Class<?>> buildApiClasses(Application app) {
        Set<Class<?>> cached = this.appCache.get(app);
        if (cached == null) {
            cached = new HashSet();
            if (app != null) {
                Set singletons;
                Set classes = app.getClasses();
                if (classes != null) {
                    this.addAnnotatedClasses(cached, classes);
                }
                if ((singletons = app.getSingletons()) != null) {
                    for (Object o : singletons) {
                        this.addAnnotatedClasses(cached, Arrays.asList(o.getClass()));
                    }
                }
            }
            this.appCache.put(app, cached);
        }
        return cached;
    }

    public Set<Class<?>> classesFromContext(Application app, ServletConfig sc) {
        HashSet all = new HashSet(this.globalClasses);
        all.addAll(this.buildApiClasses(app));
        return all;
    }

    public Set<Class<?>> classes() {
        return new HashSet();
    }

    public Swagger configure(Swagger swagger) {
        swagger.setBasePath("/v1");
        swagger.setSchemes(Collections.singletonList(Scheme.HTTPS));
        swagger.info(this.getSwaggerInfo());
        ApiKeyAuthDefinition security = new ApiKeyAuthDefinition();
        String apiKeyName = "JWT";
        security.setName(apiKeyName);
        security.setIn(In.HEADER);
        security.setType("apiKey");
        swagger.addSecurityDefinition(apiKeyName, (SecuritySchemeDefinition)security);
        BasicAuthDefinition basicAuthDefinition = new BasicAuthDefinition();
        swagger.addSecurityDefinition("Basic authentication", (SecuritySchemeDefinition)basicAuthDefinition);
        this.fixIncorrectDefinitions(swagger);
        return swagger;
    }

    private void fixIncorrectDefinitions(Swagger swagger) {
        ArrayProperty arrayProp;
        Property trickyProp = (Property)((Model)swagger.getDefinitions().get("TypeToken")).getProperties().get("types");
        if ("array".equals(trickyProp.getType()) && (arrayProp = (ArrayProperty)trickyProp).getItems() == null) {
            arrayProp.setItems((Property)new RefProperty("#/definitions/TypeToken", RefFormat.INTERNAL));
        }
    }

    private Info getSwaggerInfo() {
        Info info = new Info();
        info.setTitle("Apache Brooklyn API");
        info.setVersion(((Object)((Object)this)).getClass().getPackage() != null ? ((Object)((Object)this)).getClass().getPackage().getImplementationVersion() : "");
        info.setDescription("API specification for Apache Brooklyn");
        return info;
    }

    public String getFilterClass() {
        return null;
    }

    public static synchronized void install(Collection<Class<?>> resourceClasses) {
        Object scanner = ScannerFactory.getScanner();
        if (scanner instanceof RestApiResourceScanner) {
            ((RestApiResourceScanner)((Object)scanner)).addAnnotatedClasses(resourceClasses);
        } else {
            scanner = new RestApiResourceScanner(resourceClasses);
        }
        ScannerFactory.setScanner((Scanner)scanner);
        SwaggerScannerLocator.getInstance().putScanner("swagger.scanner.id.default", scanner);
        ((RestApiResourceScanner)ScannerFactory.getScanner()).scannerDirty = true;
    }

    public static void rescanIfNeeded(Runnable r) {
        if (ScannerFactory.getScanner() instanceof RestApiResourceScanner && ((RestApiResourceScanner)ScannerFactory.getScanner()).scannerDirty) {
            r.run();
            ((RestApiResourceScanner)ScannerFactory.getScanner()).scannerDirty = false;
        }
    }
}

