/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.azureblob.blobstore.functions.AzureBlobToBlob;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.blobstore.binders.BindUserMetadataToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.rest.Binder;

public class BindAzureBlobMetadataToMultipartRequest
implements Binder {
    private final AzureBlobToBlob azureBlob2Blob;
    private final BindUserMetadataToHeadersWithPrefix blobBinder;

    @Inject
    BindAzureBlobMetadataToMultipartRequest(AzureBlobToBlob azureBlob2Blob, BindUserMetadataToHeadersWithPrefix blobBinder) {
        this.azureBlob2Blob = azureBlob2Blob;
        this.blobBinder = blobBinder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        String contentType;
        String contentLanguage;
        String contentEncoding;
        String contentDisposition;
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof AzureBlob), (Object)"this binder is only valid for AzureBlobs!");
        Preconditions.checkNotNull(request, (Object)"request");
        AzureBlob blob = (AzureBlob)AzureBlob.class.cast(input);
        Preconditions.checkArgument((blob.getPayload().getContentMetadata().getContentLength() != null && blob.getPayload().getContentMetadata().getContentLength() >= 0L ? 1 : 0) != 0, (Object)"size must be set");
        ImmutableMap.Builder headers = ImmutableMap.builder();
        MutableContentMetadata contentMetadata = blob.getProperties().getContentMetadata();
        String cacheControl = contentMetadata.getCacheControl();
        if (cacheControl != null) {
            headers.put((Object)"x-ms-blob-cache-control", (Object)cacheControl);
        }
        if ((contentDisposition = contentMetadata.getContentDisposition()) != null) {
            headers.put((Object)"x-ms-blob-content-disposition", (Object)contentDisposition);
        }
        if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
            headers.put((Object)"x-ms-blob-content-encoding", (Object)contentEncoding);
        }
        if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
            headers.put((Object)"x-ms-blob-content-language", (Object)contentLanguage);
        }
        if ((contentType = contentMetadata.getContentType()) != null) {
            headers.put((Object)"x-ms-blob-content-type", (Object)contentType);
        }
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)Multimaps.forMap((Map)headers.build()))).build();
        return (R)this.blobBinder.bindToRequest(request, (Object)this.azureBlob2Blob.apply(blob));
    }
}

