/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.brooklyn.entity.machine;

import static org.testng.Assert.assertNotNull;
import static org.testng.Assert.assertTrue;

import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.entity.AbstractEc2LiveTest;
import org.apache.brooklyn.entity.machine.MachineEntity;
import org.apache.brooklyn.test.Asserts;
import org.testng.annotations.Test;

import com.google.common.collect.ImmutableList;

public class MachineEntityEc2LiveTest extends AbstractEc2LiveTest {

    @Override
    protected void doTest(Location loc) throws Exception {
        final MachineEntity server = app.createAndManageChild(EntitySpec.create(MachineEntity.class));
        
        app.start(ImmutableList.of(loc));
        
        Asserts.succeedsEventually(new Runnable() {
            @Override public void run() {
                assertNotNull(server.getAttribute(MachineAttributes.UPTIME));
                assertNotNull(server.getAttribute(MachineAttributes.LOAD_AVERAGE));
                assertNotNull(server.getAttribute(MachineAttributes.CPU_USAGE));
                assertNotNull(server.getAttribute(MachineAttributes.FREE_MEMORY));
                assertNotNull(server.getAttribute(MachineAttributes.TOTAL_MEMORY));
                assertNotNull(server.getAttribute(MachineAttributes.USED_MEMORY));
            }});
        
        String result = server.execCommand("MY_ENV=myval && echo start $MY_ENV");
        assertTrue(result.contains("start myval"), "result="+result);
    }
    
    @Test(enabled=false)
    public void testDummy() {} // Convince testng IDE integration that this really does have test methods
}
