/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.cloud.names;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.location.cloud.names.BasicCloudMachineNamer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.text.Strings;

public class CustomMachineNamer
extends BasicCloudMachineNamer {
    public static final ConfigKey<String> MACHINE_NAME_TEMPLATE = ConfigKeys.newStringConfigKey("custom.machine.namer.machine", "Freemarker template format for custom machine name", "${entity.displayName}");
    public static final ConfigKey<Map<String, ?>> EXTRA_SUBSTITUTIONS = ConfigKeys.newConfigKey(new TypeToken<Map<String, ?>>(){}, "custom.machine.namer.substitutions", "Additional substitutions to be used in the template", ImmutableMap.of());

    @Override
    protected String generateNewIdOfLength(ConfigBag setup, int len) {
        Object context = setup.peek(CloudLocationConfig.CALLER_CONTEXT);
        Entity entity = null;
        if (context instanceof Entity) {
            entity = (Entity)context;
        }
        String template = setup.get(MACHINE_NAME_TEMPLATE);
        String processed = entity == null ? TemplateProcessor.processTemplateContents(template, setup.get(EXTRA_SUBSTITUTIONS)) : TemplateProcessor.processTemplateContents(template, (EntityInternal)entity, setup.get(EXTRA_SUBSTITUTIONS));
        processed = Strings.removeFromStart((String)processed, (String)"#ftl\n");
        return CustomMachineNamer.sanitize(processed);
    }
}

