/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.RouteIngress;
import io.fabric8.openshift.api.model.RouteIngressCondition;
import io.fabric8.openshift.api.model.RouteIngressConditionBuilder;
import io.fabric8.openshift.api.model.RouteIngressConditionFluentImpl;
import io.fabric8.openshift.api.model.RouteIngressFluent;
import java.util.ArrayList;
import java.util.List;

public class RouteIngressFluentImpl<A extends RouteIngressFluent<A>>
extends BaseFluent<A>
implements RouteIngressFluent<A> {
    private List<VisitableBuilder<? extends RouteIngressCondition, ?>> conditions = new ArrayList();
    private String host;
    private String routerName;

    public RouteIngressFluentImpl() {
    }

    public RouteIngressFluentImpl(RouteIngress instance) {
        this.withConditions(instance.getConditions());
        this.withHost(instance.getHost());
        this.withRouterName(instance.getRouterName());
    }

    @Override
    public A addToConditions(RouteIngressCondition ... items) {
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(RouteIngressCondition ... items) {
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<RouteIngressCondition> getConditions() {
        return RouteIngressFluentImpl.build(this.conditions);
    }

    @Override
    public A withConditions(List<RouteIngressCondition> conditions) {
        this._visitables.removeAll(this.conditions);
        this.conditions.clear();
        if (conditions != null) {
            for (RouteIngressCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(RouteIngressCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (RouteIngressCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> addNewConditionLike(RouteIngressCondition item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public String getRouterName() {
        return this.routerName;
    }

    @Override
    public A withRouterName(String routerName) {
        this.routerName = routerName;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteIngressFluentImpl that = (RouteIngressFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return !(this.routerName != null ? !this.routerName.equals(that.routerName) : that.routerName != null);
    }

    public class ConditionsNestedImpl<N>
    extends RouteIngressConditionFluentImpl<RouteIngressFluent.ConditionsNested<N>>
    implements RouteIngressFluent.ConditionsNested<N>,
    Nested<N> {
        private final RouteIngressConditionBuilder builder;

        ConditionsNestedImpl(RouteIngressCondition item) {
            this.builder = new RouteIngressConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.builder = new RouteIngressConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteIngressFluentImpl.this.addToConditions(this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

