/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.system_service;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.objs.HasShortName;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.cloud.names.AbstractCloudMachineNamer;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.system_service.SystemServiceEnricher;
import org.apache.brooklyn.entity.system_service.SystemServiceInstaller;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.SshPutTaskWrapper;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;

public class InitdServiceInstaller
implements SystemServiceInstaller {
    private static final ConfigKey<String> SERVICE_TEMPLATE = ConfigKeys.newStringConfigKey((String)"service.initd.service_template", (String)"URL of the template to be used as the /etc/init.d service", (String)"classpath:///org/apache/brooklyn/entity/system_service/service.sh");
    private final Entity entity;
    private final Enricher enricher;

    public InitdServiceInstaller(Entity entity, Enricher enricher) {
        this.entity = (Entity)Preconditions.checkNotNull((Object)entity, (Object)"entity");
        this.enricher = (Enricher)Preconditions.checkNotNull((Object)enricher, (Object)"enricher");
    }

    @Override
    public Task<?> getServiceInstallTask() {
        ResourceUtils resource = new ResourceUtils((Object)this);
        String pidFile = (String)this.entity.getAttribute(SoftwareProcess.PID_FILE);
        String template = resource.getResourceAsString((String)this.enricher.config().get(SERVICE_TEMPLATE));
        String serviceName = this.getServiceName();
        SshMachineLocation sshMachine = EffectorTasks.getSshMachine((Entity)this.entity);
        MutableMap params = MutableMap.of((Object)"service.launch_script", (Object)Os.mergePaths((String[])new String[]{this.getRunDir(), this.getStartScriptName()}), (Object)"service.name", (Object)serviceName, (Object)"service.user", (Object)sshMachine.getUser(), (Object)"service.log_path", (Object)this.getLogLocation());
        if (pidFile != null) {
            params.put("service.pid_file", pidFile);
        }
        String service = TemplateProcessor.processTemplateContents((String)template, (EntityInternal)((EntityInternal)this.entity), (Map)params);
        String tmpServicePath = Os.mergePaths((String[])new String[]{this.getRunDir(), serviceName});
        String servicePath = "/etc/init.d/" + serviceName;
        SshPutTaskWrapper putServiceTask = SshTasks.newSshPutTaskFactory((SshMachineLocation)sshMachine, (String)tmpServicePath).contents(service).newTask();
        ProcessTaskWrapper installServiceTask = (ProcessTaskWrapper)SshTasks.newSshExecTaskFactory((SshMachineLocation)sshMachine, (String[])new String[]{BashCommands.chain((String[])new String[]{BashCommands.sudo((String)("mv " + tmpServicePath + " " + servicePath)), BashCommands.sudo((String)("chmod 0755 " + servicePath)), BashCommands.sudo((String)("chkconfig --add " + serviceName)), BashCommands.sudo((String)("chkconfig " + serviceName + " on"))})}).requiringExitCodeZero().newTask();
        return Tasks.builder().displayName("install (init.d)").description("Install init.d service").add((TaskAdaptable)putServiceTask).add((TaskAdaptable)installServiceTask).build();
    }

    private String getServiceName() {
        String serviceNameTemplate = (String)this.enricher.config().get(SystemServiceEnricher.SERVICE_NAME);
        return serviceNameTemplate.replace("${id}", this.entity.getId()).replace("${entity_name}", this.getEntityName());
    }

    private CharSequence getEntityName() {
        String name = this.entity instanceof HasShortName ? ((HasShortName)this.entity).getShortName() : (this.entity instanceof Entity ? this.entity.getDisplayName() : "brooklyn-service");
        return AbstractCloudMachineNamer.sanitize((String)name.toString()).toLowerCase();
    }

    private String getStartScriptName() {
        return (String)this.enricher.config().get(SystemServiceEnricher.LAUNCH_SCRIPT_NAME);
    }

    private String getRunDir() {
        return (String)this.entity.getAttribute(SoftwareProcess.RUN_DIR);
    }

    private String getLogLocation() {
        String logFileLocation = (String)this.entity.getAttribute(Attributes.LOG_FILE_LOCATION);
        if (logFileLocation != null) {
            return new File(logFileLocation).getParent();
        }
        return "/tmp";
    }
}

