/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import org.ops4j.pax.logging.PaxLoggingManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

public class FrameworkHandler
implements SynchronousBundleListener,
FrameworkListener,
ServiceListener {
    private final PaxLoggingManager m_manager;
    private final int loggingLevel;

    public FrameworkHandler(BundleContext context, PaxLoggingManager manager) {
        this.m_manager = manager;
        String levelName = "DEBUG";
        if (!"".equals(System.getProperty("org.ops4j.pax.logging.service.frameworkEventsLogLevel", "").trim())) {
            levelName = System.getProperty("org.ops4j.pax.logging.service.frameworkEventsLogLevel");
        } else if (!"".equals(context.getProperty("org.ops4j.pax.logging.service.frameworkEventsLogLevel"))) {
            levelName = context.getProperty("org.ops4j.pax.logging.service.frameworkEventsLogLevel");
        }
        this.loggingLevel = FrameworkHandler.convertLevel(levelName);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        String message;
        int type = bundleEvent.getType();
        switch (type) {
            case 1: {
                message = "BundleEvent INSTALLED";
                break;
            }
            case 2: {
                message = "BundleEvent STARTED";
                break;
            }
            case 4: {
                message = "BundleEvent STOPPED";
                break;
            }
            case 8: {
                message = "BundleEvent UPDATED";
                break;
            }
            case 16: {
                message = "BundleEvent UNINSTALLED";
                break;
            }
            case 32: {
                message = "BundleEvent RESOLVED";
                break;
            }
            case 64: {
                message = "BundleEvent UNRESOLVED";
                break;
            }
            case 128: {
                message = "BundleEvent STARTING";
                break;
            }
            case 256: {
                message = "BundleEvent STOPPING";
                break;
            }
            default: {
                message = "BundleEvent [unknown: " + type + "]";
            }
        }
        Bundle bundle = bundleEvent.getBundle();
        if (this.loggingLevel > 0) {
            this.doLog(this.loggingLevel, bundle, "org.osgi.framework.BundleEvent", message, null);
        }
    }

    public void frameworkEvent(FrameworkEvent frameworkEvent) {
        String message;
        int type = frameworkEvent.getType();
        int level = this.loggingLevel;
        switch (type) {
            case 2: {
                message = "FrameworkEvent ERROR";
                level = 1;
                break;
            }
            case 32: {
                message = "FrameworkEvent INFO";
                level = 3;
                break;
            }
            case 4: {
                message = "FrameworkEvent PACKAGES REFRESHED";
                break;
            }
            case 1: {
                message = "FrameworkEvent STARTED";
                break;
            }
            case 8: {
                message = "FrameworkEvent STARTLEVEL CHANGED";
                break;
            }
            case 16: {
                message = "FrameworkEvent WARNING";
                level = 2;
                break;
            }
            default: {
                message = "FrameworkEvent [unknown:" + type + "]";
            }
        }
        Bundle bundle = frameworkEvent.getBundle();
        Throwable exception = frameworkEvent.getThrowable();
        if (this.loggingLevel > 0) {
            this.doLog(this.loggingLevel, bundle, "org.osgi.framework.FrameworkEvent", message, exception);
        }
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        String message;
        ServiceReference serviceRef = serviceEvent.getServiceReference();
        int type = serviceEvent.getType();
        switch (type) {
            case 2: {
                message = "ServiceEvent MODIFIED";
                break;
            }
            case 1: {
                message = "ServiceEvent REGISTERED";
                break;
            }
            case 4: {
                message = "ServiceEvent UNREGISTERING";
                break;
            }
            default: {
                message = "ServiceEvent [unknown:" + type + "]";
            }
        }
        message = message + " - " + serviceRef;
        Bundle bundle = serviceRef.getBundle();
        if (this.loggingLevel > 0) {
            this.doLog(this.loggingLevel, bundle, "org.osgi.framework.ServiceEvent", message, null);
        }
    }

    private void doLog(int loggingLevel, Bundle bundle, String category, String message, Throwable exception) {
        if (loggingLevel <= 0) {
            return;
        }
        switch (loggingLevel) {
            case 1: {
                this.m_manager.getLogger(bundle, category, "").error(message, null);
                break;
            }
            case 2: {
                this.m_manager.getLogger(bundle, category, "").warn(message, null);
                break;
            }
            case 3: {
                this.m_manager.getLogger(bundle, category, "").inform(message, null);
                break;
            }
            case 4: {
                this.m_manager.getLogger(bundle, category, "").debug(message, null);
                break;
            }
        }
    }

    private static int convertLevel(String levelName) {
        if ("DEBUG".equalsIgnoreCase(levelName)) {
            return 4;
        }
        if ("INFO".equalsIgnoreCase(levelName)) {
            return 3;
        }
        if ("WARN".equalsIgnoreCase(levelName) || "WARNING".equalsIgnoreCase(levelName)) {
            return 2;
        }
        if ("ERROR".equalsIgnoreCase(levelName)) {
            return 1;
        }
        if ("DISABLED".equalsIgnoreCase(levelName)) {
            return 0;
        }
        return 4;
    }
}

