/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.rest.filter.BrooklynSecurityProviderFilterHelper;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;
import org.apache.brooklyn.rest.util.ManagementContextProvider;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynSecurityProviderFilterJavax
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(BrooklynSecurityProviderFilterJavax.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        log.trace("BrooklynSecurityProviderFilterJavax.init");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block3: {
            try {
                log.trace("BrooklynSecurityProviderFilterJavax.doFilter {}", (Object)request);
                ManagementContext mgmt = new ManagementContextProvider(request.getServletContext()).getManagementContext();
                Preconditions.checkNotNull((Object)mgmt, (Object)"Brooklyn management context not available; cannot authenticate");
                new BrooklynSecurityProviderFilterHelper().run((HttpServletRequest)request, mgmt);
                chain.doFilter(request, response);
            }
            catch (SecurityProvider.SecurityProviderDeniedAuthentication e) {
                log.trace("BrooklynSecurityProviderFilterJavax.doFilter caught SecurityProviderDeniedAuthentication", (Throwable)e);
                HttpServletResponse rout = (HttpServletResponse)response;
                Response rin = e.getResponse();
                if (rin == null) {
                    rin = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                rout.setStatus(rin.getStatus());
                rin.getHeaders().forEach((k, v) -> v.forEach(v2 -> rout.addHeader(k, Strings.toString((Object)v2))));
                Object body = rin.getEntity();
                if (body == null) break block3;
                response.getWriter().write(Strings.toString((Object)body));
                response.getWriter().flush();
            }
        }
    }

    public void destroy() {
        log.trace("BrooklynSecurityProviderFilterJavax.destroy");
    }
}

