/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.filters;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.BaseEncoding;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.location.Provider;

@Singleton
public class BasicAuthentication
implements HttpRequestFilter {
    private final Supplier<Credentials> creds;

    @Inject
    public BasicAuthentication(@Provider Supplier<Credentials> creds) {
        this.creds = (Supplier)Preconditions.checkNotNull(creds, (Object)"creds");
    }

    public static String basic(String user, String password) {
        return "Basic " + BaseEncoding.base64().encode(String.format("%s:%s", Preconditions.checkNotNull((Object)user, (Object)"user"), Preconditions.checkNotNull((Object)password, (Object)"password")).getBytes(Charsets.UTF_8));
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Credentials currentCreds = (Credentials)Preconditions.checkNotNull((Object)this.creds.get(), (Object)"credential supplier returned null");
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", BasicAuthentication.basic(currentCreds.identity, currentCreds.credential))).build();
    }
}

