// @generated by protobuf-ts 2.1.0 with parameter client_grpc1,generate_dependencies
// @generated from protobuf file "schema.proto" (package "org.apache.beam.model.pipeline.v1", syntax proto3)
// tslint:disable
//
//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//
// ** Experimental **
// Protocol Buffers describing Beam Schemas, a portable representation for
// complex types.
//
// The primary application of Schema is as the payload for the standard coder
// "beam:coder:row:v1", defined in beam_runner_api.proto
//
import type { BinaryWriteOptions } from "@protobuf-ts/runtime";
import type { IBinaryWriter } from "@protobuf-ts/runtime";
import { WireType } from "@protobuf-ts/runtime";
import type { BinaryReadOptions } from "@protobuf-ts/runtime";
import type { IBinaryReader } from "@protobuf-ts/runtime";
import { UnknownFieldHandler } from "@protobuf-ts/runtime";
import type { PartialMessage } from "@protobuf-ts/runtime";
import { reflectionMergePartial } from "@protobuf-ts/runtime";
import { MESSAGE_TYPE } from "@protobuf-ts/runtime";
import { MessageType } from "@protobuf-ts/runtime";
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Schema
 */
export interface Schema {
    /**
     * List of fields for this schema. Two fields may not share a name.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.Field fields = 1;
     */
    fields: Field[];
    /**
     * REQUIRED. An RFC 4122 UUID.
     *
     * @generated from protobuf field: string id = 2;
     */
    id: string;
    /**
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.Option options = 3;
     */
    options: Option[];
    /**
     * Indicates that encoding positions have been overridden.
     *
     * @generated from protobuf field: bool encoding_positions_set = 4;
     */
    encodingPositionsSet: boolean;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Field
 */
export interface Field {
    /**
     * REQUIRED. Name of this field within the schema.
     *
     * @generated from protobuf field: string name = 1;
     */
    name: string;
    /**
     * OPTIONAL. Human readable description of this field, such as the query that generated it.
     *
     * @generated from protobuf field: string description = 2;
     */
    description: string;
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldType type = 3;
     */
    type?: FieldType;
    /**
     * @generated from protobuf field: int32 id = 4;
     */
    id: number;
    /**
     * OPTIONAL. The position of this field's data when encoded, e.g. with beam:coder:row:v1.
     * Either no fields in a given row are have encoding position populated,
     * or all of them are. Used to support backwards compatibility with schema
     * changes.
     * If no fields have encoding position populated the order of encoding is the same as the order in the Schema.
     * If this Field is part of a Schema where encoding_positions_set is True then encoding_position must be
     * defined, otherwise this field is ignored.
     *
     * @generated from protobuf field: int32 encoding_position = 5;
     */
    encodingPosition: number;
    /**
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.Option options = 6;
     */
    options: Option[];
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.FieldType
 */
export interface FieldType {
    /**
     * @generated from protobuf field: bool nullable = 1;
     */
    nullable: boolean;
    /**
     * @generated from protobuf oneof: type_info
     */
    typeInfo: {
        oneofKind: "atomicType";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.AtomicType atomic_type = 2;
         */
        atomicType: AtomicType;
    } | {
        oneofKind: "arrayType";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ArrayType array_type = 3;
         */
        arrayType: ArrayType;
    } | {
        oneofKind: "iterableType";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.IterableType iterable_type = 4;
         */
        iterableType: IterableType;
    } | {
        oneofKind: "mapType";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.MapType map_type = 5;
         */
        mapType: MapType;
    } | {
        oneofKind: "rowType";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.RowType row_type = 6;
         */
        rowType: RowType;
    } | {
        oneofKind: "logicalType";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.LogicalType logical_type = 7;
         */
        logicalType: LogicalType;
    } | {
        oneofKind: undefined;
    };
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ArrayType
 */
export interface ArrayType {
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldType element_type = 1;
     */
    elementType?: FieldType;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.IterableType
 */
export interface IterableType {
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldType element_type = 1;
     */
    elementType?: FieldType;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.MapType
 */
export interface MapType {
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldType key_type = 1;
     */
    keyType?: FieldType;
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldType value_type = 2;
     */
    valueType?: FieldType;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.RowType
 */
export interface RowType {
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Schema schema = 1;
     */
    schema?: Schema;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.LogicalType
 */
export interface LogicalType {
    /**
     * @generated from protobuf field: string urn = 1;
     */
    urn: string;
    /**
     * @generated from protobuf field: bytes payload = 2;
     */
    payload: Uint8Array;
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldType representation = 3;
     */
    representation?: FieldType;
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldType argument_type = 4;
     */
    argumentType?: FieldType;
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldValue argument = 5;
     */
    argument?: FieldValue;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Option
 */
export interface Option {
    /**
     * REQUIRED. Identifier for the option.
     *
     * @generated from protobuf field: string name = 1;
     */
    name: string;
    /**
     * REQUIRED. Type specifer for the structure of value.
     * Conventionally, options that don't require additional configuration should
     * use a boolean type, with the value set to true.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldType type = 2;
     */
    type?: FieldType;
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldValue value = 3;
     */
    value?: FieldValue;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Row
 */
export interface Row {
    /**
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.FieldValue values = 1;
     */
    values: FieldValue[];
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.FieldValue
 */
export interface FieldValue {
    /**
     * @generated from protobuf oneof: field_value
     */
    fieldValue: {
        oneofKind: "atomicValue";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.AtomicTypeValue atomic_value = 1;
         */
        atomicValue: AtomicTypeValue;
    } | {
        oneofKind: "arrayValue";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ArrayTypeValue array_value = 2;
         */
        arrayValue: ArrayTypeValue;
    } | {
        oneofKind: "iterableValue";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.IterableTypeValue iterable_value = 3;
         */
        iterableValue: IterableTypeValue;
    } | {
        oneofKind: "mapValue";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.MapTypeValue map_value = 4;
         */
        mapValue: MapTypeValue;
    } | {
        oneofKind: "rowValue";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Row row_value = 5;
         */
        rowValue: Row;
    } | {
        oneofKind: "logicalTypeValue";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.LogicalTypeValue logical_type_value = 6;
         */
        logicalTypeValue: LogicalTypeValue;
    } | {
        oneofKind: undefined;
    };
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.AtomicTypeValue
 */
export interface AtomicTypeValue {
    /**
     * @generated from protobuf oneof: value
     */
    value: {
        oneofKind: "byte";
        /**
         * @generated from protobuf field: int32 byte = 1;
         */
        byte: number;
    } | {
        oneofKind: "int16";
        /**
         * @generated from protobuf field: int32 int16 = 2;
         */
        int16: number;
    } | {
        oneofKind: "int32";
        /**
         * @generated from protobuf field: int32 int32 = 3;
         */
        int32: number;
    } | {
        oneofKind: "int64";
        /**
         * @generated from protobuf field: int64 int64 = 4;
         */
        int64: bigint;
    } | {
        oneofKind: "float";
        /**
         * @generated from protobuf field: float float = 5;
         */
        float: number;
    } | {
        oneofKind: "double";
        /**
         * @generated from protobuf field: double double = 6;
         */
        double: number;
    } | {
        oneofKind: "string";
        /**
         * @generated from protobuf field: string string = 7;
         */
        string: string;
    } | {
        oneofKind: "boolean";
        /**
         * @generated from protobuf field: bool boolean = 8;
         */
        boolean: boolean;
    } | {
        oneofKind: "bytes";
        /**
         * @generated from protobuf field: bytes bytes = 9;
         */
        bytes: Uint8Array;
    } | {
        oneofKind: undefined;
    };
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ArrayTypeValue
 */
export interface ArrayTypeValue {
    /**
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.FieldValue element = 1;
     */
    element: FieldValue[];
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.IterableTypeValue
 */
export interface IterableTypeValue {
    /**
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.FieldValue element = 1;
     */
    element: FieldValue[];
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.MapTypeValue
 */
export interface MapTypeValue {
    /**
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.MapTypeEntry entries = 1;
     */
    entries: MapTypeEntry[];
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.MapTypeEntry
 */
export interface MapTypeEntry {
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldValue key = 1;
     */
    key?: FieldValue;
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldValue value = 2;
     */
    value?: FieldValue;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.LogicalTypeValue
 */
export interface LogicalTypeValue {
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FieldValue value = 1;
     */
    value?: FieldValue;
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.AtomicType
 */
export enum AtomicType {
    /**
     * @generated from protobuf enum value: UNSPECIFIED = 0;
     */
    UNSPECIFIED = 0,
    /**
     * @generated from protobuf enum value: BYTE = 1;
     */
    BYTE = 1,
    /**
     * @generated from protobuf enum value: INT16 = 2;
     */
    INT16 = 2,
    /**
     * @generated from protobuf enum value: INT32 = 3;
     */
    INT32 = 3,
    /**
     * @generated from protobuf enum value: INT64 = 4;
     */
    INT64 = 4,
    /**
     * @generated from protobuf enum value: FLOAT = 5;
     */
    FLOAT = 5,
    /**
     * @generated from protobuf enum value: DOUBLE = 6;
     */
    DOUBLE = 6,
    /**
     * @generated from protobuf enum value: STRING = 7;
     */
    STRING = 7,
    /**
     * @generated from protobuf enum value: BOOLEAN = 8;
     */
    BOOLEAN = 8,
    /**
     * @generated from protobuf enum value: BYTES = 9;
     */
    BYTES = 9
}
// @generated message type with reflection information, may provide speed optimized methods
class Schema$Type extends MessageType<Schema> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Schema", [
            { no: 1, name: "fields", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => Field },
            { no: 2, name: "id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "options", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => Option },
            { no: 4, name: "encoding_positions_set", kind: "scalar", T: 8 /*ScalarType.BOOL*/ }
        ]);
    }
    create(value?: PartialMessage<Schema>): Schema {
        const message = { fields: [], id: "", options: [], encodingPositionsSet: false };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Schema>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Schema): Schema {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.pipeline.v1.Field fields */ 1:
                    message.fields.push(Field.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* string id */ 2:
                    message.id = reader.string();
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.Option options */ 3:
                    message.options.push(Option.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* bool encoding_positions_set */ 4:
                    message.encodingPositionsSet = reader.bool();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Schema, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.pipeline.v1.Field fields = 1; */
        for (let i = 0; i < message.fields.length; i++)
            Field.internalBinaryWrite(message.fields[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* string id = 2; */
        if (message.id !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.id);
        /* repeated org.apache.beam.model.pipeline.v1.Option options = 3; */
        for (let i = 0; i < message.options.length; i++)
            Option.internalBinaryWrite(message.options[i], writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* bool encoding_positions_set = 4; */
        if (message.encodingPositionsSet !== false)
            writer.tag(4, WireType.Varint).bool(message.encodingPositionsSet);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Schema
 */
export const Schema = new Schema$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Field$Type extends MessageType<Field> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Field", [
            { no: 1, name: "name", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "description", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "type", kind: "message", T: () => FieldType },
            { no: 4, name: "id", kind: "scalar", T: 5 /*ScalarType.INT32*/ },
            { no: 5, name: "encoding_position", kind: "scalar", T: 5 /*ScalarType.INT32*/ },
            { no: 6, name: "options", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => Option }
        ]);
    }
    create(value?: PartialMessage<Field>): Field {
        const message = { name: "", description: "", id: 0, encodingPosition: 0, options: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Field>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Field): Field {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string name */ 1:
                    message.name = reader.string();
                    break;
                case /* string description */ 2:
                    message.description = reader.string();
                    break;
                case /* org.apache.beam.model.pipeline.v1.FieldType type */ 3:
                    message.type = FieldType.internalBinaryRead(reader, reader.uint32(), options, message.type);
                    break;
                case /* int32 id */ 4:
                    message.id = reader.int32();
                    break;
                case /* int32 encoding_position */ 5:
                    message.encodingPosition = reader.int32();
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.Option options */ 6:
                    message.options.push(Option.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Field, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string name = 1; */
        if (message.name !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.name);
        /* string description = 2; */
        if (message.description !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.description);
        /* org.apache.beam.model.pipeline.v1.FieldType type = 3; */
        if (message.type)
            FieldType.internalBinaryWrite(message.type, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* int32 id = 4; */
        if (message.id !== 0)
            writer.tag(4, WireType.Varint).int32(message.id);
        /* int32 encoding_position = 5; */
        if (message.encodingPosition !== 0)
            writer.tag(5, WireType.Varint).int32(message.encodingPosition);
        /* repeated org.apache.beam.model.pipeline.v1.Option options = 6; */
        for (let i = 0; i < message.options.length; i++)
            Option.internalBinaryWrite(message.options[i], writer.tag(6, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Field
 */
export const Field = new Field$Type();
// @generated message type with reflection information, may provide speed optimized methods
class FieldType$Type extends MessageType<FieldType> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.FieldType", [
            { no: 1, name: "nullable", kind: "scalar", T: 8 /*ScalarType.BOOL*/ },
            { no: 2, name: "atomic_type", kind: "enum", oneof: "typeInfo", T: () => ["org.apache.beam.model.pipeline.v1.AtomicType", AtomicType] },
            { no: 3, name: "array_type", kind: "message", oneof: "typeInfo", T: () => ArrayType },
            { no: 4, name: "iterable_type", kind: "message", oneof: "typeInfo", T: () => IterableType },
            { no: 5, name: "map_type", kind: "message", oneof: "typeInfo", T: () => MapType },
            { no: 6, name: "row_type", kind: "message", oneof: "typeInfo", T: () => RowType },
            { no: 7, name: "logical_type", kind: "message", oneof: "typeInfo", T: () => LogicalType }
        ]);
    }
    create(value?: PartialMessage<FieldType>): FieldType {
        const message = { nullable: false, typeInfo: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<FieldType>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: FieldType): FieldType {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* bool nullable */ 1:
                    message.nullable = reader.bool();
                    break;
                case /* org.apache.beam.model.pipeline.v1.AtomicType atomic_type */ 2:
                    message.typeInfo = {
                        oneofKind: "atomicType",
                        atomicType: reader.int32()
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.ArrayType array_type */ 3:
                    message.typeInfo = {
                        oneofKind: "arrayType",
                        arrayType: ArrayType.internalBinaryRead(reader, reader.uint32(), options, (message.typeInfo as any).arrayType)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.IterableType iterable_type */ 4:
                    message.typeInfo = {
                        oneofKind: "iterableType",
                        iterableType: IterableType.internalBinaryRead(reader, reader.uint32(), options, (message.typeInfo as any).iterableType)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.MapType map_type */ 5:
                    message.typeInfo = {
                        oneofKind: "mapType",
                        mapType: MapType.internalBinaryRead(reader, reader.uint32(), options, (message.typeInfo as any).mapType)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.RowType row_type */ 6:
                    message.typeInfo = {
                        oneofKind: "rowType",
                        rowType: RowType.internalBinaryRead(reader, reader.uint32(), options, (message.typeInfo as any).rowType)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.LogicalType logical_type */ 7:
                    message.typeInfo = {
                        oneofKind: "logicalType",
                        logicalType: LogicalType.internalBinaryRead(reader, reader.uint32(), options, (message.typeInfo as any).logicalType)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: FieldType, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* bool nullable = 1; */
        if (message.nullable !== false)
            writer.tag(1, WireType.Varint).bool(message.nullable);
        /* org.apache.beam.model.pipeline.v1.AtomicType atomic_type = 2; */
        if (message.typeInfo.oneofKind === "atomicType")
            writer.tag(2, WireType.Varint).int32(message.typeInfo.atomicType);
        /* org.apache.beam.model.pipeline.v1.ArrayType array_type = 3; */
        if (message.typeInfo.oneofKind === "arrayType")
            ArrayType.internalBinaryWrite(message.typeInfo.arrayType, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.IterableType iterable_type = 4; */
        if (message.typeInfo.oneofKind === "iterableType")
            IterableType.internalBinaryWrite(message.typeInfo.iterableType, writer.tag(4, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.MapType map_type = 5; */
        if (message.typeInfo.oneofKind === "mapType")
            MapType.internalBinaryWrite(message.typeInfo.mapType, writer.tag(5, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.RowType row_type = 6; */
        if (message.typeInfo.oneofKind === "rowType")
            RowType.internalBinaryWrite(message.typeInfo.rowType, writer.tag(6, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.LogicalType logical_type = 7; */
        if (message.typeInfo.oneofKind === "logicalType")
            LogicalType.internalBinaryWrite(message.typeInfo.logicalType, writer.tag(7, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.FieldType
 */
export const FieldType = new FieldType$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ArrayType$Type extends MessageType<ArrayType> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ArrayType", [
            { no: 1, name: "element_type", kind: "message", T: () => FieldType }
        ]);
    }
    create(value?: PartialMessage<ArrayType>): ArrayType {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ArrayType>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ArrayType): ArrayType {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FieldType element_type */ 1:
                    message.elementType = FieldType.internalBinaryRead(reader, reader.uint32(), options, message.elementType);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ArrayType, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FieldType element_type = 1; */
        if (message.elementType)
            FieldType.internalBinaryWrite(message.elementType, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ArrayType
 */
export const ArrayType = new ArrayType$Type();
// @generated message type with reflection information, may provide speed optimized methods
class IterableType$Type extends MessageType<IterableType> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.IterableType", [
            { no: 1, name: "element_type", kind: "message", T: () => FieldType }
        ]);
    }
    create(value?: PartialMessage<IterableType>): IterableType {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<IterableType>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: IterableType): IterableType {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FieldType element_type */ 1:
                    message.elementType = FieldType.internalBinaryRead(reader, reader.uint32(), options, message.elementType);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: IterableType, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FieldType element_type = 1; */
        if (message.elementType)
            FieldType.internalBinaryWrite(message.elementType, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.IterableType
 */
export const IterableType = new IterableType$Type();
// @generated message type with reflection information, may provide speed optimized methods
class MapType$Type extends MessageType<MapType> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.MapType", [
            { no: 1, name: "key_type", kind: "message", T: () => FieldType },
            { no: 2, name: "value_type", kind: "message", T: () => FieldType }
        ]);
    }
    create(value?: PartialMessage<MapType>): MapType {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<MapType>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: MapType): MapType {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FieldType key_type */ 1:
                    message.keyType = FieldType.internalBinaryRead(reader, reader.uint32(), options, message.keyType);
                    break;
                case /* org.apache.beam.model.pipeline.v1.FieldType value_type */ 2:
                    message.valueType = FieldType.internalBinaryRead(reader, reader.uint32(), options, message.valueType);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: MapType, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FieldType key_type = 1; */
        if (message.keyType)
            FieldType.internalBinaryWrite(message.keyType, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.FieldType value_type = 2; */
        if (message.valueType)
            FieldType.internalBinaryWrite(message.valueType, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.MapType
 */
export const MapType = new MapType$Type();
// @generated message type with reflection information, may provide speed optimized methods
class RowType$Type extends MessageType<RowType> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.RowType", [
            { no: 1, name: "schema", kind: "message", T: () => Schema }
        ]);
    }
    create(value?: PartialMessage<RowType>): RowType {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<RowType>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: RowType): RowType {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.Schema schema */ 1:
                    message.schema = Schema.internalBinaryRead(reader, reader.uint32(), options, message.schema);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: RowType, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.Schema schema = 1; */
        if (message.schema)
            Schema.internalBinaryWrite(message.schema, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.RowType
 */
export const RowType = new RowType$Type();
// @generated message type with reflection information, may provide speed optimized methods
class LogicalType$Type extends MessageType<LogicalType> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.LogicalType", [
            { no: 1, name: "urn", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "payload", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 3, name: "representation", kind: "message", T: () => FieldType },
            { no: 4, name: "argument_type", kind: "message", T: () => FieldType },
            { no: 5, name: "argument", kind: "message", T: () => FieldValue }
        ]);
    }
    create(value?: PartialMessage<LogicalType>): LogicalType {
        const message = { urn: "", payload: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<LogicalType>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: LogicalType): LogicalType {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string urn */ 1:
                    message.urn = reader.string();
                    break;
                case /* bytes payload */ 2:
                    message.payload = reader.bytes();
                    break;
                case /* org.apache.beam.model.pipeline.v1.FieldType representation */ 3:
                    message.representation = FieldType.internalBinaryRead(reader, reader.uint32(), options, message.representation);
                    break;
                case /* org.apache.beam.model.pipeline.v1.FieldType argument_type */ 4:
                    message.argumentType = FieldType.internalBinaryRead(reader, reader.uint32(), options, message.argumentType);
                    break;
                case /* org.apache.beam.model.pipeline.v1.FieldValue argument */ 5:
                    message.argument = FieldValue.internalBinaryRead(reader, reader.uint32(), options, message.argument);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: LogicalType, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string urn = 1; */
        if (message.urn !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.urn);
        /* bytes payload = 2; */
        if (message.payload.length)
            writer.tag(2, WireType.LengthDelimited).bytes(message.payload);
        /* org.apache.beam.model.pipeline.v1.FieldType representation = 3; */
        if (message.representation)
            FieldType.internalBinaryWrite(message.representation, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.FieldType argument_type = 4; */
        if (message.argumentType)
            FieldType.internalBinaryWrite(message.argumentType, writer.tag(4, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.FieldValue argument = 5; */
        if (message.argument)
            FieldValue.internalBinaryWrite(message.argument, writer.tag(5, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.LogicalType
 */
export const LogicalType = new LogicalType$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Option$Type extends MessageType<Option> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Option", [
            { no: 1, name: "name", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "type", kind: "message", T: () => FieldType },
            { no: 3, name: "value", kind: "message", T: () => FieldValue }
        ]);
    }
    create(value?: PartialMessage<Option>): Option {
        const message = { name: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Option>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Option): Option {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string name */ 1:
                    message.name = reader.string();
                    break;
                case /* org.apache.beam.model.pipeline.v1.FieldType type */ 2:
                    message.type = FieldType.internalBinaryRead(reader, reader.uint32(), options, message.type);
                    break;
                case /* org.apache.beam.model.pipeline.v1.FieldValue value */ 3:
                    message.value = FieldValue.internalBinaryRead(reader, reader.uint32(), options, message.value);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Option, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string name = 1; */
        if (message.name !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.name);
        /* org.apache.beam.model.pipeline.v1.FieldType type = 2; */
        if (message.type)
            FieldType.internalBinaryWrite(message.type, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.FieldValue value = 3; */
        if (message.value)
            FieldValue.internalBinaryWrite(message.value, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Option
 */
export const Option = new Option$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Row$Type extends MessageType<Row> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Row", [
            { no: 1, name: "values", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => FieldValue }
        ]);
    }
    create(value?: PartialMessage<Row>): Row {
        const message = { values: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Row>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Row): Row {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.pipeline.v1.FieldValue values */ 1:
                    message.values.push(FieldValue.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Row, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.pipeline.v1.FieldValue values = 1; */
        for (let i = 0; i < message.values.length; i++)
            FieldValue.internalBinaryWrite(message.values[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Row
 */
export const Row = new Row$Type();
// @generated message type with reflection information, may provide speed optimized methods
class FieldValue$Type extends MessageType<FieldValue> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.FieldValue", [
            { no: 1, name: "atomic_value", kind: "message", oneof: "fieldValue", T: () => AtomicTypeValue },
            { no: 2, name: "array_value", kind: "message", oneof: "fieldValue", T: () => ArrayTypeValue },
            { no: 3, name: "iterable_value", kind: "message", oneof: "fieldValue", T: () => IterableTypeValue },
            { no: 4, name: "map_value", kind: "message", oneof: "fieldValue", T: () => MapTypeValue },
            { no: 5, name: "row_value", kind: "message", oneof: "fieldValue", T: () => Row },
            { no: 6, name: "logical_type_value", kind: "message", oneof: "fieldValue", T: () => LogicalTypeValue }
        ]);
    }
    create(value?: PartialMessage<FieldValue>): FieldValue {
        const message = { fieldValue: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<FieldValue>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: FieldValue): FieldValue {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.AtomicTypeValue atomic_value */ 1:
                    message.fieldValue = {
                        oneofKind: "atomicValue",
                        atomicValue: AtomicTypeValue.internalBinaryRead(reader, reader.uint32(), options, (message.fieldValue as any).atomicValue)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.ArrayTypeValue array_value */ 2:
                    message.fieldValue = {
                        oneofKind: "arrayValue",
                        arrayValue: ArrayTypeValue.internalBinaryRead(reader, reader.uint32(), options, (message.fieldValue as any).arrayValue)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.IterableTypeValue iterable_value */ 3:
                    message.fieldValue = {
                        oneofKind: "iterableValue",
                        iterableValue: IterableTypeValue.internalBinaryRead(reader, reader.uint32(), options, (message.fieldValue as any).iterableValue)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.MapTypeValue map_value */ 4:
                    message.fieldValue = {
                        oneofKind: "mapValue",
                        mapValue: MapTypeValue.internalBinaryRead(reader, reader.uint32(), options, (message.fieldValue as any).mapValue)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.Row row_value */ 5:
                    message.fieldValue = {
                        oneofKind: "rowValue",
                        rowValue: Row.internalBinaryRead(reader, reader.uint32(), options, (message.fieldValue as any).rowValue)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.LogicalTypeValue logical_type_value */ 6:
                    message.fieldValue = {
                        oneofKind: "logicalTypeValue",
                        logicalTypeValue: LogicalTypeValue.internalBinaryRead(reader, reader.uint32(), options, (message.fieldValue as any).logicalTypeValue)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: FieldValue, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.AtomicTypeValue atomic_value = 1; */
        if (message.fieldValue.oneofKind === "atomicValue")
            AtomicTypeValue.internalBinaryWrite(message.fieldValue.atomicValue, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.ArrayTypeValue array_value = 2; */
        if (message.fieldValue.oneofKind === "arrayValue")
            ArrayTypeValue.internalBinaryWrite(message.fieldValue.arrayValue, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.IterableTypeValue iterable_value = 3; */
        if (message.fieldValue.oneofKind === "iterableValue")
            IterableTypeValue.internalBinaryWrite(message.fieldValue.iterableValue, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.MapTypeValue map_value = 4; */
        if (message.fieldValue.oneofKind === "mapValue")
            MapTypeValue.internalBinaryWrite(message.fieldValue.mapValue, writer.tag(4, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Row row_value = 5; */
        if (message.fieldValue.oneofKind === "rowValue")
            Row.internalBinaryWrite(message.fieldValue.rowValue, writer.tag(5, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.LogicalTypeValue logical_type_value = 6; */
        if (message.fieldValue.oneofKind === "logicalTypeValue")
            LogicalTypeValue.internalBinaryWrite(message.fieldValue.logicalTypeValue, writer.tag(6, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.FieldValue
 */
export const FieldValue = new FieldValue$Type();
// @generated message type with reflection information, may provide speed optimized methods
class AtomicTypeValue$Type extends MessageType<AtomicTypeValue> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.AtomicTypeValue", [
            { no: 1, name: "byte", kind: "scalar", oneof: "value", T: 5 /*ScalarType.INT32*/ },
            { no: 2, name: "int16", kind: "scalar", oneof: "value", T: 5 /*ScalarType.INT32*/ },
            { no: 3, name: "int32", kind: "scalar", oneof: "value", T: 5 /*ScalarType.INT32*/ },
            { no: 4, name: "int64", kind: "scalar", oneof: "value", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ },
            { no: 5, name: "float", kind: "scalar", oneof: "value", T: 2 /*ScalarType.FLOAT*/ },
            { no: 6, name: "double", kind: "scalar", oneof: "value", T: 1 /*ScalarType.DOUBLE*/ },
            { no: 7, name: "string", kind: "scalar", oneof: "value", T: 9 /*ScalarType.STRING*/ },
            { no: 8, name: "boolean", kind: "scalar", oneof: "value", T: 8 /*ScalarType.BOOL*/ },
            { no: 9, name: "bytes", kind: "scalar", oneof: "value", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<AtomicTypeValue>): AtomicTypeValue {
        const message = { value: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<AtomicTypeValue>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: AtomicTypeValue): AtomicTypeValue {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* int32 byte */ 1:
                    message.value = {
                        oneofKind: "byte",
                        byte: reader.int32()
                    };
                    break;
                case /* int32 int16 */ 2:
                    message.value = {
                        oneofKind: "int16",
                        int16: reader.int32()
                    };
                    break;
                case /* int32 int32 */ 3:
                    message.value = {
                        oneofKind: "int32",
                        int32: reader.int32()
                    };
                    break;
                case /* int64 int64 */ 4:
                    message.value = {
                        oneofKind: "int64",
                        int64: reader.int64().toBigInt()
                    };
                    break;
                case /* float float */ 5:
                    message.value = {
                        oneofKind: "float",
                        float: reader.float()
                    };
                    break;
                case /* double double */ 6:
                    message.value = {
                        oneofKind: "double",
                        double: reader.double()
                    };
                    break;
                case /* string string */ 7:
                    message.value = {
                        oneofKind: "string",
                        string: reader.string()
                    };
                    break;
                case /* bool boolean */ 8:
                    message.value = {
                        oneofKind: "boolean",
                        boolean: reader.bool()
                    };
                    break;
                case /* bytes bytes */ 9:
                    message.value = {
                        oneofKind: "bytes",
                        bytes: reader.bytes()
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: AtomicTypeValue, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* int32 byte = 1; */
        if (message.value.oneofKind === "byte")
            writer.tag(1, WireType.Varint).int32(message.value.byte);
        /* int32 int16 = 2; */
        if (message.value.oneofKind === "int16")
            writer.tag(2, WireType.Varint).int32(message.value.int16);
        /* int32 int32 = 3; */
        if (message.value.oneofKind === "int32")
            writer.tag(3, WireType.Varint).int32(message.value.int32);
        /* int64 int64 = 4; */
        if (message.value.oneofKind === "int64")
            writer.tag(4, WireType.Varint).int64(message.value.int64);
        /* float float = 5; */
        if (message.value.oneofKind === "float")
            writer.tag(5, WireType.Bit32).float(message.value.float);
        /* double double = 6; */
        if (message.value.oneofKind === "double")
            writer.tag(6, WireType.Bit64).double(message.value.double);
        /* string string = 7; */
        if (message.value.oneofKind === "string")
            writer.tag(7, WireType.LengthDelimited).string(message.value.string);
        /* bool boolean = 8; */
        if (message.value.oneofKind === "boolean")
            writer.tag(8, WireType.Varint).bool(message.value.boolean);
        /* bytes bytes = 9; */
        if (message.value.oneofKind === "bytes")
            writer.tag(9, WireType.LengthDelimited).bytes(message.value.bytes);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.AtomicTypeValue
 */
export const AtomicTypeValue = new AtomicTypeValue$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ArrayTypeValue$Type extends MessageType<ArrayTypeValue> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ArrayTypeValue", [
            { no: 1, name: "element", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => FieldValue }
        ]);
    }
    create(value?: PartialMessage<ArrayTypeValue>): ArrayTypeValue {
        const message = { element: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ArrayTypeValue>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ArrayTypeValue): ArrayTypeValue {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.pipeline.v1.FieldValue element */ 1:
                    message.element.push(FieldValue.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ArrayTypeValue, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.pipeline.v1.FieldValue element = 1; */
        for (let i = 0; i < message.element.length; i++)
            FieldValue.internalBinaryWrite(message.element[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ArrayTypeValue
 */
export const ArrayTypeValue = new ArrayTypeValue$Type();
// @generated message type with reflection information, may provide speed optimized methods
class IterableTypeValue$Type extends MessageType<IterableTypeValue> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.IterableTypeValue", [
            { no: 1, name: "element", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => FieldValue }
        ]);
    }
    create(value?: PartialMessage<IterableTypeValue>): IterableTypeValue {
        const message = { element: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<IterableTypeValue>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: IterableTypeValue): IterableTypeValue {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.pipeline.v1.FieldValue element */ 1:
                    message.element.push(FieldValue.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: IterableTypeValue, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.pipeline.v1.FieldValue element = 1; */
        for (let i = 0; i < message.element.length; i++)
            FieldValue.internalBinaryWrite(message.element[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.IterableTypeValue
 */
export const IterableTypeValue = new IterableTypeValue$Type();
// @generated message type with reflection information, may provide speed optimized methods
class MapTypeValue$Type extends MessageType<MapTypeValue> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.MapTypeValue", [
            { no: 1, name: "entries", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => MapTypeEntry }
        ]);
    }
    create(value?: PartialMessage<MapTypeValue>): MapTypeValue {
        const message = { entries: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<MapTypeValue>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: MapTypeValue): MapTypeValue {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.pipeline.v1.MapTypeEntry entries */ 1:
                    message.entries.push(MapTypeEntry.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: MapTypeValue, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.pipeline.v1.MapTypeEntry entries = 1; */
        for (let i = 0; i < message.entries.length; i++)
            MapTypeEntry.internalBinaryWrite(message.entries[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.MapTypeValue
 */
export const MapTypeValue = new MapTypeValue$Type();
// @generated message type with reflection information, may provide speed optimized methods
class MapTypeEntry$Type extends MessageType<MapTypeEntry> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.MapTypeEntry", [
            { no: 1, name: "key", kind: "message", T: () => FieldValue },
            { no: 2, name: "value", kind: "message", T: () => FieldValue }
        ]);
    }
    create(value?: PartialMessage<MapTypeEntry>): MapTypeEntry {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<MapTypeEntry>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: MapTypeEntry): MapTypeEntry {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FieldValue key */ 1:
                    message.key = FieldValue.internalBinaryRead(reader, reader.uint32(), options, message.key);
                    break;
                case /* org.apache.beam.model.pipeline.v1.FieldValue value */ 2:
                    message.value = FieldValue.internalBinaryRead(reader, reader.uint32(), options, message.value);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: MapTypeEntry, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FieldValue key = 1; */
        if (message.key)
            FieldValue.internalBinaryWrite(message.key, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.FieldValue value = 2; */
        if (message.value)
            FieldValue.internalBinaryWrite(message.value, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.MapTypeEntry
 */
export const MapTypeEntry = new MapTypeEntry$Type();
// @generated message type with reflection information, may provide speed optimized methods
class LogicalTypeValue$Type extends MessageType<LogicalTypeValue> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.LogicalTypeValue", [
            { no: 1, name: "value", kind: "message", T: () => FieldValue }
        ]);
    }
    create(value?: PartialMessage<LogicalTypeValue>): LogicalTypeValue {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<LogicalTypeValue>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: LogicalTypeValue): LogicalTypeValue {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FieldValue value */ 1:
                    message.value = FieldValue.internalBinaryRead(reader, reader.uint32(), options, message.value);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: LogicalTypeValue, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FieldValue value = 1; */
        if (message.value)
            FieldValue.internalBinaryWrite(message.value, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.LogicalTypeValue
 */
export const LogicalTypeValue = new LogicalTypeValue$Type();
