/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import java.io.IOException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(Recovery.class);

    public static boolean recover(final String name, final XADataSource dataSource, RecoverableTransactionManager transactionManager) throws IOException {
        if (name != null && name.length() > 0) {
            transactionManager.registerNamedXAResourceFactory(new NamedXAResourceFactory(){

                public String getName() {
                    return name;
                }

                public NamedXAResource getNamedXAResource() throws SystemException {
                    try {
                        XAConnection connection = dataSource.getXAConnection();
                        LOGGER.debug("new namedXAResource's connection: " + connection);
                        return new ConnectionAndWrapperNamedXAResource(connection.getXAResource(), this.getName(), connection);
                    }
                    catch (Exception e) {
                        SystemException se = new SystemException("Failed to create ConnectionAndWrapperNamedXAResource, " + e.getLocalizedMessage());
                        se.initCause((Throwable)e);
                        LOGGER.error(se.getLocalizedMessage(), (Throwable)se);
                        throw se;
                    }
                }

                public void returnNamedXAResource(NamedXAResource namedXaResource) {
                    if (namedXaResource instanceof ConnectionAndWrapperNamedXAResource) {
                        try {
                            LOGGER.debug("closing returned namedXAResource's connection: " + ((ConnectionAndWrapperNamedXAResource)namedXaResource).connection);
                            ((ConnectionAndWrapperNamedXAResource)namedXaResource).connection.close();
                        }
                        catch (Exception ignored) {
                            LOGGER.debug("failed to close returned namedXAResource: " + namedXaResource, (Throwable)ignored);
                        }
                    }
                }
            });
            return true;
        }
        LOGGER.warn("Unable to recover XADataSource: aries.xa.name property not set");
        return false;
    }

    public static class ConnectionAndWrapperNamedXAResource
    extends WrapperNamedXAResource {
        final XAConnection connection;

        public ConnectionAndWrapperNamedXAResource(XAResource xaResource, String name, XAConnection connection) {
            super(xaResource, name);
            this.connection = connection;
        }
    }
}

