/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.lang.reflect.Field;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.aries.blueprint.plugin.model.Bean;
import org.apache.aries.blueprint.plugin.model.Matcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class Property
implements Comparable<Property> {
    public String name;
    public String ref;
    public String value;

    public Property(String name, String ref, String value) {
        this.name = name;
        this.ref = ref;
        this.value = value;
    }

    public static Property create(Matcher matcher, Field field) {
        Value value = field.getAnnotation(Value.class);
        if (Property.needsInject(field)) {
            Bean matching = matcher.getMatching(field);
            String ref = matching == null ? Property.getRefName(field) : matching.id;
            return new Property(field.getName(), ref, null);
        }
        if (value != null) {
            return new Property(field.getName(), null, Property.cleanValue(value.value()));
        }
        return null;
    }

    private static String getRefName(Field field) {
        Named named = field.getAnnotation(Named.class);
        if (named != null) {
            return named.value();
        }
        Qualifier qualifier = field.getAnnotation(Qualifier.class);
        if (qualifier != null) {
            return qualifier.value();
        }
        return Bean.getBeanName(field.getType());
    }

    private static boolean needsInject(Field field) {
        return field.getAnnotation(Autowired.class) != null || field.getAnnotation(Inject.class) != null;
    }

    private static String cleanValue(String value) {
        return value.replaceAll("\\:.*\\}", "}");
    }

    @Override
    public int compareTo(Property other) {
        return this.name.compareTo(other.name);
    }
}

